/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.config;

import fathertoast.deadlyworld.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;

public class WeightedRandomConfig {
    private final int TOTAL_WEIGHT;
    private final List<Item> ITEMS = new ArrayList<Item>();

    public WeightedRandomConfig(String line) {
        this(line.split(","));
    }

    WeightedRandomConfig(String[] list) {
        for (String item : list) {
            int weight;
            String entry;
            int i = item.lastIndexOf(32);
            if (i < 0) {
                Config.log.error("No weight specified for entry '{}' (Format must be 'registry_name weight')", (Object)item);
                entry = item;
                weight = 0;
            } else {
                entry = item.substring(0, i).trim();
                String weightString = item.substring(i + 1).trim();
                try {
                    weight = Integer.parseInt(weightString);
                }
                catch (NumberFormatException ex) {
                    Config.log.error("Invalid weight for config entry 'registry_name={},weight={}'", (Object)entry, (Object)weightString);
                    weight = 0;
                }
            }
            this.ITEMS.add(new Item(new ResourceLocation(entry), weight));
        }
        this.TOTAL_WEIGHT = WeightedRandom.func_76272_a(this.ITEMS);
    }

    public ResourceLocation nextItem(Random random) {
        return this.TOTAL_WEIGHT <= 0 ? null : ((Item)WeightedRandom.func_76273_a((Random)random, this.ITEMS, (int)this.TOTAL_WEIGHT)).itemResource;
    }

    public String toString() {
        if (this.ITEMS.size() <= 0) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (Item item : this.ITEMS) {
            str.append((Object)item).append(',');
        }
        return str.substring(0, str.length() - 1);
    }

    public String[] toStringArray() {
        String[] array = new String[this.ITEMS.size()];
        for (int i = 0; i < this.ITEMS.size(); ++i) {
            array[i] = this.ITEMS.get(i).toString();
        }
        return array;
    }

    static class Item
    extends WeightedRandom.Item {
        private final ResourceLocation itemResource;

        Item(Class<? extends Entity> entityClass, int weight) {
            this(EntityList.func_191306_a(entityClass), weight);
        }

        private Item(ResourceLocation resource, int weight) {
            super(weight);
            this.itemResource = resource;
        }

        public String toString() {
            return this.itemResource.toString() + " " + this.field_76292_a;
        }
    }
}

