/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.util.WeightedRandom;

public class WeightedEnumConfig<T extends Enum<T>> {
    private final int TOTAL_WEIGHT;
    private final List<Item<T>> ITEMS = new ArrayList<Item<T>>();

    WeightedEnumConfig(Collection<Item<T>> items) {
        this.ITEMS.addAll(items);
        this.TOTAL_WEIGHT = WeightedRandom.func_76272_a(this.ITEMS);
    }

    public T nextItem(Random random) {
        return (T)(this.TOTAL_WEIGHT <= 0 ? null : ((Item)WeightedRandom.func_76273_a((Random)random, this.ITEMS, (int)this.TOTAL_WEIGHT)).itemValue);
    }

    public String toString() {
        if (this.ITEMS.size() <= 0) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (Item<T> item : this.ITEMS) {
            str.append(item).append(',');
        }
        return str.substring(0, str.length() - 1);
    }

    public String[] toStringArray() {
        String[] array = new String[this.ITEMS.size()];
        for (int i = 0; i < this.ITEMS.size(); ++i) {
            array[i] = this.ITEMS.get(i).toString();
        }
        return array;
    }

    public static interface Meta {
        public int defaultWeight();
    }

    static class Item<T extends Enum<T>>
    extends WeightedRandom.Item {
        private final T itemValue;

        Item(T value, int weight) {
            super(weight);
            this.itemValue = value;
        }

        public String toString() {
            return ((Enum)this.itemValue).toString() + " " + this.field_76292_a;
        }
    }
}

