/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.config;

import com.google.common.base.Optional;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.config.TargetBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;

public class WeightedBlockConfig
extends WeightedRandom.Item {
    public final IBlockState BLOCK_STATE;

    public static BlockList newTargetDefinition(String line) {
        String[] fragmentedStates = line.split(",");
        ArrayList<String> repairedStates = new ArrayList<String>();
        for (int i = 0; i < fragmentedStates.length; ++i) {
            String fragment = fragmentedStates[i].trim();
            if (!fragment.contains("]") && fragment.contains("[")) {
                boolean completed = false;
                StringBuilder rebuilder = new StringBuilder(fragment);
                ++i;
                while (i < fragmentedStates.length) {
                    String subfragment = fragmentedStates[i].trim();
                    rebuilder.append(",").append(subfragment);
                    if (subfragment.contains("]")) {
                        completed = true;
                        break;
                    }
                    ++i;
                }
                fragment = rebuilder.toString();
                if (!completed) {
                    Config.log.warn("Reached end of line while parsing block state '{}' from single-line target ({})", (Object)fragment, (Object)line);
                    continue;
                }
            }
            if (fragment.isEmpty()) continue;
            repairedStates.add(fragment);
        }
        return WeightedBlockConfig.newTargetDefinition(repairedStates.toArray(new String[0]));
    }

    public static BlockList newTargetDefinition(String[] targetableBlockStates) {
        ArrayList<WeightedBlockConfig> itemList = new ArrayList<WeightedBlockConfig>();
        for (String line : targetableBlockStates) {
            int weight;
            String item;
            int i = line.lastIndexOf(32);
            if (i < 0) {
                Config.log.error("No weight specified for entry '{}' (Format must be 'registry_name weight')", (Object)line);
                item = line;
                weight = 0;
            } else {
                item = line.substring(0, i).trim();
                String weightString = line.substring(i + 1).trim();
                try {
                    weight = Integer.parseInt(weightString);
                }
                catch (NumberFormatException ex) {
                    Config.log.error("Invalid weight for config entry 'registry_name={},weight={}'", (Object)item, (Object)weightString);
                    weight = 0;
                }
            }
            WeightedBlockConfig targetBlock = new WeightedBlockConfig(item, weight);
            if (targetBlock.BLOCK_STATE.func_177230_c() == Blocks.field_150350_a) continue;
            itemList.add(targetBlock);
        }
        return new BlockList(itemList);
    }

    private static IBlockState parseState(Block block, String propList) {
        String[] properties;
        IBlockState blockState = block.func_176223_P();
        if (propList.isEmpty()) {
            return blockState;
        }
        BlockStateContainer stateContainer = block.func_176194_O();
        for (String combinedEntry : properties = propList.split(",")) {
            String[] entry = combinedEntry.split("=", 2);
            if (entry.length != 2) {
                Config.log.warn("Invalid block property entry '{}' - format must follow 'property=value'", (Object)combinedEntry);
                continue;
            }
            if (entry[1].equals("*")) {
                Config.log.warn("Invalid block property entry '{}' - '*' operation is not valid for this config", (Object)combinedEntry);
                continue;
            }
            IProperty property = stateContainer.func_185920_a(entry[0]);
            if (property == null) {
                Config.log.warn("Invalid block property key '{}' for block '{}'", (Object)entry[0], (Object)block.getRegistryName());
                continue;
            }
            Optional value = property.func_185929_b(entry[1]);
            if (value == null || !value.isPresent()) {
                Config.log.warn("Invalid block property value '{}' for property key '{}' and block '{}'", (Object)entry[1], (Object)entry[0], (Object)block.getRegistryName());
                continue;
            }
            blockState = WeightedBlockConfig.appendProperty(blockState, property, (Comparable)value.get());
        }
        return blockState;
    }

    private static <T extends Comparable<T>> IBlockState appendProperty(IBlockState blockState, IProperty<T> property, Comparable<?> value) {
        return blockState.func_177226_a(property, value);
    }

    private static <T extends Comparable<T>> String getValueName(IBlockState blockState, IProperty<T> property) {
        return property.func_177702_a(blockState.func_177229_b(property));
    }

    public WeightedBlockConfig(Block block, int weight) {
        this(block.func_176223_P(), weight);
    }

    public WeightedBlockConfig(IBlockState block, int weight) {
        super(weight);
        this.BLOCK_STATE = block;
    }

    private WeightedBlockConfig(String item, int weight) {
        super(weight);
        String[] pair = item.split("\\[", 2);
        Block block = TargetBlock.parseBlock(pair[0]);
        if (block == Blocks.field_150350_a || pair.length < 2 || pair[1].equalsIgnoreCase("normal]") || pair[1].equalsIgnoreCase("default]")) {
            this.BLOCK_STATE = block.func_176223_P();
        } else if (!pair[1].endsWith("]")) {
            Config.log.warn("Ignoring properties for broken weighted blockstate definition '{}' (no end bracket found)", (Object)item);
            this.BLOCK_STATE = Blocks.field_150350_a.func_176223_P();
        } else {
            this.BLOCK_STATE = WeightedBlockConfig.parseState(block, pair[1].substring(0, pair[1].length() - 1));
        }
    }

    public String toString() {
        String registryName = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.BLOCK_STATE.func_177230_c())).toString();
        if (this.BLOCK_STATE.equals(this.BLOCK_STATE.func_177230_c().func_176223_P())) {
            return registryName + " " + this.field_76292_a;
        }
        StringBuilder str = new StringBuilder();
        str.append(registryName).append("[");
        for (IProperty property : this.BLOCK_STATE.func_177227_a()) {
            str.append(property.func_177701_a()).append('=').append(WeightedBlockConfig.getValueName(this.BLOCK_STATE, property)).append(',');
        }
        return str.substring(0, str.length() - 1) + "] " + this.field_76292_a;
    }

    public static final class BlockList {
        public final int TOTAL_WEIGHT;
        private final List<WeightedBlockConfig> ITEMS;

        public BlockList(List<WeightedBlockConfig> items) {
            this.ITEMS = items;
            this.TOTAL_WEIGHT = WeightedRandom.func_76272_a(items);
        }

        public IBlockState nextBlock(Random random) {
            return this.TOTAL_WEIGHT > 0 ? ((WeightedBlockConfig)WeightedRandom.func_76273_a((Random)random, this.ITEMS, (int)this.TOTAL_WEIGHT)).BLOCK_STATE : null;
        }

        public IBlockState nextBlock(Random random, Block defaultBlock) {
            return this.nextBlock(random, defaultBlock.func_176223_P());
        }

        public IBlockState nextBlock(Random random, IBlockState defaultBlock) {
            return this.TOTAL_WEIGHT > 0 ? ((WeightedBlockConfig)WeightedRandom.func_76273_a((Random)random, this.ITEMS, (int)this.TOTAL_WEIGHT)).BLOCK_STATE : defaultBlock;
        }

        public String toString() {
            if (this.ITEMS.size() <= 0) {
                return "";
            }
            StringBuilder str = new StringBuilder();
            for (WeightedBlockConfig item : this.ITEMS) {
                str.append((Object)item).append(',');
            }
            return str.substring(0, str.length() - 1);
        }
    }
}

