/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.config;

import fathertoast.deadlyworld.block.state.EnumFloorTrapType;
import fathertoast.deadlyworld.block.state.EnumSpawnerType;
import fathertoast.deadlyworld.block.state.EnumTowerType;
import fathertoast.deadlyworld.config.EntityListConfig;
import fathertoast.deadlyworld.config.EntryEntity;
import fathertoast.deadlyworld.config.EnvironmentListConfig;
import fathertoast.deadlyworld.config.TargetBlock;
import fathertoast.deadlyworld.config.TargetEnvironment;
import fathertoast.deadlyworld.config.WeightedBlockConfig;
import fathertoast.deadlyworld.config.WeightedEnumConfig;
import fathertoast.deadlyworld.config.WeightedRandomConfig;
import fathertoast.deadlyworld.featuregen.EnumDungeonSubfeature;
import fathertoast.deadlyworld.item.EnumPotionCloudType;
import fathertoast.deadlyworld.tileentity.EnumChestType;
import fathertoast.deadlyworld.tileentity.EnumPotionArrowType;
import fathertoast.deadlyworld.tileentity.EnumPotionTrapType;
import fathertoast.deadlyworld.tileentity.EnumSurpriseChestType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final String FILE_EXT = ".cfg";
    static Logger log;
    private static int dimensionLoading;
    private static Configuration configLoading;
    private static Config INSTANCE;
    private static final DimensionType MAIN_DIM;
    private static boolean ENABLED_FOR_MAIN_DIM;
    private static final HashMap<Integer, Config> DIMENSION_INSTANCES;
    public final GENERAL GENERAL = dimensionLoading == MAIN_DIM.func_186068_a() ? new GENERAL() : null;
    public final TERRAIN TERRAIN = new TERRAIN();
    public final VEINS VEINS = new VEINS();
    public final VeinConfig VEIN_LAVA = new VeinConfig("lava", dimensionLoading == DimensionType.OVERWORLD.func_186068_a() ? 4.0f : 16.0f, 0, dimensionLoading == DimensionType.OVERWORLD.func_186068_a() ? 32 : 128, 3);
    public final VeinConfig VEIN_SAND = new VeinConfig("sand", dimensionLoading == DimensionType.OVERWORLD.func_186068_a() ? 0.25f : 0.0f, 0, 62, 33);
    public final VeinConfig VEIN_SILVERFISH = new VeinConfig("silverfish", 10.0f, 5, 256, 25);
    public final VeinConfig VEIN_WATER = new VeinConfig("water", dimensionLoading == DimensionType.OVERWORLD.func_186068_a() ? 6.0f : 0.0f, 0, 62, 7);
    public final VeinConfig VEIN_DIRT = new VeinReplacement("dirt", 10, 0, 256, 33);
    public final VeinConfig VEIN_GRAVEL = new VeinReplacement("gravel", 8, 0, 256, 33);
    public final VeinConfig VEIN_DIORITE = new VeinReplacement("diorite", 10, 0, 80, 33);
    public final VeinConfig VEIN_GRANITE = new VeinReplacement("granite", 10, 0, 80, 33);
    public final VeinConfig VEIN_ANDESITE = new VeinReplacement("andesite", 10, 0, 80, 33);
    public final VeinConfig VEIN_COAL = new VeinReplacement("coal", 20, 0, 128, 17);
    public final VeinConfig VEIN_QUARTZ = new VeinReplacement("quartz", 16, 10, 118, 14);
    public final VeinConfig VEIN_IRON = new VeinReplacement("iron", 20, 0, 64, 9);
    public final VeinConfig VEIN_GOLD = new VeinReplacement("gold", 2, 0, 32, 9);
    public final VeinConfig VEIN_REDSTONE = new VeinReplacement("redstone", 8, 0, 16, 8);
    public final VeinConfig VEIN_DIAMOND = new VeinReplacement("diamond", 1, 0, 16, 8);
    public final VeinConfig VEIN_LAPIS = new VeinReplacement("lapis", 1, 0, 32, 7);
    public final VeinConfig VEIN_EMERALD = new VeinReplacement("emerald", 4, 4, 32, 1);
    public final DUNGEONS DUNGEONS = new DUNGEONS("dungeons", 8.0f, 0, 256);
    public final SPAWNER_DUNGEON SPAWNER_DUNGEON = new SPAWNER_DUNGEON(EnumSpawnerType.DUNGEON, 16.0f, false, 200, 800, 40, 4, 4.0f);
    private static final float PLACEMENTS_CHESTS_COMMON = 0.1f;
    private static final float PLACEMENTS_CHESTS_UNCOMMON = 0.04f;
    private static final float PLACEMENTS_CHESTS_RARE = 0.02f;
    public final FeatureChest CHEST_DEFAULT = new FeatureChest(EnumChestType.DEFAULT, 0.1f, 12, 52, 0.1f);
    public final CHEST_VALUABLE CHEST_VALUABLE = new CHEST_VALUABLE(EnumChestType.VALUABLE, 0.02f, 12, 32, 0.0f);
    public final FeatureChest CHEST_TRAPPED = new FeatureChest(EnumChestType.TRAPPED, 0.0f, 12, 52, Float.NaN);
    public final FeatureChest CHEST_TNT_FLOOR_TRAP = new FeatureChest(EnumChestType.TNT_FLOOR_TRAP, 0.04f, 12, 52, 0.0f);
    public final CHEST_INFESTED CHEST_INFESTED = new CHEST_INFESTED(EnumChestType.INFESTED, 0.04f, 12, 60, 1.0f);
    public final CHEST_SURPRISE CHEST_SURPRISE = new CHEST_SURPRISE(EnumChestType.SURPRISE, 0.04f, 12, 52, 1.0f);
    public final CHEST_MIMIC CHEST_MIMIC = new CHEST_MIMIC(EnumChestType.MIMIC, 0.02f, 12, 52, 0.1f);
    private static final float PLACEMENTS_SPAWNERS_COMMON = 0.16f;
    private static final float PLACEMENTS_SPAWNERS_UNCOMMON = 0.04f;
    private static final float PLACEMENTS_SPAWNERS_RARE = 0.02f;
    public final FeatureSpawner SPAWNER_DEFAULT = new FeatureSpawner(EnumSpawnerType.DEFAULT, 0.33f, 0.16f, 12, 52, 16.0f, false, 200, 800, 40, 4, 4.0f, null);
    public final FeatureSpawner SPAWNER_STREAM = new FeatureSpawner(EnumSpawnerType.STREAM, 1.0f, 0.04f, 12, 42, 16.0f, true, 0, 400, 10, 1, 2.0f, Blocks.field_180395_cM.func_176223_P().func_177226_a((IProperty)BlockRedSandstone.field_176336_a, (Comparable)BlockRedSandstone.EnumType.CHISELED));
    public final FeatureSpawner SPAWNER_SWARM = new FeatureSpawner(EnumSpawnerType.SWARM, 1.0f, 0.02f, 12, 32, 20.0f, true, 400, 2400, 100, 12, 8.0f, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED));
    public final SPAWNER_BRUTAL SPAWNER_BRUTAL = new SPAWNER_BRUTAL(EnumSpawnerType.BRUTAL, 1.0f, 0.02f, 12, 32, 16.0f, true, 200, 800, 100, 2, 3.0f, Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED));
    public final SILVERFISH_NEST SILVERFISH_NEST = new SILVERFISH_NEST(EnumSpawnerType.SILVERFISH_NEST, 0.33f, 0.16f, 12, 62, 16.0f, false, 100, 400, 20, 6, 6.0f);
    private static final float PLACEMENTS_FLOOR_TRAPS_COMMON = 0.2f;
    private static final float PLACEMENTS_FLOOR_TRAPS_UNCOMMON = 0.1f;
    public final FLOOR_TRAP_TNT FLOOR_TRAP_TNT = new FLOOR_TRAP_TNT(EnumFloorTrapType.TNT, 0.2f, 12, 60);
    public final FLOOR_TRAP_TNT_MOB FLOOR_TRAP_TNT_MOB = new FLOOR_TRAP_TNT_MOB(EnumFloorTrapType.TNT_MOB, 0.1f, 12, 60);
    public final FLOOR_TRAP_POTION FLOOR_TRAP_POTION = new FLOOR_TRAP_POTION(EnumFloorTrapType.POTION, 0.2f, 12, 60);
    private static final float PLACEMENTS_TOWERS_COMMON = 0.16f;
    private static final float PLACEMENTS_TOWERS_UNCOMMON = 0.04f;
    private static final float PLACEMENTS_TOWERS_RARE = 0.02f;
    public final FeatureTower TOWER_DEFAULT = new FeatureTower(EnumTowerType.DEFAULT, 0.16f, 12, 60, 8.0f, 1.5f, 6.0f, 20, 60);
    public final FeatureTower TOWER_FIRE = new FeatureTower(EnumTowerType.FIRE, 0.04f, 12, 52, 6.0f, 1.5f, 6.0f, 20, 60);
    public final TOWER_POTION TOWER_POTION = new TOWER_POTION(EnumTowerType.POTION, 0.04f, 12, 42, 6.0f, 1.0f, 6.0f, 20, 60);
    public final FeatureTower TOWER_GATLING = new FeatureTower(EnumTowerType.GATLING, 0.02f, 12, 32, 4.0f, 1.0f, 18.0f, 11, 22);
    public final FeatureTower TOWER_FIREBALL = new FeatureTower(EnumTowerType.FIREBALL, 0.02f, 12, 32, 3.0f, 1.0f, 8.0f, 20, 40);

    public static Config get() {
        return INSTANCE;
    }

    @Nullable
    public static Config get(World world) {
        int dimId;
        int n = dimId = world.field_73011_w.func_186058_p() == null ? world.field_73011_w.getDimension() : world.field_73011_w.func_186058_p().func_186068_a();
        if (dimId == MAIN_DIM.func_186068_a()) {
            return ENABLED_FOR_MAIN_DIM ? Config.get() : null;
        }
        return DIMENSION_INSTANCES.get(dimId);
    }

    public static Config getOrDefault(World world) {
        Config dimConfig = Config.get(world);
        return dimConfig != null ? dimConfig : Config.get();
    }

    public static List<Config> getAllEnabled() {
        ArrayList<Config> configs = new ArrayList<Config>();
        if (ENABLED_FOR_MAIN_DIM) {
            configs.add(INSTANCE);
        }
        configs.addAll(DIMENSION_INSTANCES.values());
        return configs;
    }

    public static String getDimensionKey(World world) {
        return world.field_73011_w.func_186058_p() == null ? Integer.toString(world.field_73011_w.getDimension()) : world.field_73011_w.func_186058_p().func_186065_b();
    }

    public static void load(Logger logger, String folderName, File configDir) {
        log = logger;
        log.info("Loading configs...");
        long startTime = System.nanoTime();
        File modConfigDir = new File(configDir, folderName);
        modConfigDir.mkdir();
        dimensionLoading = MAIN_DIM.func_186068_a();
        configLoading = new Configuration(new File(modConfigDir, "_Main_Config_and_" + Config.getDimemsionFileName(MAIN_DIM) + FILE_EXT));
        configLoading.load();
        INSTANCE = new Config();
        configLoading.save();
        configLoading = null;
        Config.loadDimensionFiles(modConfigDir);
        long estimatedTime = System.nanoTime() - startTime;
        log.info("Loaded configs in {} ms", (Object)((double)estimatedTime / 1000000.0));
    }

    private static void loadDim(int dimId, String dimension, String fileName, File modConfigDir) {
        if (DIMENSION_INSTANCES.containsKey(dimId)) {
            log.warn("Skipping duplicate dimension '{}'! Please review the list of dimensions you have enabled for this mod.", (Object)dimension);
            return;
        }
        dimensionLoading = dimId;
        configLoading = new Configuration(new File(modConfigDir, fileName + FILE_EXT));
        configLoading.load();
        DIMENSION_INSTANCES.put(dimId, new Config());
        configLoading.save();
        configLoading = null;
    }

    private static void loadDimensionFiles(File modConfigDir) {
        ENABLED_FOR_MAIN_DIM = false;
        String[] dimensions = Config.INSTANCE.GENERAL.ENABLED_DIMENSIONS;
        log.info("Enabled for {} dimensions; loading additional dimension configs...", (Object)dimensions.length);
        for (String dimension : dimensions) {
            String fileSuffix;
            int dimId;
            try {
                DimensionType type = DimensionType.func_193417_a((String)dimension);
                dimId = type.func_186068_a();
                fileSuffix = Config.getDimemsionFileName(type);
            }
            catch (Exception ex) {
                try {
                    dimId = Integer.parseInt(dimension);
                    fileSuffix = dimension;
                    try {
                        DimensionType type = DimensionType.func_186069_a((int)dimId);
                        if (type != null) {
                            fileSuffix = Config.getDimemsionFileName(type);
                            log.warn("Detected dimension id '{}' that can be replaced by a readable name! Please change it to dimension name '{}' to avoid problems in the future.", (Object)dimension, (Object)type.func_186065_b());
                        }
                    }
                    catch (Exception type) {}
                }
                catch (NumberFormatException nfex) {
                    log.error("Skipping invalid dimension '{}'! Please review the list of dimensions you have enabled for this mod.", (Object)dimension);
                    continue;
                }
            }
            if (dimId == MAIN_DIM.func_186068_a()) {
                ENABLED_FOR_MAIN_DIM = true;
                continue;
            }
            Config.loadDim(dimId, dimension, fileSuffix, modConfigDir);
        }
    }

    private static String getDimemsionFileName(DimensionType dimensionType) {
        return dimensionType.func_186065_b().replace(" ", "_").toLowerCase();
    }

    private Config() {
    }

    static {
        MAIN_DIM = DimensionType.OVERWORLD;
        DIMENSION_INSTANCES = new HashMap();
    }

    static abstract class PropertyCategory {
        static final double[] R_DBL_ALL = new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        static final double[] R_DBL_POS = new double[]{0.0, Double.POSITIVE_INFINITY};
        static final double[] R_DBL_ONE = new double[]{0.0, 1.0};
        static final float[] R_FLT_ALL = new float[]{Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY};
        static final float[] R_FLT_POS = new float[]{0.0f, Float.POSITIVE_INFINITY};
        static final float[] R_FLT_ONE = new float[]{0.0f, 1.0f};
        static final int[] R_INT_ALL = new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
        static final int[] R_INT_TOKEN_NEG = new int[]{-1, Integer.MAX_VALUE};
        static final int[] R_INT_POS0 = new int[]{0, Integer.MAX_VALUE};
        static final int[] R_INT_POS1 = new int[]{1, Integer.MAX_VALUE};
        static final int[] R_INT_SRT_POS = new int[]{0, Short.MAX_VALUE};
        static final int[] R_INT_BYT_UNS = new int[]{0, 255};
        static final int[] R_INT_BYT_POS = new int[]{0, 127};
        protected final String KEY;

        PropertyCategory(String key) {
            this.KEY = key;
            configLoading.addCustomCategoryComment(this.name(), this.comment());
        }

        PropertyCategory() {
            this(null);
        }

        abstract String name();

        abstract String comment();

        double[] defaultDblRange() {
            return R_DBL_POS;
        }

        float[] defaultFltRange() {
            return R_FLT_POS;
        }

        int[] defaultIntRange() {
            return R_INT_POS0;
        }

        WeightedRandomConfig prop(String key, WeightedRandomConfig.Item[] defaultValues, String comment) {
            return new WeightedRandomConfig(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, WeightedRandomConfig.Item[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = defaultValues[i].toString();
            }
            comment = this.amendComment(comment, "Weighted_Array", defaultIds, "mod_id:registry_name weight");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        <T extends Enum<T>> WeightedEnumConfig<T> prop(String key, T[] validValues, String commentPart1, String commentPart2) {
            ArrayList items = new ArrayList();
            for (T value : validValues) {
                String name = ((Enum)value).toString().toLowerCase();
                items.add(new WeightedEnumConfig.Item<T>(value, this.prop(key + "_" + name, ((WeightedEnumConfig.Meta)value).defaultWeight(), commentPart1 + name.replace("_", " ") + commentPart2, R_INT_POS0)));
            }
            return new WeightedEnumConfig(items);
        }

        IBlockState prop(String key, IBlockState defaultValue, String comment) {
            String[] pair;
            String target = this.cprop(key, defaultValue, comment).getString();
            IBlockState blockState = TargetBlock.parseStateForMatch(target);
            if (blockState.func_177230_c() == Blocks.field_150350_a && (pair = target.split(" ", 2)).length > 1) {
                Block block = TargetBlock.parseBlock(pair[0]);
                return block.func_176203_a(Integer.parseInt(pair[1].trim()));
            }
            return blockState;
        }

        Property cprop(String key, IBlockState defaultValue, String comment) {
            String defaultId = new TargetBlock(defaultValue).toString();
            comment = this.amendComment(comment, "Block", (Object)defaultId, "mod_id:block_id, mod_id:block_id[<properties>]");
            return configLoading.get(this.name(), key, defaultId, comment);
        }

        TargetBlock.TargetMap prop(String key, TargetBlock[] defaultValues, String comment) {
            return TargetBlock.newTargetDefinition(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, TargetBlock[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = defaultValues[i].toString();
            }
            comment = this.amendComment(comment, "Target_Block_Array", defaultIds, "mod_id:block_id, mod_id:block_id[<properties>], mod_id:*");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        WeightedBlockConfig.BlockList prop(String key, WeightedBlockConfig[] defaultValues, String comment) {
            return WeightedBlockConfig.newTargetDefinition(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, WeightedBlockConfig[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = defaultValues[i].toString();
            }
            comment = this.amendComment(comment, "Block_Array", defaultIds, "mod_id:block_id <value>, mod_id:block_id[<properties>] <value>");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        EntityListConfig prop(String key, EntryEntity[] defaultValues, String comment) {
            return new EntityListConfig(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, EntryEntity[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = defaultValues[i].toString();
            }
            comment = this.amendComment(comment, "Entity_Array", defaultIds, "mod_id:entity_id <value>, ~mod_id:entity_id <value>");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        EnvironmentListConfig prop(String key, TargetEnvironment[] defaultValues, String comment) {
            return new EnvironmentListConfig(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, TargetEnvironment[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = defaultValues[i].toString();
            }
            comment = this.amendComment(comment, "Environment_Array", defaultIds, "biome/mod_id:biome_id=value, biome/mod_id:prefix*=value");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        boolean prop(String key, boolean defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment).getBoolean();
        }

        Property cprop(String key, boolean defaultValue, String comment) {
            comment = this.amendComment(comment, "Boolean", (Object)defaultValue, new Object[]{true, false});
            return configLoading.get(this.name(), key, defaultValue, comment);
        }

        boolean[] prop(String key, boolean[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment).getBooleanList();
        }

        Property cprop(String key, boolean[] defaultValues, String comment) {
            comment = this.amendComment(comment, "Boolean_Array", (Object[])ArrayUtils.toObject((boolean[])defaultValues), new Object[]{true, false});
            return configLoading.get(this.name(), key, defaultValues, comment);
        }

        int prop(String key, int defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment).getInt();
        }

        int prop(String key, int defaultValue, String comment, int ... range) {
            return this.cprop(key, defaultValue, comment, range).getInt();
        }

        Property cprop(String key, int defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment, this.defaultIntRange());
        }

        Property cprop(String key, int defaultValue, String comment, int ... range) {
            comment = this.amendComment(comment, "Integer", defaultValue, (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValue, comment, range[0], range[1]);
        }

        int[] prop(String key, int[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment).getIntList();
        }

        int[] prop(String key, int[] defaultValues, String comment, int ... range) {
            return this.cprop(key, defaultValues, comment, range).getIntList();
        }

        Property cprop(String key, int[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment, this.defaultIntRange());
        }

        Property cprop(String key, int[] defaultValues, String comment, int ... range) {
            comment = this.amendComment(comment, "Integer_Array", ArrayUtils.toObject((int[])defaultValues), (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValues, comment, range[0], range[1]);
        }

        float prop(String key, float defaultValue, String comment) {
            return (float)this.cprop(key, defaultValue, comment).getDouble();
        }

        float prop(String key, float defaultValue, String comment, float ... range) {
            return (float)this.cprop(key, defaultValue, comment, range).getDouble();
        }

        Property cprop(String key, float defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment, this.defaultFltRange());
        }

        Property cprop(String key, float defaultValue, String comment, float ... range) {
            comment = this.amendComment(comment, "Float", Float.valueOf(defaultValue), (Object)Float.valueOf(range[0]), (Object)Float.valueOf(range[1]));
            return configLoading.get(this.name(), key, this.prettyFloatToDouble(defaultValue), comment, this.prettyFloatToDouble(range[0]), this.prettyFloatToDouble(range[1]));
        }

        double prop(String key, double defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment).getDouble();
        }

        double prop(String key, double defaultValue, String comment, double ... range) {
            return this.cprop(key, defaultValue, comment, range).getDouble();
        }

        Property cprop(String key, double defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment, this.defaultDblRange());
        }

        Property cprop(String key, double defaultValue, String comment, double ... range) {
            comment = this.amendComment(comment, "Double", defaultValue, (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValue, comment, range[0], range[1]);
        }

        double[] prop(String key, double[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment).getDoubleList();
        }

        double[] prop(String key, double[] defaultValues, String comment, double ... range) {
            return this.cprop(key, defaultValues, comment, range).getDoubleList();
        }

        Property cprop(String key, double[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment, this.defaultDblRange());
        }

        Property cprop(String key, double[] defaultValues, String comment, double ... range) {
            comment = this.amendComment(comment, "Double_Array", ArrayUtils.toObject((double[])defaultValues), (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValues, comment, range[0], range[1]);
        }

        String prop(String key, String defaultValue, String comment, String valueDescription) {
            return this.cprop(key, defaultValue, comment, valueDescription).getString();
        }

        String prop(String key, String defaultValue, String comment, String ... validValues) {
            return this.cprop(key, defaultValue, comment, validValues).getString();
        }

        Property cprop(String key, String defaultValue, String comment, String valueDescription) {
            comment = this.amendComment(comment, "String", (Object)defaultValue, valueDescription);
            return configLoading.get(this.name(), key, defaultValue, comment, new String[0]);
        }

        Property cprop(String key, String defaultValue, String comment, String ... validValues) {
            comment = this.amendComment(comment, "String", (Object)defaultValue, (Object[])validValues);
            return configLoading.get(this.name(), key, defaultValue, comment, validValues);
        }

        String[] prop(String key, String[] defaultValues, String comment, String valueDescription) {
            return this.cprop(key, defaultValues, comment, valueDescription).getStringList();
        }

        Property cprop(String key, String[] defaultValues, String comment, String valueDescription) {
            comment = this.amendComment(comment, "String_Array", (Object[])defaultValues, valueDescription);
            return configLoading.get(this.name(), key, defaultValues, comment);
        }

        private String amendComment(String comment, String type, Object[] defaultValues, String description) {
            return this.amendComment(comment, type, (Object)("{ " + this.toReadable(defaultValues) + " }"), description);
        }

        private String amendComment(String comment, String type, Object[] defaultValues, Object min, Object max) {
            return this.amendComment(comment, type, "{ " + this.toReadable(defaultValues) + " }", min, max);
        }

        private String amendComment(String comment, String type, Object[] defaultValues, Object[] validValues) {
            return this.amendComment(comment, type, (Object)("{ " + this.toReadable(defaultValues) + " }"), validValues);
        }

        private String amendComment(String comment, String type, Object defaultValue, String description) {
            return comment + "\n   >> " + type + ":[ Value={ " + description + " }, Default=" + defaultValue + " ]";
        }

        private String amendComment(String comment, String type, Object defaultValue, Object min, Object max) {
            return comment + "\n   >> " + type + ":[ Range={ " + min + ", " + max + " }, Default=" + defaultValue + " ]";
        }

        private String amendComment(String comment, String type, Object defaultValue, Object[] validValues) {
            if (validValues.length < 2) {
                throw new IllegalArgumentException("Attempted to create config with no options!");
            }
            return comment + "\n   >> " + type + ":[ Valid_Values={ " + this.toReadable(validValues) + " }, Default=" + defaultValue + " ]";
        }

        private double prettyFloatToDouble(float f) {
            return Double.parseDouble(Float.toString(f));
        }

        private String toReadable(Object[] array) {
            if (array.length <= 0) {
                return "";
            }
            StringBuilder commentBuilder = new StringBuilder();
            for (Object value : array) {
                commentBuilder.append(value).append(", ");
            }
            return commentBuilder.substring(0, commentBuilder.length() - 2);
        }
    }

    static interface ISubgenFeature {
    }

    public static abstract class FeatureConfig
    extends PropertyCategory {
        private final float PLACEMENT_CHANCE;
        private final EnvironmentListConfig PLACEMENT_CHANCE_EXCEPTIONS;
        public final int[] HEIGHTS;
        public final boolean DEBUG_MARKER;

        @Override
        String name() {
            return "features_" + this.KEY;
        }

        @Override
        String comment() {
            return "Options related to the generation of " + this.KEY + ".";
        }

        FeatureConfig(String key, float placement, int minHeight, int maxHeight) {
            super(key);
            if (this instanceof ISubgenFeature) {
                this.PLACEMENT_CHANCE = 0.0f;
                this.PLACEMENT_CHANCE_EXCEPTIONS = null;
                this.HEIGHTS = new int[2];
                this.DEBUG_MARKER = false;
                return;
            }
            if (this instanceof FeatureMulti) {
                this.PLACEMENT_CHANCE = this.prop("_" + this.KEY + "_count", placement, "The number of placement attempts for this feature type.\nA decimal represents a chance for a placement attempt (e.g., 0.3 means 30% chance for one attempt).");
                this.PLACEMENT_CHANCE_EXCEPTIONS = this.prop("_" + this.KEY + "_count_exceptions", new TargetEnvironment[0], "The number of placement attempts when generating in particular locations.\nMore specific locations take priority over others (biome < biome* < global setting).");
            } else {
                this.PLACEMENT_CHANCE = this.prop("_" + this.KEY + "_chance", dimensionLoading == DimensionType.OVERWORLD.func_186068_a() ? placement : placement * 0.5f, "The ratio of chunks to place this feature in.\nThis represents a chance for a placement attempt in each chunk from 0 to 1\n(e.g., 0.1 means 10% chance per chunk).", PropertyCategory.R_FLT_ONE);
                this.PLACEMENT_CHANCE_EXCEPTIONS = this.prop("_" + this.KEY + "_chance_exceptions", new TargetEnvironment[0], "The chance for a placement attempt when generating in particular locations.\nMore specific locations take priority over others (biome < biome* < global setting).");
            }
            this.HEIGHTS = new int[]{this.prop("_" + this.KEY + "_height_min", dimensionLoading == DimensionType.OVERWORLD.func_186068_a() ? minHeight : 10, "The minimum height to generate this feature at."), this.prop("_" + this.KEY + "_height_max", dimensionLoading == DimensionType.OVERWORLD.func_186068_a() ? maxHeight : 100, "The maximum height to generate this feature at.")};
            this.DEBUG_MARKER = this.prop(this.KEY + "_testing_marker", false, "When set to true, places a 1x1 column of glass to the height limit from a few blocks above each generated feature.\nThis is game-breaking and laggy. You must also enable debug mode in the main mod config.\nConsider using a tool to strip away all stone/dirt/etc. for more intensive testing.");
        }

        public float getPlacementChance(World world, BlockPos pos) {
            return this.PLACEMENT_CHANCE_EXCEPTIONS.getValueForLocation(world, pos, this.PLACEMENT_CHANCE);
        }
    }

    public static abstract class FeatureMulti
    extends FeatureConfig {
        FeatureMulti(String key, float placement, int minHeight, int maxHeight) {
            super(key, placement, minHeight, maxHeight);
        }
    }

    public static abstract class FeatureSubtyped
    extends FeatureConfig {
        abstract String subKey();

        String typeKey() {
            return this.subKey() + "_" + this.KEY;
        }

        @Override
        String name() {
            return "features_" + this.typeKey();
        }

        @Override
        String comment() {
            return "Options related to the generation of " + this.KEY + " " + this.subKey() + ".";
        }

        FeatureSubtyped(String key, float placement, int minHeight, int maxHeight) {
            super(key, placement, minHeight, maxHeight);
        }
    }

    public static abstract class FeatureTrap
    extends FeatureSubtyped {
        public final float ACTIVATION_RANGE;
        public final boolean CHECK_SIGHT;

        FeatureTrap(String key, String displayName, float placement, int minHeight, int maxHeight, float actRange, boolean checkSight) {
            super(key, placement, minHeight, maxHeight);
            this.ACTIVATION_RANGE = this.prop("activation_range", actRange, "The trap will be triggered once a player comes within this distance (spherical distance).");
            this.CHECK_SIGHT = this.prop("activation_sight_check", checkSight, "When the sight check is enabled, " + displayName + " will only trigger when they have direct\nline-of-sight to a player within activation range.");
        }
    }

    public static class FeatureTower
    extends FeatureTrap {
        public final float ATTACK_DAMAGE;
        public final float PROJECTILE_SPEED;
        public final float PROJECTILE_VARIANCE;
        public final int DELAY_MIN;
        public final int DELAY_MAX;
        public final int MAX_TOWER_HEIGHT;
        public final WeightedBlockConfig.BlockList PILLAR_BLOCKS;

        @Override
        String subKey() {
            return "towers";
        }

        @Override
        String comment() {
            return "Options related to the generation of " + this.KEY + " tower traps.";
        }

        FeatureTower(EnumTowerType type, float placement, int minHeight, int maxHeight, float damage, float projSpeed, float projVariance, int minDelay, int maxDelay) {
            this(type, placement, minHeight, maxHeight, damage, projSpeed, projVariance, minDelay, maxDelay, 10.0f, true);
        }

        FeatureTower(EnumTowerType type, float placement, int minHeight, int maxHeight, float damage, float projSpeed, float projVariance, int minDelay, int maxDelay, float actRange, boolean checkSight) {
            super(type.NAME, type.DISPLAY_NAME, placement, minHeight, maxHeight, actRange, checkSight);
            this.ATTACK_DAMAGE = type != EnumTowerType.FIREBALL ? this.prop("attack_damage", damage, "Damage dealt by " + type.DISPLAY_NAME + "' attacks. This translates roughly into half-hearts of damage.") : this.prop("attack_shots", damage, "Number of fireballs shot by " + type.DISPLAY_NAME + "' attacks. Fireballs deal a fixed 5 damage (half-hearts).");
            this.PROJECTILE_SPEED = this.prop("projectile_speed", projSpeed, "Multiplier for how fast projectiles fired by " + type.DISPLAY_NAME + " move through the air.");
            this.PROJECTILE_VARIANCE = this.prop("projectile_variance", projVariance, "The higher this value, the less accurate projectiles fired by " + type.DISPLAY_NAME + " are.");
            this.DELAY_MIN = this.prop("attack_delay_min", minDelay, "The minimum delay between attacks, in ticks. (20 ticks = 1 second)");
            this.DELAY_MAX = this.prop("attack_delay_max", maxDelay, "The maximumm delay between attack, in ticks. (20 ticks = 1 second)");
            this.MAX_TOWER_HEIGHT = this.prop("max_tower_height", dimensionLoading == DimensionType.NETHER.func_186068_a() ? 2 : 4, "The maximum height the tower can generate to reach out of non-solid blocks (like lava).\nNote that this allows the tower to stretch above the \"_" + this.KEY + "_height_max\" setting.");
            WeightedBlockConfig[] pillarBlocks = dimensionLoading == DimensionType.NETHER.func_186068_a() ? new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150385_bj, 100), new WeightedBlockConfig(Blocks.field_189879_dh, 60)} : (dimensionLoading == DimensionType.THE_END.func_186068_a() ? new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150343_Z, 70457)} : new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150347_e, 100), new WeightedBlockConfig(Blocks.field_150341_Y, 50)});
            this.PILLAR_BLOCKS = this.prop("pillar_blocks", pillarBlocks, "A weighted list of blocks to pick from when generating the bottom portion of " + type.DISPLAY_NAME + ".");
        }
    }

    public static class TOWER_POTION
    extends FeatureTower {
        public final int SLOWNESS_DURATION = this.prop("type_slowness_duration", 600, "Duration of the slowness effect applied by slowness arrows, in ticks. Default is equivalent to stray skeleton arrows.");
        public final int SLOWNESS_POTENCY = this.prop("type_slowness_potency", 0, "Potency of the slowness effect applied by slowness arrows. Default is equivalent to stray skeleton arrows.");
        public final int POISON_DURATION = this.prop("type_poison_duration", 200, "Duration of the poison effect applied by poison arrows, in ticks.");
        public final int POISON_POTENCY = this.prop("type_poison_potency", 0, "Potency of the poison effect applied by poison arrows.");
        public final int WITHER_DURATION = this.prop("type_wither_duration", 200, "Duration of the wither effect applied by wither arrows, in ticks.");
        public final int WITHER_POTENCY = this.prop("type_wither_potency", 0, "Potency of the wither effect applied by wither arrows.");
        public final int HARM_POTENCY = this.prop("type_harm_potency", 1, "Potency of the instant damage effect applied by harm arrows.");
        public final int HUNGER_DURATION = this.prop("type_hunger_duration", 400, "Duration of the hunger effect applied by hunger arrows, in ticks.");
        public final int HUNGER_POTENCY = this.prop("type_hunger_potency", 0, "Potency of the hunger effect applied by hunger arrows.");
        public final int BLINDNESS_DURATION = this.prop("type_blindness_duration", 400, "Duration of the blindness effect applied by blindness arrows, in ticks.");
        public final int WEAKNESS_DURATION = this.prop("type_weakness_duration", 600, "Duration of the weakness and fatigue effects applied by weakness arrows, in ticks.");
        public final int WEAKNESS_POTENCY = this.prop("type_weakness_potency", 0, "Potency of the weakness and fatigue effects applied by weakness arrows.");
        public final int LEVITATION_DURATION = this.prop("type_levitation_duration", 100, "Duration of the levitation effect applied by levitation arrows, in ticks.");
        public final int LEVITATION_POTENCY = this.prop("type_levitation_potency", 1, "Potency of the levitation effect applied by levitation arrows.");
        public final WeightedEnumConfig<EnumPotionArrowType> POTION_TYPE_LIST = this.prop("type_weight", EnumPotionArrowType.values(), "Weight for the ", " potion arrow type.");

        TOWER_POTION(EnumTowerType type, float placement, int minHeight, int maxHeight, float damage, float projSpeed, float projVariance, int minDelay, int maxDelay) {
            super(type, placement, minHeight, maxHeight, damage, projSpeed, projVariance, minDelay, maxDelay);
        }
    }

    public static class FeatureFloorTrap
    extends FeatureTrap {
        public final float COVER_CHANCE;

        @Override
        String subKey() {
            return "floor_traps";
        }

        @Override
        String comment() {
            return "Options related to the generation of " + this.KEY + " traps in floors.";
        }

        FeatureFloorTrap(EnumFloorTrapType type, float placement, int minHeight, int maxHeight) {
            this(type, placement, minHeight, maxHeight, 3.3f, true);
        }

        FeatureFloorTrap(EnumFloorTrapType type, float placement, int minHeight, int maxHeight, float actRange, boolean checkSight) {
            super(type.NAME, type.DISPLAY_NAME, placement, minHeight, maxHeight, actRange, checkSight);
            this.COVER_CHANCE = this.prop("_cover_chance", 0.5f, "The chance for " + type.DISPLAY_NAME + " to generate with a 'cover' block placed on top.\nThe possible cover blocks are determined in the dimension's terrain config section.", R_FLT_ONE);
        }
    }

    public static class FLOOR_TRAP_POTION
    extends FeatureFloorTrap {
        public final int RESET_TIME_MIN = this.prop("reset_time_min", 20, "The minimum delay before potion traps can be tripped again, in ticks. (20 ticks = 1 second)");
        public final int RESET_TIME_MAX = this.prop("reset_time_max", 40, "The maximum delay before potion traps can be tripped again, in ticks. (20 ticks = 1 second)");
        public final int HARM_POTENCY = this.prop("type_harm_potency", 1, "Potency of the instant damage effect applied by harm potion traps.");
        public final int POISON_DURATION = this.prop("type_poison_duration", 1600, "Duration of the poison effect applied by poison potion traps, in ticks (affected by proximity to the splash).");
        public final int POISON_POTENCY = this.prop("type_poison_potency", 0, "Potency of the poison effect applied by poison potion traps.");
        public final int HUNGER_DURATION = this.prop("type_hunger_duration", 2000, "Duration of the hunger effect applied by hunger potion traps, in ticks (affected by proximity to the splash).");
        public final int HUNGER_POTENCY = this.prop("type_hunger_potency", 0, "Potency of the hunger effect applied by hunger potion traps.");
        public final int DAZE_DURATION = this.prop("type_daze_duration", 2000, "Duration of the effects applied by daze potion traps, in ticks (affected by proximity to the splash).");
        public final int DAZE_POTENCY = this.prop("type_daze_potency", 0, "Potency of the weakness, fatigue, and slowness effects applied by daze potion traps.");
        public final int LEVITATION_DURATION = this.prop("type_levitation_duration", 200, "Duration of the levitation effect applied by levitation potion traps, in ticks (affected by proximity to the splash).");
        public final int LEVITATION_POTENCY = this.prop("type_levitation_potency", 1, "Potency of the levitation effect applied by levitation potion traps.");
        public final WeightedEnumConfig<EnumPotionTrapType> POTION_TYPE_LIST = this.prop("type_weight", EnumPotionTrapType.values(), "Weight for the ", " potion trap type.");

        FLOOR_TRAP_POTION(EnumFloorTrapType type, float placement, int minHeight, int maxHeight) {
            super(type, placement, minHeight, maxHeight);
        }
    }

    public static class FLOOR_TRAP_TNT_MOB
    extends FeatureFloorTrap {
        public final float MULTIPLIER_HEALTH = this.prop("attrib_mult_health", 0.5f, "Multiplier applied to the spawned entity's base health attribute.");
        public final float MULTIPLIER_SPEED = this.prop("attrib_mult_speed", 1.3f, "Multiplier applied to the spawned entity's base movement speed attribute.");
        public final int FUSE_TIME_MIN = this.prop("fuse_time_min", 70, "The minimum delay before the tnt \"hat\" explodes, in ticks. (20 ticks = 1 second)");
        public final int FUSE_TIME_MAX = this.prop("fuse_time_max", 80, "The maximum delay before the tnt \"hat\" explodes, in ticks. (20 ticks = 1 second)");
        public final WeightedRandomConfig SPAWN_LIST = this.prop("spawn_list", this.makeDefaultSpawnList(), "Weighted list of mobs that can be spawned by tnt mob traps. One of these is chosen\nat random when the trap is triggered.");

        FLOOR_TRAP_TNT_MOB(EnumFloorTrapType type, float placement, int minHeight, int maxHeight) {
            super(type, placement, minHeight, maxHeight);
        }

        private WeightedRandomConfig.Item[] makeDefaultSpawnList() {
            if (dimensionLoading == DimensionType.NETHER.func_186068_a()) {
                return new WeightedRandomConfig.Item[]{new WeightedRandomConfig.Item(EntityWitherSkeleton.class, 200), new WeightedRandomConfig.Item(EntityHusk.class, 100), new WeightedRandomConfig.Item(EntityBlaze.class, 100), new WeightedRandomConfig.Item(EntityCaveSpider.class, 10), new WeightedRandomConfig.Item(EntityMagmaCube.class, 10)};
            }
            if (dimensionLoading == DimensionType.THE_END.func_186068_a()) {
                return new WeightedRandomConfig.Item[]{new WeightedRandomConfig.Item(EntityEnderman.class, 200)};
            }
            return new WeightedRandomConfig.Item[]{new WeightedRandomConfig.Item(EntityZombie.class, 200), new WeightedRandomConfig.Item(EntitySkeleton.class, 100), new WeightedRandomConfig.Item(EntitySpider.class, 100), new WeightedRandomConfig.Item(EntityCaveSpider.class, 10), new WeightedRandomConfig.Item(EntitySilverfish.class, 10)};
        }
    }

    public static class FLOOR_TRAP_TNT
    extends FeatureFloorTrap {
        public final int FUSE_TIME_MIN = this.prop("fuse_time_min", 40, "The minimum delay before spawned tnt explodes, in ticks. (20 ticks = 1 second)");
        public final int FUSE_TIME_MAX = this.prop("fuse_time_max", 50, "The maximum delay before spawned tnt explodes, in ticks. (20 ticks = 1 second)");
        public final float LAUNCH_SPEED = this.prop("launch_speed", 0.3f, "The maximum horizontal speed spawned tnt is launched at.") / 0.02f;
        public final int TNT_COUNT = this.prop("tnt_count", 4, "The number of primed tnt spawned when the trap triggers.");

        FLOOR_TRAP_TNT(EnumFloorTrapType type, float placement, int minHeight, int maxHeight) {
            super(type, placement, minHeight, maxHeight);
        }
    }

    public static class FeatureSpawner
    extends FeatureTrap {
        public final float CHEST_CHANCE;
        public final float DYNAMIC_CHANCE;
        public final WeightedRandomConfig SPAWN_LIST;
        public final int DELAY_MIN;
        public final int DELAY_MAX;
        public final int DELAY_PROGRESSIVE;
        public final float ADDED_ARMOR;
        public final float ADDED_ARMOR_TOUGHNESS;
        public final float ADDED_KNOCKBACK_RESIST;
        public final float MULTIPLIER_DAMAGE;
        public final float MULTIPLIER_HEALTH;
        public final float MULTIPLIER_SPEED;
        public final int SPAWN_COUNT;
        public final float SPAWN_RANGE;
        public final WeightedBlockConfig.BlockList TOPPER_BLOCKS;

        @Override
        String subKey() {
            return "spawners";
        }

        FeatureSpawner(EnumSpawnerType type, float chestChance, float placements, int minHeight, int maxHeight, float actRange, boolean checkSight, int minDelay, int maxDelay, int prgrDelay, int spawnCount, float spawnRange, IBlockState topper) {
            super(type.func_176610_l(), type.DISPLAY_NAME, placements, minHeight, maxHeight, actRange, checkSight);
            float f = this.CHEST_CHANCE = this instanceof ISubgenFeature ? 0.0f : this.prop("_chest_chance", chestChance, "The chance for a chest to generate beneath " + type.DISPLAY_NAME + ".\nFor reference, the loot table for these chests is '" + type.LOOT_TABLE_CHEST.toString() + "'.", R_FLT_ONE);
            this.DYNAMIC_CHANCE = this.prop("_dynamic_chance", type == EnumSpawnerType.STREAM ? 1.0f : (type == EnumSpawnerType.SILVERFISH_NEST ? 0.0f : 0.08f), "The chance for " + type.DISPLAY_NAME + " to generate as 'dynamic'.\nDynamic spawners pick a new mob to spawn after each spawn.", R_FLT_ONE);
            this.SPAWN_LIST = this.prop("_spawn_list", this.makeDefaultSpawnList(), "Weighted list of mobs that can be spawned by " + type.DISPLAY_NAME + ". One of these is chosen\nat random when the spawner is generated. Spawners that are generated as 'dynamic' will pick again\nbetween each spawn.");
            this.DELAY_MIN = this.prop("delay_min", minDelay, "The minimum delay between spawns, in ticks. (20 ticks = 1 second)");
            this.DELAY_MAX = this.prop("delay_max", maxDelay, "The maximumm delay between spawns, in ticks. (20 ticks = 1 second)");
            this.DELAY_PROGRESSIVE = this.prop("delay_progressive", prgrDelay, "Each spawn increases the spawner's delay buildup by this many ticks (+/- 10%). Set this to 0 to\nrevert to the lame vanilla spawner behavior (simple random between min and max).\n * See the main config for a more in-depth description of progressive spawn delay, as well as\n   the global recovery rate option.");
            this.ADDED_ARMOR = this.prop("attrib_add_armor", type == EnumSpawnerType.BRUTAL || type == EnumSpawnerType.DUNGEON ? 15.0f : 0.0f, "Bonus added to spawned entities' base armor attributes.", 0.0f, 30.0f);
            this.ADDED_ARMOR_TOUGHNESS = this.prop("attrib_add_armor_toughness", type == EnumSpawnerType.BRUTAL || type == EnumSpawnerType.DUNGEON ? 8.0f : 0.0f, "Bonus added to spawned entities' base armor toughness attributes.", 0.0f, 20.0f);
            this.ADDED_KNOCKBACK_RESIST = this.prop("attrib_add_knockback_resist", type == EnumSpawnerType.BRUTAL ? 0.2f : 0.0f, "Bonus added to spawned entities' base knockback resistance attributes (1.00 = 100% chance to resist).", R_FLT_ONE);
            this.MULTIPLIER_DAMAGE = this.prop("attrib_mult_damage", type == EnumSpawnerType.BRUTAL || type == EnumSpawnerType.DUNGEON ? 1.5f : 1.0f, "Multiplier applied to spawned entities' base attack damage attributes.");
            this.MULTIPLIER_HEALTH = this.prop("attrib_mult_health", type == EnumSpawnerType.BRUTAL ? 1.5f : 1.0f, "Multiplier applied to spawned entities' base health attributes.");
            this.MULTIPLIER_SPEED = this.prop("attrib_mult_speed", type == EnumSpawnerType.BRUTAL ? 1.2f : 1.0f, "Multiplier applied to spawned entities' base movement speed attributes.");
            this.SPAWN_COUNT = this.prop("spawn_count", spawnCount, "The number of mobs to attempt creating with each spawn. May spawn fewer depending on nearby obstructions.");
            this.SPAWN_RANGE = this.prop("spawn_range", spawnRange, "The maximum horizontal range to spawn mobs in.");
            WeightedBlockConfig[] topperBlocks = type == EnumSpawnerType.DEFAULT ? (dimensionLoading == DimensionType.NETHER.func_186068_a() ? new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150385_bj, 100), new WeightedBlockConfig(Blocks.field_189879_dh, 100)} : (dimensionLoading == DimensionType.THE_END.func_186068_a() ? new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_185772_cY, 70457)} : new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150347_e, 100), new WeightedBlockConfig(Blocks.field_150341_Y, 100)})) : (topper == null ? null : new WeightedBlockConfig[]{new WeightedBlockConfig(topper, 70457)});
            this.TOPPER_BLOCKS = topperBlocks == null ? null : this.prop("topper_blocks", topperBlocks, "A weighted list of blocks to pick from when placing the decoration block on top of " + type.DISPLAY_NAME + ".");
        }

        protected WeightedRandomConfig.Item[] makeDefaultSpawnList() {
            if (dimensionLoading == DimensionType.NETHER.func_186068_a()) {
                return new WeightedRandomConfig.Item[]{new WeightedRandomConfig.Item(EntityWitherSkeleton.class, 200), new WeightedRandomConfig.Item(EntityHusk.class, 100), new WeightedRandomConfig.Item(EntityBlaze.class, 100), new WeightedRandomConfig.Item(EntityCaveSpider.class, 10), new WeightedRandomConfig.Item(EntityCreeper.class, 10), new WeightedRandomConfig.Item(EntityMagmaCube.class, 10)};
            }
            if (dimensionLoading == DimensionType.THE_END.func_186068_a()) {
                return new WeightedRandomConfig.Item[]{new WeightedRandomConfig.Item(EntityEnderman.class, 200), new WeightedRandomConfig.Item(EntityCreeper.class, 10)};
            }
            return new WeightedRandomConfig.Item[]{new WeightedRandomConfig.Item(EntityZombie.class, 200), new WeightedRandomConfig.Item(EntitySkeleton.class, 100), new WeightedRandomConfig.Item(EntitySpider.class, 100), new WeightedRandomConfig.Item(EntityCaveSpider.class, 10), new WeightedRandomConfig.Item(EntityCreeper.class, 10), new WeightedRandomConfig.Item(EntitySilverfish.class, 10)};
        }
    }

    public static class SILVERFISH_NEST
    extends FeatureSpawner {
        public WeightedBlockConfig.BlockList NEST_BLOCKS = this.prop("nest_block_list", this.makeDefaultNestMaterials(), "A weighted list of blocks to pick from to make up the entire nest. All blocks will be replaced with\nsilverfish-infested versions, limited by your silverfish replaceable/autogen settings.");

        SILVERFISH_NEST(EnumSpawnerType type, float chestChance, float placements, int minHeight, int maxHeight, float actRange, boolean checkSight, int minDelay, int maxDelay, int prgrDelay, int spawnCount, float spawnRange) {
            super(type, chestChance, placements, minHeight, maxHeight, actRange, checkSight, minDelay, maxDelay, prgrDelay, spawnCount, spawnRange, null);
        }

        @Override
        protected WeightedRandomConfig.Item[] makeDefaultSpawnList() {
            return new WeightedRandomConfig.Item[]{new WeightedRandomConfig.Item(EntitySilverfish.class, 70457)};
        }

        private WeightedBlockConfig[] makeDefaultNestMaterials() {
            if (dimensionLoading == DimensionType.NETHER.func_186068_a()) {
                return new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150425_aM, 100), new WeightedBlockConfig(Blocks.field_150449_bY, 10)};
            }
            if (dimensionLoading == DimensionType.THE_END.func_186068_a()) {
                return new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150343_Z, 70457)};
            }
            return new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150347_e, 300), new WeightedBlockConfig(Blocks.field_150341_Y, 20), new WeightedBlockConfig(Blocks.field_150435_aG, 20), new WeightedBlockConfig(Blocks.field_150352_o, 5), new WeightedBlockConfig(Blocks.field_150369_x, 5), new WeightedBlockConfig(Blocks.field_150482_ag, 5), new WeightedBlockConfig(Blocks.field_150412_bA, 5)};
        }
    }

    public static class SPAWNER_BRUTAL
    extends FeatureSpawner {
        public final float VINES_CHANCE = this.prop("vines_chance", 0.4f, "Chance to place a vines block for decoration in each adjacent air block.");
        public final boolean AMBIENT_FX = this.prop("brutal_ambient_fx", false, "If true, the potion effects applied to spawned mobs will not spawn potion fx particles.");
        public final boolean FIRE_RESISTANCE = this.prop("brutal_fire_resistance", true, "If true, non-creeper mobs spawned by brutal spawners will have the 'fire resistance' potion effect.");
        public final boolean WATER_BREATHING = this.prop("brutal_water_breathing", true, "If true, non-creeper mobs spawned by brutal spawners will have the 'water breathing' potion effect.");

        SPAWNER_BRUTAL(EnumSpawnerType type, float chestChance, float placements, int minHeight, int maxHeight, float actRange, boolean checkSight, int minDelay, int maxDelay, int prgrDelay, int spawnCount, float spawnRange, IBlockState topperBlock) {
            super(type, chestChance, placements, minHeight, maxHeight, actRange, checkSight, minDelay, maxDelay, prgrDelay, spawnCount, spawnRange, topperBlock);
        }
    }

    public static class FeatureChest
    extends FeatureSubtyped {
        public final float TRAPPED_CHANCE;

        @Override
        String subKey() {
            return "chests";
        }

        FeatureChest(EnumChestType type, float placements, int minHeight, int maxHeight, float trappedChance) {
            super(type.func_176610_l(), placements, minHeight, maxHeight);
            this.TRAPPED_CHANCE = type == EnumChestType.TRAPPED ? 1.0f : this.prop("_trapped_chance", trappedChance, "The chance for " + type.DISPLAY_NAME + " to use the 'trapped chest' block instead of a normal chest block.\nFor reference, the loot table for these chests is '" + type.LOOT_TABLE_CHEST.toString() + "'.", R_FLT_ONE);
        }
    }

    public static class CHEST_MIMIC
    extends FeatureChest {
        public final float MULTIPLIER_DAMAGE = this.prop("attrib_mult_damage", 2.0f, "Multiplier applied to the spawned mimic's base damage attribute.");
        public final float MULTIPLIER_HEALTH = this.prop("attrib_mult_health", 2.0f, "Multiplier applied to the spawned mimic's base health attribute.");
        public final float MULTIPLIER_SPEED = this.prop("attrib_mult_speed", 1.1f, "Multiplier applied to the spawned mimic's base movement speed attribute.");
        public final float BABY_CHANCE = this.prop("baby_chance", 1.0f, "Chance for the spawned mimic to be a baby (only works for Zombies, Pig Zombies, and Animals).", R_FLT_ONE);
        public final WeightedRandomConfig SPAWN_LIST = this.prop("spawn_list", this.makeDefaultSpawnList(), "Weighted list of mobs that can be spawned as \"mimics\". One of these is chosen\nat random when the spawn mimic event is triggered.");

        CHEST_MIMIC(EnumChestType type, float placements, int minHeight, int maxHeight, float trappedChance) {
            super(type, placements, minHeight, maxHeight, trappedChance);
        }

        private WeightedRandomConfig.Item[] makeDefaultSpawnList() {
            return new WeightedRandomConfig.Item[]{new WeightedRandomConfig.Item(EntityZombie.class, 70457)};
        }
    }

    public static class CHEST_SURPRISE
    extends FeatureChest {
        public final int TNT_FUSE_TIME_MIN = this.prop("tnt_fuse_time_min", 40, "The minimum delay before spawned tnt explodes, in ticks. (20 ticks = 1 second)");
        public final int TNT_FUSE_TIME_MAX = this.prop("tnt_fuse_time_max", 60, "The maximum delay before spawned tnt explodes, in ticks. (20 ticks = 1 second)");
        public final float TNT_LAUNCH_SPEED = this.prop("tnt_launch_speed", 0.0f, "The maximum horizontal speed spawned tnt is launched at.") / 0.02f;
        public final int TNT_COUNT = this.prop("tnt_count", 1, "The number of primed tnt spawned when the tnt event triggers.\nIf you make this more than 1, all items in the chest will probably get destroyed when the tnt goes off.");
        public final int GAS_DURATION_DELAY = this.prop("gas_delay", 20, "The delay before the poison gas cloud starts spreading, in ticks. (20 ticks = 1 second)");
        public final int GAS_DURATION = this.prop("gas_duration", 40, "The duration (after its initial delay) until the poison gas cloud reaches max size and disappears, in ticks.");
        public final float GAS_MAX_RADIUS = this.prop("gas_max_radius", 12.0f, "The maximum distance, in blocks, the poison gas cloud spreads from its origin.\nNote the cloud starts at 0.5 radius and linearly increases to max radius at exactly its max duration.");
        public final int GAS_POISON_DURATION = this.prop("gas_type_poison_duration", 200, "Duration of the poison effect applied by poison gas clouds, in ticks.");
        public final int GAS_POISON_POTENCY = this.prop("gas_type_poison_potency", 0, "Potency of the poison effect applied by poison gas clouds.");
        public final int GAS_WITHER_DURATION = this.prop("gas_type_wither_duration", 200, "Duration of the wither effect applied by \"poison\" gas clouds, in ticks.");
        public final int GAS_WITHER_POTENCY = this.prop("gas_type_wither_potency", 0, "Potency of the wither effect applied by \"poison\" gas clouds.");
        public final int GAS_HARM_POTENCY = this.prop("gas_type_harm_potency", 1, "Potency of the instant damage effect applied by \"poison\" gas clouds.");
        public final WeightedEnumConfig<EnumPotionCloudType> GAS_POTION_TYPE_LIST = this.prop("gas_type_weight", EnumPotionCloudType.values(), "Weight for the ", " potion type to be used for \"poison\" gas.");
        public final WeightedEnumConfig<EnumSurpriseChestType> SURPRISE_TYPE_LIST = this.prop("_event_type_weight", EnumSurpriseChestType.values(), "Weight for the ", " surprise event type.");

        CHEST_SURPRISE(EnumChestType type, float placements, int minHeight, int maxHeight, float trappedChance) {
            super(type, placements, minHeight, maxHeight, trappedChance);
        }
    }

    public static class CHEST_INFESTED
    extends FeatureChest {
        public final float LAUNCH_SPEED = this.prop("launch_speed", 0.2f, "The maximum horizontal speed spawned silverfish are launched at.");
        public final int SILVERFISH_COUNT = this.prop("silverfish_count", 6, "The number of silverfish spawned when the silverfish event triggers.");

        CHEST_INFESTED(EnumChestType type, float placements, int minHeight, int maxHeight, float trappedChance) {
            super(type, placements, minHeight, maxHeight, trappedChance);
        }
    }

    public static class CHEST_VALUABLE
    extends FeatureChest {
        public WeightedBlockConfig.BlockList COVER_BLOCKS = this.prop("cover_block_list", this.makeDefaultCoverMaterials(), "A weighted list of blocks to pick from to make up the blocks that surround this chest.");

        CHEST_VALUABLE(EnumChestType type, float placements, int minHeight, int maxHeight, float trappedChance) {
            super(type, placements, minHeight, maxHeight, trappedChance);
        }

        private WeightedBlockConfig[] makeDefaultCoverMaterials() {
            if (dimensionLoading == DimensionType.NETHER.func_186068_a()) {
                return new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_189877_df, 100), new WeightedBlockConfig(Blocks.field_150385_bj, 100), new WeightedBlockConfig(Blocks.field_189879_dh, 100), new WeightedBlockConfig(Blocks.field_150425_aM, 50), new WeightedBlockConfig(Blocks.field_150426_aN, 50), new WeightedBlockConfig(Blocks.field_150424_aL, 10), new WeightedBlockConfig(Blocks.field_150351_n, 50), new WeightedBlockConfig(Blocks.field_150343_Z, 20)};
            }
            if (dimensionLoading == DimensionType.THE_END.func_186068_a()) {
                return new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150343_Z, 100), new WeightedBlockConfig(Blocks.field_150377_bs, 20)};
            }
            return new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150347_e, 50), new WeightedBlockConfig(Blocks.field_150341_Y, 20), new WeightedBlockConfig(Blocks.field_150348_b, 20), new WeightedBlockConfig(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), 50), new WeightedBlockConfig(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH), 50), new WeightedBlockConfig(Blocks.field_150346_d, 50), new WeightedBlockConfig(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT), 50), new WeightedBlockConfig(Blocks.field_150435_aG, 50), new WeightedBlockConfig(Blocks.field_150351_n, 20), new WeightedBlockConfig(Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.SILVER), 50), new WeightedBlockConfig(Blocks.field_150343_Z, 20)};
        }
    }

    public static class SPAWNER_DUNGEON
    extends FeatureSpawner
    implements ISubgenFeature {
        @Override
        String name() {
            return "features_dungeons_spawner";
        }

        @Override
        String comment() {
            return "Options related to the generation of dungeon spawners. These are only generated as a subfeature of dungeons.";
        }

        SPAWNER_DUNGEON(EnumSpawnerType type, float actRange, boolean checkSight, int minDelay, int maxDelay, int prgrDelay, int spawnCount, float spawnRange) {
            super(type, 0.0f, 0.0f, 0, 0, actRange, checkSight, minDelay, maxDelay, prgrDelay, spawnCount, spawnRange, null);
        }
    }

    public static class DUNGEONS
    extends FeatureMulti {
        public final WeightedBlockConfig.BlockList WALL_BLOCKS;
        public final WeightedBlockConfig.BlockList FLOOR_BLOCKS;
        public final boolean DISABLE_VANILLA_DUNGEONS = this.prop("_disable_vanilla_dungeons", true, "Suppresses dungeon generation events when set to true.\nDoes not disable generation added by this mod.");
        public final float SILVERFISH_CHANCE = this.prop("_silverfish_chance", 0.2f, "The chance for each wall and floor block in the dungeon to be infested with silverfish.\nFor this to function, both the fill and variant blocks must be silverfish replaceable and silverfish autogen must be enabled.\nVanilla dungeons do not generate any silverfish blocks.", R_FLT_ONE);
        public final int CHESTS_MIN = this.prop("_chest_count_min", 2, "The minimum number of chests to generate in each dungeon.\nNote that occasionally chests will fail to generate, resulting in fewer chests than the minimum.\nChests are more likely to fail in vanilla dungeons, so maybe set this to 1 for a more vanilla experience.");
        public final int CHESTS_VARIANCE = Math.max(this.prop("_chest_count_max", 2, "The maximum number of chests to generate in each dungeon. The default is the same as vanilla.") - this.CHESTS_MIN + 1, 1);
        public final int OPEN_WALLS_MIN = this.prop("_open_walls_min", 1, "The minimum number of open wall spaces a prospective spawn attempt must have to not be canceled.\nThe default is the same as vanilla. Setting this to 0 allows dungeons to generate completely unconnected to any caves, ravines, etc.");
        public final int OPEN_WALLS_MAX = this.prop("_open_walls_max", 10, "The maximum number of open wall spaces a prospective spawn attempt can have without being canceled.\nLoosening open wall restrictions allows more dungeons to spawn in the world, and affects how open/closed-off they feel.\nFor vanilla dungeons, this value is 5.");
        public final int WIDTH_MIN = this.prop("_width_min", 5, "The minimum width of dungeons. This refers to the open space, not including walls or anything inside.\nNote that dungeons can only generate in odd widths, and each axis is rolled separately. The default is the same as vanilla.", 3, Integer.MAX_VALUE) >> 1;
        public final int WIDTH_VARIANCE = Math.max((this.prop("_width_max", 11, "The maximum width of dungeons. This refers to the open space, not including walls or anything inside.\nNote that dungeons can only generate in odd widths, and each axis is rolled separately. Vanilla dungeons are max 7 wide.", 3, Integer.MAX_VALUE) >> 1) - this.WIDTH_MIN + 1, 1);
        public final WeightedEnumConfig<EnumDungeonSubfeature> SUBFEATURE_LIST = this.prop("subfeature_weight", EnumDungeonSubfeature.values(), "Weight for the ", " to be generated in dungeons.");

        DUNGEONS(String key, float placements, int minHeight, int maxHeight) {
            super(key, placements, minHeight, maxHeight);
            WeightedBlockConfig[] floorBlocks;
            WeightedBlockConfig[] wallBlocks;
            if (dimensionLoading == DimensionType.NETHER.func_186068_a()) {
                wallBlocks = new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150385_bj, 100), new WeightedBlockConfig(Blocks.field_189879_dh, 30)};
                floorBlocks = new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150385_bj, 100), new WeightedBlockConfig(Blocks.field_189879_dh, 100)};
            } else if (dimensionLoading == DimensionType.THE_END.func_186068_a()) {
                wallBlocks = new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_185772_cY, 70457)};
                floorBlocks = new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_185772_cY, 100), new WeightedBlockConfig(Blocks.field_150377_bs, 50)};
            } else {
                wallBlocks = new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150347_e, 100), new WeightedBlockConfig(Blocks.field_150341_Y, 35)};
                floorBlocks = new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150347_e, 100), new WeightedBlockConfig(Blocks.field_150341_Y, 70)};
            }
            this.WALL_BLOCKS = this.prop("_wall_blocks", wallBlocks, "A weighted list of blocks to pick from when generating the walls of dungeons.\nFor a vanilla dungeon look, set this to only cobblestone.");
            this.FLOOR_BLOCKS = this.prop("_floor_blocks", floorBlocks, "A weighted list of blocks to pick from when generating the floor of dungeons.\nFor a vanilla dungeon look, set cobblestone to 150 and mossy cobblestone to 50.");
        }
    }

    public static class VeinUserDefined
    extends VeinConfig {
        public final IBlockState FILL_BLOCK = this.prop("_block", Blocks.field_150336_V.func_176223_P(), "The block this user-defined vein generates.");
        public final boolean COVERED = this.prop("covered", false, "When set to true, this vein will not generate any exposed blocks (like water/lava veins).\nI only recommend using this to add new fluid veins.");

        @Override
        String name() {
            return "veins_xtra_userdefined_" + this.KEY;
        }

        @Override
        String comment() {
            return "Options related to a user-defined vein (index=" + this.KEY + ").\nThese custom veins are generated in order of their indexes (i.e. 0, 1, 2, ...).";
        }

        VeinUserDefined(int index) {
            super(String.valueOf(index), 0.0f, 0, 62, 9);
        }
    }

    public static class VeinReplacement
    extends VeinConfig {
        private final int VANILLA_PLACEMENTS;

        @Override
        String name() {
            return "veins_xtra_" + this.KEY;
        }

        @Override
        String comment() {
            return "Options related to additional " + this.KEY + " vein generation.\nThis ignores the 'disabled' vein settings, allowing you to replace normal vein generation.\nDefaults are equivalent to the vanilla values except for count (vanilla count is " + this.VANILLA_PLACEMENTS + ").";
        }

        VeinReplacement(String key, int vanillaCount, int minHeight, int maxHeight, int size) {
            super(key, 0.0f, minHeight, maxHeight, size);
            this.VANILLA_PLACEMENTS = vanillaCount;
        }
    }

    public static class VeinConfig
    extends PropertyCategory {
        private final float PLACEMENTS;
        private final EnvironmentListConfig PLACEMENTS_EXCEPTIONS;
        public final int[] HEIGHTS;
        public final int[] SIZES;
        public final boolean DEBUG_MARKER;

        @Override
        String name() {
            return "veins_" + this.KEY;
        }

        @Override
        String comment() {
            return "Options related to " + this.KEY + " 'vein' generation.";
        }

        VeinConfig(String key, float placements, int minHeight, int maxHeight, int size) {
            this(key, placements, minHeight, maxHeight, size, size);
        }

        VeinConfig(String key, float placements, int minHeight, int maxHeight, int minSize, int maxSize) {
            super(key);
            this.PLACEMENTS = this.prop("_count", placements, "The number of placement attempts for this vein type.\nA decimal represents a chance for a placement attempt (e.g., 0.3 means 30% chance for one attempt).");
            this.PLACEMENTS_EXCEPTIONS = this.prop("_count_exceptions", new TargetEnvironment[0], "The number of placement attempts when generating in particular locations.\nMore specific locations take priority over others (biome < biome* < global setting).");
            this.HEIGHTS = new int[]{this.prop("height_min", minHeight, "The minimum height to generate this vein type at."), this.prop("height_max", maxHeight, "The maximum height to generate this vein type at.")};
            this.SIZES = new int[]{this.prop("size_min", minSize, "The minimum size for this vein type."), this.prop("size_max", maxSize, "The maximum size for this vein type.")};
            this.DEBUG_MARKER = this.prop("testing_marker", false, "When set to true, places a 1x1 column of this ore to the height limit from each generated vein.\nThis is game-breaking and laggy. You must also enable debug mode in the main mod config.\nConsider using a tool to strip away all stone/dirt/etc. for more intensive testing.");
        }

        public float getPlacements(World world, BlockPos pos) {
            return this.PLACEMENTS_EXCEPTIONS.getValueForLocation(world, pos, this.PLACEMENTS);
        }
    }

    public class VEINS
    extends PropertyCategory {
        public final int USER_DEFINED_VEIN_COUNT = this.prop("_user_defined_veins", 0, "Number of additional vein types to generate.\nReload the game after setting this option for their config categories to be auto-generated.\nThere will be one config category per user-defined vein.");
        public final VeinUserDefined[] USER_DEFINED_VEINS;
        public final boolean DISABLE_COAL_VEINS;
        public final boolean DISABLE_DIAMOND_VEINS;
        public final boolean DISABLE_DIRT_VEINS;
        public final boolean DISABLE_GOLD_VEINS;
        public final boolean DISABLE_GRAVEL_VEINS;
        public final boolean DISABLE_IRON_VEINS;
        public final boolean DISABLE_LAPIS_VEINS;
        public final boolean DISABLE_REDSTONE_VEINS;
        public final boolean DISABLE_QUARTZ_VEINS;
        public final boolean DISABLE_DIORITE_VEINS;
        public final boolean DISABLE_GRANITE_VEINS;
        public final boolean DISABLE_ANDESITE_VEINS;
        public final boolean DISABLE_EMERALD_VEINS;
        public final boolean DISABLE_SILVERFISH_VEINS;
        public final boolean DISABLE_LAVA_VEINS;

        public VEINS() {
            VeinUserDefined[] customVeins = new VeinUserDefined[this.USER_DEFINED_VEIN_COUNT];
            for (int i = 0; i < this.USER_DEFINED_VEIN_COUNT; ++i) {
                customVeins[i] = new VeinUserDefined(i);
            }
            this.USER_DEFINED_VEINS = customVeins;
            this.DISABLE_COAL_VEINS = this.prop("disable_coal_veins", false, "Suppresses coal ore generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_DIAMOND_VEINS = this.prop("disable_diamond_veins", false, "Suppresses diamond ore generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_DIRT_VEINS = this.prop("disable_dirt_veins", false, "Suppresses dirt vein generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_GOLD_VEINS = this.prop("disable_gold_veins", false, "Suppresses gold ore generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_GRAVEL_VEINS = this.prop("disable_gravel_veins", false, "Suppresses gravel vein generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_IRON_VEINS = this.prop("disable_iron_veins", false, "Suppresses iron ore generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_LAPIS_VEINS = this.prop("disable_lapis_veins", false, "Suppresses lapis lazuli ore generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_REDSTONE_VEINS = this.prop("disable_redstone_veins", false, "Suppresses redstone ore generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_QUARTZ_VEINS = this.prop("disable_quartz_veins", false, "Suppresses quartz ore generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_DIORITE_VEINS = this.prop("disable_diorite_veins", false, "Suppresses diorite vein generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_GRANITE_VEINS = this.prop("disable_granite_veins", false, "Suppresses granite vein generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_ANDESITE_VEINS = this.prop("disable_andesite_veins", false, "Suppresses andesite vein generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_EMERALD_VEINS = this.prop("disable_emerald_veins", false, "Suppresses emerald ore generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_SILVERFISH_VEINS = this.prop("disable_silverfish_veins", true, "Suppresses silverfish vein generation events when set to true.\nDoes not disable generation added by this mod.");
            this.DISABLE_LAVA_VEINS = this.prop("disable_lava_veins", true, "Suppresses lava vein generation events when set to true.\nDoes not disable generation added by this mod.");
        }

        @Override
        String name() {
            return "veins";
        }

        @Override
        String comment() {
            return "Options related to material 'vein' generation in general.";
        }
    }

    public class TERRAIN
    extends PropertyCategory {
        public final TargetBlock.TargetMap REPLACEABLE_BLOCKS;
        public final float SILVERFISH_AGGRO_CHANCE;
        public final WeightedBlockConfig.BlockList FLOOR_TRAP_COVERS;

        public TERRAIN() {
            TargetBlock[] targetBlockArray;
            if (dimensionLoading == DimensionType.NETHER.func_186068_a()) {
                TargetBlock[] targetBlockArray2 = new TargetBlock[1];
                targetBlockArray = targetBlockArray2;
                targetBlockArray2[0] = new TargetBlock(Blocks.field_150424_aL);
            } else if (dimensionLoading == DimensionType.THE_END.func_186068_a()) {
                TargetBlock[] targetBlockArray3 = new TargetBlock[1];
                targetBlockArray = targetBlockArray3;
                targetBlockArray3[0] = new TargetBlock(Blocks.field_150377_bs);
            } else {
                targetBlockArray = this.buildNaturalStoneTargets();
            }
            this.REPLACEABLE_BLOCKS = this.prop("_replaceable_blocks", targetBlockArray, "The block(s) that can be replaced in this dimension by terrain generation.");
            this.SILVERFISH_AGGRO_CHANCE = this.prop("silverfish_aggressive_chance", dimensionLoading == DimensionType.OVERWORLD.func_186068_a() ? 0.1f : 0.3f, "The chance for silverfish emerging from this mod's silverfish blocks in this dimension to spawn\nalready calling for reinforcements, if any players are within eyesight. Be warned this can cascade.", R_FLT_ONE);
            this.FLOOR_TRAP_COVERS = this.prop("floor_trap_covers", this.makeDefaultFloorTrapCovers(), "A weighted list of blocks to pick from when covering a floor trap in this dimension.");
        }

        @Override
        String name() {
            return "_terrain";
        }

        @Override
        String comment() {
            return "Options related to the dimension's terrain.";
        }

        private WeightedBlockConfig[] makeDefaultFloorTrapCovers() {
            if (dimensionLoading == DimensionType.NETHER.func_186068_a()) {
                return new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BROWN), 50), new WeightedBlockConfig(Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED), 50), new WeightedBlockConfig(Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 50), new WeightedBlockConfig(Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.NETHERBRICK), 150), new WeightedBlockConfig(Blocks.field_150423_aK.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH), 10), new WeightedBlockConfig(Blocks.field_150423_aK.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.SOUTH), 10), new WeightedBlockConfig(Blocks.field_150423_aK.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.EAST), 10), new WeightedBlockConfig(Blocks.field_150423_aK.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.WEST), 10), new WeightedBlockConfig((Block)Blocks.field_150337_Q, 50), new WeightedBlockConfig((Block)Blocks.field_150338_P, 50), new WeightedBlockConfig(Blocks.field_150449_bY, 20), new WeightedBlockConfig(Blocks.field_150414_aQ, 1)};
            }
            if (dimensionLoading == DimensionType.THE_END.func_186068_a()) {
                return new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150445_bS, 100), new WeightedBlockConfig(Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SAND), 200), new WeightedBlockConfig(Blocks.field_185772_cY, 100), new WeightedBlockConfig(Blocks.field_150414_aQ, 1)};
            }
            return new WeightedBlockConfig[]{new WeightedBlockConfig(Blocks.field_150456_au, 100), new WeightedBlockConfig(Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.SILVER), 34), new WeightedBlockConfig(Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.GRAY), 33), new WeightedBlockConfig(Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BROWN), 33), new WeightedBlockConfig(Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.STONE), 34), new WeightedBlockConfig(Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SMOOTHBRICK), 33), new WeightedBlockConfig(Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE), 33), new WeightedBlockConfig((Block)Blocks.field_150337_Q, 20), new WeightedBlockConfig((Block)Blocks.field_150338_P, 20), new WeightedBlockConfig(Blocks.field_150352_o, 10), new WeightedBlockConfig(Blocks.field_150414_aQ, 1)};
        }

        private TargetBlock[] buildNaturalStoneTargets() {
            ArrayList<TargetBlock> naturalStone = new ArrayList<TargetBlock>();
            for (BlockStone.EnumType stoneType : BlockStone.EnumType.values()) {
                if (!stoneType.func_190912_e()) continue;
                naturalStone.add(new TargetBlock(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)stoneType)));
            }
            return naturalStone.toArray(new TargetBlock[0]);
        }
    }

    public class GENERAL
    extends PropertyCategory {
        public final boolean DEBUG = this.prop("_debug_mode", false, "If true, the mod will start up in debug mode.");
        private final String[] ENABLED_DIMENSIONS = this.prop("_enabled_dimensions", new String[]{DimensionType.OVERWORLD.func_186065_b(), DimensionType.NETHER.func_186065_b()}, "The dimensions that Deadly World will alter terrain generation in.\nThis main config doubles as the overworld config file (dimension 0).\nOther dimensions each have their own config file.", "dimension_name, dimension_id");
        public final float FLOOR_TRAP_HARDNESS = this.prop("block_hardness_floor_trap", 5.0f, "How long it takes to break floor traps.");
        public final int FLOOR_TRAP_HARVEST_LEVEL = this.prop("block_harvest_level_floor_trap", 1, "The level of pickaxe required to break floor traps in a reasonable time.\nFor vanilla: Wood/Gold = 0, Stone = 1, Iron = 2, Diamond = 3.");
        public final float FLOOR_TRAP_RESISTANCE = this.prop("block_resistance_floor_trap", 25.0f, "How resistant floor traps are to being destroyed by explosions.\nTypical explosion resistance is 5 times the hardness.");
        public final float SPAWNER_HARDNESS = this.prop("block_hardness_spawners", 10.0f, "How long it takes to break Deadly World spawners.\nThe default hardness is the same as vanilla mob spawners.");
        public final int SPAWNER_HARVEST_LEVEL = this.prop("block_harvest_level_spawners", 2, "The level of pickaxe required to break Deadly World spawners in a reasonable time.\nFor vanilla: Wood/Gold = 0, Stone = 1, Iron = 2, Diamond = 3.");
        public final float SPAWNER_RESISTANCE = this.prop("block_resistance_spawners", 2000.0f, "How resistant Deadly World spawners are to being destroyed by explosions.\nThe default explosion resistance is the same as vanilla obsidian.");
        public final float TOWER_DISPENSER_HARDNESS = this.prop("block_hardness_tower_dispenser", 10.0f, "How long it takes to break tower dispensers.");
        public final int TOWER_DISPENSER_HARVEST_LEVEL = this.prop("block_harvest_level_tower_dispenser", 2, "The level of pickaxe required to break tower dispensers in a reasonable time.\nFor vanilla: Wood/Gold = 0, Stone = 1, Iron = 2, Diamond = 3.");
        public final float TOWER_DISPENSER_RESISTANCE = this.prop("block_resistance_tower_dispenser", 50.0f, "How resistant tower dispensers are to being destroyed by explosions.\nTypical explosion resistance is 5 times the hardness.");
        public final boolean FEATURE_TESTER = this.prop("item_feature_tester", true, "Set this to false to disable the 'Feature Tester' item.");
        public final boolean SILVERFISH_AUTOGEN = this.prop("silverfish_blocks", true, "Set this to false to disable the blocks automatically built and registered to disguise themselves\nas the blocks defined as 'replaceable' below.\nDoes not disable the infested variants of cobblestone or the dungeon fill/variant blocks you have set in\nthe \"_terrain\" category of each dimension.");
        public final TargetBlock.TargetMap SILVERFISH_REPLACEABLE = this.prop("silverfish_blocks_replaceable", new TargetBlock[]{new TargetBlock(Blocks.field_150348_b), new TargetBlock(Blocks.field_150346_d), new TargetBlock(Blocks.field_150322_A), new TargetBlock(Blocks.field_150435_aG), new TargetBlock(Blocks.field_150417_aV), new TargetBlock(Blocks.field_180395_cM), new TargetBlock(Blocks.field_150347_e), new TargetBlock(Blocks.field_150342_X), new TargetBlock(Blocks.field_150341_Y), new TargetBlock(Blocks.field_150352_o), new TargetBlock(Blocks.field_150366_p), new TargetBlock(Blocks.field_150365_q), new TargetBlock(Blocks.field_150369_x), new TargetBlock(Blocks.field_150482_ag), new TargetBlock(Blocks.field_150450_ax), new TargetBlock(Blocks.field_150412_bA), new TargetBlock(Blocks.field_150424_aL), new TargetBlock(Blocks.field_150425_aM), new TargetBlock(Blocks.field_150385_bj), new TargetBlock(Blocks.field_189879_dh), new TargetBlock(Blocks.field_150449_bY), new TargetBlock(Blocks.field_150377_bs), new TargetBlock(Blocks.field_185767_cT), new TargetBlock(Blocks.field_185768_cU), new TargetBlock(Blocks.field_185772_cY)}, "List of blockstates that can be replaced by silverfish blocks in ALL dimensions. Each block defined here\nwill have a corresponding infested version generated and registered. All valid blockstates of these blocks\ncan function and will appear in the creative menu (plus cobblestone and all dungeon fill/variant blocks), but\nthe generator will only replace blocks matching the state definitions in this list.\n * Note that only full-cube blocks are supported. There is no reason this shouldn't work with any full-cube\nblocks used in world generation from other mods.");
        public final double PROGRESSIVE_RECOVERY = this.prop("spawner_progressive_recovery", 0.0025, " * Progressive spawn delay:\nBy default, spawners added by this mod use a mechanic called \"progressive spawn delay\". Unlike vanilla\nspawners that have a completely random delay chosen anywhere from 10 to 40 seconds (what awful variance!),\nDeadly World spawners will start from a 10 second delay and slowly increase up to 40 seconds delay as you\ncontinue to stand close to them (with the same vanilla delay limits of 200-800 ticks).\nA spawner's \"delay buildup\" starts at its minimum delay and increases by its progressive delay (+/- 10%)\nwith each successful spawn, up to its maximum delay.\nThe progressive delay of each spawner is determined by its configs when generated and can then be\noverwritten by nbt editing.\n * Now, for the actual config option:\nThe rate at which the progressive spawn delay on spawners recovers while no players are within range.\nInactive spawners' \"delay buildups\" are reduced by (progressive delay * this value) each tick.");

        @Override
        String name() {
            return "_general";
        }

        @Override
        String comment() {
            return "General and/or miscellaneous options not related to a specific dimension.";
        }
    }
}

