/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.client;

import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.SidedModProxy;
import fathertoast.deadlyworld.block.BlockDeadlySilverfish;
import fathertoast.deadlyworld.block.state.EnumFloorTrapType;
import fathertoast.deadlyworld.block.state.EnumSpawnerType;
import fathertoast.deadlyworld.block.state.EnumTowerType;
import fathertoast.deadlyworld.block.state.IExclusiveMetaProvider;
import fathertoast.deadlyworld.client.ModelLoaderDeadlySilverfish;
import fathertoast.deadlyworld.client.StateMapperDeadlySilverfish;
import fathertoast.deadlyworld.client.TileEntityDeadlySpawnerRenderer;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.tileentity.TileEntityDeadlySpawner;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientProxy
extends SidedModProxy {
    @Override
    public void preInit() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderDeadlySilverfish());
    }

    @Override
    public void registerModels() {
        this.registerModel(ModObjects.EVENT_ITEM);
        this.registerModels(Item.func_150898_a((Block)ModObjects.DEADLY_SPAWNER), EnumSpawnerType.values());
        this.registerModels(Item.func_150898_a((Block)ModObjects.FLOOR_TRAP), EnumFloorTrapType.values());
        this.registerModels(Item.func_150898_a((Block)ModObjects.TOWER_DISPENSER), EnumTowerType.values());
        if (Config.get().GENERAL.FEATURE_TESTER) {
            this.registerModel(ModObjects.FEATURE_TESTER);
        }
        StateMapperDeadlySilverfish stateMapper = new StateMapperDeadlySilverfish();
        for (BlockDeadlySilverfish infestedBlock : ModObjects.getSilverfishBlocksOrdered()) {
            ModelLoader.setCustomStateMapper((Block)infestedBlock, (IStateMapper)stateMapper);
            Item infestedItem = Item.func_150898_a((Block)infestedBlock);
            if (infestedBlock.DISGUISE_PROPERTY == null) {
                ModelLoader.setCustomModelResourceLocation((Item)infestedItem, (int)0, (ModelResourceLocation)stateMapper.func_178132_a(infestedBlock.func_176223_P()));
                continue;
            }
            for (int meta : infestedBlock.DISGUISE_PROPERTY.func_177700_c()) {
                ModelLoader.setCustomModelResourceLocation((Item)infestedItem, (int)meta, (ModelResourceLocation)stateMapper.func_178132_a(infestedBlock.func_176203_a(meta)));
            }
        }
    }

    private void registerModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "normal"));
    }

    private void registerModels(Item item, IExclusiveMetaProvider ... metaProviders) {
        String regName = item.getRegistryName().toString();
        for (IExclusiveMetaProvider provider : metaProviders) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)provider.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(regName, "type=" + provider.func_176610_l()));
        }
    }

    @Override
    public void init() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDeadlySpawner.class, (TileEntitySpecialRenderer)new TileEntityDeadlySpawnerRenderer());
    }
}

