/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.block.state;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyHelper;
import net.minecraft.block.state.IBlockState;

public class PropertyDisguiseBlock
extends PropertyHelper<Integer> {
    private final Block disguiseBlock;
    private final ImmutableSet<Integer> allowedValues;
    public Block parentBlock;

    public PropertyDisguiseBlock(Block disguise) {
        super("disguise", Integer.class);
        if (disguise.func_176223_P().func_177227_a().isEmpty()) {
            throw new IllegalArgumentException("Disguise property should not be used for blocks without properties");
        }
        this.disguiseBlock = disguise;
        HashSet set = Sets.newHashSet();
        for (IBlockState state : disguise.func_176194_O().func_177619_a()) {
            set.add(disguise.func_176201_c(state));
        }
        this.allowedValues = ImmutableSet.copyOf((Collection)set);
    }

    public int getMeta(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this);
    }

    public IBlockState setMeta(int meta) {
        return this.parentBlock.func_176223_P().func_177226_a((IProperty)this, (Comparable)Integer.valueOf(meta));
    }

    public IBlockState toDisguise(IBlockState infestedState) {
        return this.disguiseBlock.func_176203_a(this.getMeta(infestedState));
    }

    public IBlockState fromDisguise(IBlockState disguiseState) {
        return this.setMeta(this.disguiseBlock.func_176201_c(disguiseState));
    }

    public Collection<Integer> func_177700_c() {
        return this.allowedValues;
    }

    public String getName(Integer value) {
        return value.toString();
    }

    public Optional<Integer> func_185929_b(String value) {
        try {
            Integer integer = Integer.valueOf(value);
            return this.allowedValues.contains((Object)integer) ? Optional.of((Object)integer) : Optional.absent();
        }
        catch (NumberFormatException ex) {
            return Optional.absent();
        }
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.disguiseBlock.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PropertyDisguiseBlock && super.equals(other)) {
            return this.disguiseBlock.equals(((PropertyDisguiseBlock)((Object)other)).disguiseBlock);
        }
        return false;
    }
}

