/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.block.state;

import fathertoast.deadlyworld.DeadlyWorldMod;
import fathertoast.deadlyworld.block.state.IExclusiveMetaProvider;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.featuregen.WorldGenTowerTrap;
import fathertoast.deadlyworld.loot.LootEntryItemBuilder;
import fathertoast.deadlyworld.loot.LootPoolBuilder;
import fathertoast.deadlyworld.loot.LootTableBuilder;
import fathertoast.deadlyworld.tileentity.EnumPotionArrowType;
import fathertoast.deadlyworld.tileentity.TileEntityTowerDispenser;
import fathertoast.deadlyworld.tileentity.TrapHelper;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTableList;

public enum EnumTowerType implements IExclusiveMetaProvider
{
    DEFAULT("simple"){

        @Override
        public Config.FeatureTower getFeatureConfig(Config dimConfig) {
            return dimConfig.TOWER_DEFAULT;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Arrow", Items.field_151032_g, 2, 16);
            loot.addClusterDrop("cluster", "Redstone", Items.field_151137_ax);
            loot.addPool(new LootPoolBuilder("rare").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchanted Bow", (Item)Items.field_151031_f).enchant(30, true).toLootEntry()).toLootPool());
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomEnchant(Enchantments.field_180308_g, Enchantments.field_185309_u, Enchantments.field_185310_v, Enchantments.field_185312_x).toLootEntry()).toLootPool());
        }

        @Override
        public void triggerAttack(Config dimConfig, TileEntityTowerDispenser towerEntity, EntityPlayer target, Vec3d center, Vec3d offset, Vec3d vecToTarget, double distanceH) {
            EntityTippedArrow arrow = new EntityTippedArrow(towerEntity.func_145831_w());
            towerEntity.shootArrow(center, offset, vecToTarget, distanceH, this.getFeatureConfig((Config)dimConfig).PROJECTILE_SPEED, this.getFeatureConfig((Config)dimConfig).PROJECTILE_VARIANCE, (EntityArrow)arrow);
        }
    }
    ,
    FIRE("fire"){

        @Override
        public Config.FeatureTower getFeatureConfig(Config dimConfig) {
            return dimConfig.TOWER_FIRE;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Arrow", Items.field_151032_g, 2, 16);
            loot.addClusterDrop("cluster", "Redstone", Items.field_151137_ax);
            loot.addPool(new LootPoolBuilder("rare").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchanted Bow", (Item)Items.field_151031_f).enchant(30, true).toLootEntry()).toLootPool());
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomEnchant(Enchantments.field_180308_g, Enchantments.field_77329_d, Enchantments.field_185311_w, Enchantments.field_185312_x).toLootEntry()).toLootPool());
            loot.addSemicommonDrop("semicommon", "Coal", Items.field_151044_h);
            loot.addUncommonDrop("uncommon", "Fire Charge", Items.field_151059_bz);
        }

        @Override
        public void triggerAttack(Config dimConfig, TileEntityTowerDispenser towerEntity, EntityPlayer target, Vec3d center, Vec3d offset, Vec3d vecToTarget, double distanceH) {
            EntityTippedArrow arrow = new EntityTippedArrow(towerEntity.func_145831_w());
            arrow.func_70015_d(100);
            towerEntity.shootArrow(center, offset, vecToTarget, distanceH, this.getFeatureConfig((Config)dimConfig).PROJECTILE_SPEED, this.getFeatureConfig((Config)dimConfig).PROJECTILE_VARIANCE, (EntityArrow)arrow);
        }
    }
    ,
    POTION("potion"){

        @Override
        public Config.FeatureTower getFeatureConfig(Config dimConfig) {
            return dimConfig.TOWER_POTION;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Arrow", Items.field_151032_g, 2, 16);
            loot.addClusterDrop("cluster", "Redstone", Items.field_151137_ax);
            loot.addPool(new LootPoolBuilder("rare").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchanted Bow", (Item)Items.field_151031_f).enchant(30, true).toLootEntry()).toLootPool());
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomEnchant(Enchantments.field_180308_g, Enchantments.field_180310_c, Enchantments.field_92091_k, Enchantments.field_185312_x).toLootEntry()).toLootPool());
            loot.addLootTable("external", "Witch Loot", LootTableList.field_186432_n);
            loot.addUncommonDrop("uncommon", "Brewing", Items.field_179556_br, Items.field_151065_br, Items.field_151060_bw, Items.field_151073_bk, Items.field_151064_bs, Items.field_151150_bK, Items.field_151071_bq);
            loot.addPool(new LootPoolBuilder("potionarrows").addConditions(LootPoolBuilder.UNCOMMON_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Poison Arrow", PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185254_z)).setCount(1, 8).toLootEntry()).addEntry((LootEntry)new LootEntryItemBuilder("Harm Arrow", PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185252_x)).setCount(1, 8).toLootEntry()).addEntry((LootEntry)new LootEntryItemBuilder("Weakness Arrow", PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185226_I)).setCount(1, 8).toLootEntry()).addEntry((LootEntry)new LootEntryItemBuilder("Slowness Arrow", PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185246_r)).setCount(1, 8).toLootEntry()).addEntry((LootEntry)new LootEntryItemBuilder("Poison II Arrow", PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185219_B)).setCount(1, 8).toLootEntry()).addEntry((LootEntry)new LootEntryItemBuilder("Harm II Arrow", PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185253_y)).setCount(1, 8).toLootEntry()).toLootPool());
        }

        @Override
        public void triggerAttack(Config dimConfig, TileEntityTowerDispenser towerEntity, EntityPlayer target, Vec3d center, Vec3d offset, Vec3d vecToTarget, double distanceH) {
            EnumPotionArrowType type;
            String TAG_POTION_TYPE = "PotionType";
            World world = towerEntity.func_145831_w();
            NBTTagCompound typeData = towerEntity.getOrCreateTypeData();
            if (typeData.func_150297_b("PotionType", TrapHelper.NBT_TYPE_STRING)) {
                type = EnumPotionArrowType.fromString(typeData.func_74779_i("PotionType"));
            } else {
                type = dimConfig.TOWER_POTION.POTION_TYPE_LIST.nextItem(world.field_73012_v);
                if (type == null) {
                    type = EnumPotionArrowType.RANDOM;
                }
                typeData.func_74778_a("PotionType", type.toString());
            }
            EntityTippedArrow arrow = new EntityTippedArrow(towerEntity.func_145831_w());
            type.addEffects(world.field_73012_v, dimConfig, arrow);
            towerEntity.shootArrow(center, offset, vecToTarget, distanceH, this.getFeatureConfig((Config)dimConfig).PROJECTILE_SPEED, this.getFeatureConfig((Config)dimConfig).PROJECTILE_VARIANCE, (EntityArrow)arrow);
        }
    }
    ,
    GATLING("gatling"){

        @Override
        public Config.FeatureTower getFeatureConfig(Config dimConfig) {
            return dimConfig.TOWER_GATLING;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Arrow", Items.field_151032_g, 4, 24);
            loot.addClusterDrop("cluster", "Redstone", Items.field_151137_ax);
            loot.addPool(new LootPoolBuilder("rare").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchanted Bow", (Item)Items.field_151031_f).enchant(30, true).toLootEntry()).toLootPool());
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomEnchant(Enchantments.field_180308_g, Enchantments.field_185310_v, Enchantments.field_185312_x).toLootEntry()).toLootPool());
            loot.addClusterDrop("cluster2", "Lapis Lazuli", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
            loot.addRareDrop("money", "Gem", Items.field_151045_i, Items.field_151166_bC);
        }

        @Override
        public void triggerAttack(Config dimConfig, TileEntityTowerDispenser towerEntity, EntityPlayer target, Vec3d center, Vec3d offset, Vec3d vecToTarget, double distanceH) {
            EntityTippedArrow arrow = new EntityTippedArrow(towerEntity.func_145831_w());
            towerEntity.shootArrow(center, offset, vecToTarget, distanceH, this.getFeatureConfig((Config)dimConfig).PROJECTILE_SPEED, this.getFeatureConfig((Config)dimConfig).PROJECTILE_VARIANCE, (EntityArrow)arrow);
        }
    }
    ,
    FIREBALL("fireball", "fireball tower traps"){

        @Override
        public Config.FeatureTower getFeatureConfig(Config dimConfig) {
            return dimConfig.TOWER_FIREBALL;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addSemicommonDrop("semicommon", "Quartz", Items.field_151128_bU);
            loot.addClusterDrop("cluster", "Redstone", Items.field_151137_ax);
            loot.addClusterDrop("cluster2", "Lapis Lazuli", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomEnchant(Enchantments.field_180308_g, Enchantments.field_77329_d, Enchantments.field_185311_w, Enchantments.field_77334_n).toLootEntry()).toLootPool());
            loot.addCommonDrop("common", "Fire Charge", Items.field_151059_bz, 1, 8);
            loot.addUncommonDrop("uncommon", "Blaze Powder", Items.field_151065_br);
        }

        @Override
        public void triggerAttack(Config dimConfig, TileEntityTowerDispenser towerEntity, EntityPlayer target, Vec3d center, Vec3d offset, Vec3d vecToTarget, double distanceH) {
            BlockPos topBlock;
            double spawnOffset = 0.6;
            World world = towerEntity.func_145831_w();
            if (world.func_175623_d(topBlock = towerEntity.func_174877_v().func_177982_a(0, 1, 0))) {
                world.func_175656_a(topBlock, Blocks.field_150480_ab.func_176223_P());
            }
            float accel = this.getFeatureConfig((Config)dimConfig).PROJECTILE_SPEED;
            float var = (float)Math.sqrt(distanceH) / 12.0f * this.getFeatureConfig((Config)dimConfig).PROJECTILE_VARIANCE;
            for (float count = this.getFeatureConfig((Config)dimConfig).ATTACK_DAMAGE; count >= 1.0f || count > 0.0f && count > world.field_73012_v.nextFloat(); count -= 1.0f) {
                EntitySmallFireball fireball = new EntitySmallFireball(world, center.field_72450_a + offset.field_72450_a * 0.6, center.field_72448_b, center.field_72449_c + offset.field_72449_c * 0.6, vecToTarget.field_72450_a * (double)accel + world.field_73012_v.nextGaussian() * (double)var, vecToTarget.field_72448_b * (double)accel + world.field_73012_v.nextGaussian() * (double)var, vecToTarget.field_72449_c * (double)accel + world.field_73012_v.nextGaussian() * (double)var);
                world.func_72838_d((Entity)fireball);
            }
            towerEntity.func_145831_w().func_184148_a(null, center.field_72450_a, center.field_72448_b, center.field_72449_c, SoundEvents.field_187606_E, SoundCategory.BLOCKS, 1.0f, 1.0f / (towerEntity.func_145831_w().field_73012_v.nextFloat() * 0.4f + 0.8f));
        }
    };

    public static final PropertyEnum<EnumTowerType> PROPERTY;
    public final ResourceLocation LOOT_TABLE_BLOCK;
    public final String NAME;
    public final String DISPLAY_NAME;

    private EnumTowerType(String name) {
        this(name, name.replace("_", " ") + " arrow tower traps");
    }

    private EnumTowerType(String name, String prettyName) {
        this.NAME = name;
        this.DISPLAY_NAME = prettyName;
        this.LOOT_TABLE_BLOCK = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("deadlyworld", "blocks/tower_dispenser/" + name));
    }

    public abstract Config.FeatureTower getFeatureConfig(Config var1);

    public abstract void buildBlockLootTable(LootTableBuilder var1);

    public abstract void triggerAttack(Config var1, TileEntityTowerDispenser var2, EntityPlayer var3, Vec3d var4, Vec3d var5, Vec3d var6, double var7);

    public WorldGenTowerTrap makeWorldGen() {
        return new WorldGenTowerTrap(this);
    }

    public String toString() {
        return this.NAME;
    }

    public String func_176610_l() {
        return this.NAME;
    }

    @Override
    public int getMetadata() {
        return this.ordinal();
    }

    public static EnumTowerType byMetadata(int meta) {
        if (meta < 0 || meta >= EnumTowerType.values().length) {
            DeadlyWorldMod.log().warn("Attempted to load invalid towertrap type with metadata '{}'", (Object)meta);
            return DEFAULT;
        }
        return EnumTowerType.values()[meta];
    }

    static {
        PROPERTY = PropertyEnum.func_177709_a((String)"type", EnumTowerType.class);
    }
}

