/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.block.state;

import fathertoast.deadlyworld.DeadlyWorldMod;
import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.block.state.IExclusiveMetaProvider;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.config.WeightedBlockConfig;
import fathertoast.deadlyworld.featuregen.WorldGenSpawner;
import fathertoast.deadlyworld.loot.LootEntryItemBuilder;
import fathertoast.deadlyworld.loot.LootPoolBuilder;
import fathertoast.deadlyworld.loot.LootTableBuilder;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTableList;

public enum EnumSpawnerType implements IExclusiveMetaProvider
{
    DEFAULT("simple"){

        @Override
        public Config.FeatureSpawner getFeatureConfig(Config dimConfig) {
            return dimConfig.SPAWNER_DEFAULT;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Lapis Lazuli", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), 1, 8);
            loot.addSemicommonDrop("semicommon", "Iron Ingot", Items.field_151042_j);
            loot.addRareDrop("rare", "Gem", Items.field_151045_i, Items.field_151166_bC);
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomApplicableEnchant().toLootEntry()).toLootPool());
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            loot.addThemePoolExploration();
            super.buildChestLootTable(loot);
        }
    }
    ,
    STREAM("stream"){

        @Override
        public Config.FeatureSpawner getFeatureConfig(Config dimConfig) {
            return dimConfig.SPAWNER_STREAM;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Lapis Lazuli", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), 1, 8);
            loot.addSemicommonDrop("semicommon", "Iron Ingot", Items.field_151042_j);
            loot.addUncommonDrop("uncommon", "Gold Ingot", Items.field_151043_k);
            loot.addRareDrop("rare", "Gem", Items.field_151045_i, Items.field_151166_bC);
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomApplicableEnchant().toLootEntry()).toLootPool());
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            loot.addThemePoolExploration();
            super.buildChestLootTable(loot);
        }
    }
    ,
    SWARM("swarm"){

        @Override
        public Config.FeatureSpawner getFeatureConfig(Config dimConfig) {
            return dimConfig.SPAWNER_SWARM;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Lapis Lazuli", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), 1, 8);
            loot.addSemicommonDrop("semicommon", "Iron Ingot", Items.field_151042_j);
            loot.addClusterDrop("cluster", "Gold Ingot", Items.field_151043_k, 4);
            loot.addRareDrop("rare", "Gem", Items.field_151045_i, Items.field_151166_bC);
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomApplicableEnchant().toLootEntry()).toLootPool());
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            loot.addThemePoolExplosives();
            super.buildChestLootTable(loot);
        }
    }
    ,
    BRUTAL("brutal"){

        @Override
        public Config.FeatureSpawner getFeatureConfig(Config dimConfig) {
            return dimConfig.SPAWNER_BRUTAL;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Lapis Lazuli", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), 1, 8);
            loot.addSemicommonDrop("semicommon", "Iron Ingot", Items.field_151042_j);
            loot.addClusterDrop("cluster", "Flint", Items.field_151145_ak);
            loot.addRareDrop("rare", "Gem", Items.field_151045_i, Items.field_151166_bC);
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomApplicableEnchant().toLootEntry()).toLootPool());
            loot.addUncommonDrop("uncommon", "Potion", PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185241_m), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185248_t), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185223_F));
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            loot.addThemePoolValuable();
            super.buildChestLootTable(loot);
        }

        @Override
        public void decorateSpawner(WorldGenSpawner generator, BlockPos spawnerPos, Config dimConfig, World world, Random random) {
            super.decorateSpawner(generator, spawnerPos, dimConfig, world, random);
            if (dimConfig.SPAWNER_BRUTAL.VINES_CHANCE > 0.0f) {
                for (int y = 0; y <= 1; ++y) {
                    for (EnumFacing facing : EnumFacing.field_176754_o) {
                        BlockPos pos = spawnerPos.func_177982_a(0, y, 0).func_177972_a(facing);
                        if (!(random.nextFloat() < dimConfig.SPAWNER_BRUTAL.VINES_CHANCE) || !world.func_175623_d(pos)) continue;
                        generator.setBlock(dimConfig, world, random, pos, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.func_176267_a((EnumFacing)facing.func_176734_d()), (Comparable)Boolean.valueOf(true)));
                    }
                }
            }
        }

        @Override
        public void initializeEntity(EntityLiving entity, Config dimConfig, World world, BlockPos pos) {
            super.initializeEntity(entity, dimConfig, world, pos);
            if (!(entity instanceof EntityCreeper)) {
                boolean hide = dimConfig.SPAWNER_BRUTAL.AMBIENT_FX;
                if (dimConfig.SPAWNER_BRUTAL.FIRE_RESISTANCE) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 0, hide, !hide));
                }
                if (dimConfig.SPAWNER_BRUTAL.WATER_BREATHING) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76427_o, Integer.MAX_VALUE, 0, hide, !hide));
                }
            }
        }
    }
    ,
    SILVERFISH_NEST("nest", "silverfish nests"){

        @Override
        public Config.FeatureSpawner getFeatureConfig(Config dimConfig) {
            return dimConfig.SILVERFISH_NEST;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Gold Nugget", Items.field_151074_bl, 1, 9);
            loot.addClusterDrop("cluster", "Iron Nugget", Items.field_191525_da, 9);
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomEnchant(Enchantments.field_185308_t, Enchantments.field_185304_p, Enchantments.field_151370_z, Enchantments.field_180312_n, Enchantments.field_185306_r).toLootEntry()).toLootPool());
            ResourceLocation name = EntityList.func_191306_a(EntitySilverfish.class);
            ItemStack spawnEgg = new ItemStack(Items.field_151063_bx);
            ItemMonsterPlacer.func_185078_a((ItemStack)spawnEgg, (ResourceLocation)name);
            loot.addSemicommonDrop("semicommon", "Silverfish Egg", spawnEgg);
            loot.addUncommonDrop("uncommon", "Seeds", Items.field_185163_cU, Items.field_151081_bc, Items.field_151080_bb, Items.field_151014_N);
            loot.addRareDrop("rare", "Special", Items.field_151166_bC, Item.func_150898_a((Block)Blocks.field_150414_aQ));
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            loot.addThemePoolBuggy();
            super.buildChestLootTable(loot);
        }

        @Override
        public void decorateSpawner(WorldGenSpawner generator, BlockPos spawnerPos, Config dimConfig, World world, Random random) {
            IBlockState nestBlock = ModObjects.infest(dimConfig.SILVERFISH_NEST.NEST_BLOCKS.nextBlock(random, Blocks.field_150347_e));
            BlockPos chestPos = spawnerPos.func_177982_a(0, -1, 0);
            if (world.func_180495_p(chestPos).func_177230_c() != Blocks.field_150486_ae) {
                generator.setBlock(dimConfig, world, random, chestPos, nestBlock);
            }
            generator.setBlock(dimConfig, world, random, spawnerPos.func_177982_a(0, 1, 0), nestBlock);
            for (int y = -1; y <= 1; ++y) {
                generator.setBlock(dimConfig, world, random, spawnerPos.func_177982_a(-1, y, 0), nestBlock);
                generator.setBlock(dimConfig, world, random, spawnerPos.func_177982_a(0, y, -1), nestBlock);
                generator.setBlock(dimConfig, world, random, spawnerPos.func_177982_a(1, y, 0), nestBlock);
                generator.setBlock(dimConfig, world, random, spawnerPos.func_177982_a(0, y, 1), nestBlock);
            }
            generator.setBlock(dimConfig, world, random, spawnerPos.func_177982_a(-1, 0, -1), nestBlock);
            generator.setBlock(dimConfig, world, random, spawnerPos.func_177982_a(-1, 0, 1), nestBlock);
            generator.setBlock(dimConfig, world, random, spawnerPos.func_177982_a(1, 0, -1), nestBlock);
            generator.setBlock(dimConfig, world, random, spawnerPos.func_177982_a(1, 0, 1), nestBlock);
        }
    }
    ,
    DUNGEON("dungeon"){

        @Override
        public Config.FeatureSpawner getFeatureConfig(Config dimConfig) {
            return dimConfig.SPAWNER_DUNGEON;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Lapis Lazuli", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), 1, 8);
            loot.addSemicommonDrop("semicommon", "Iron Ingot", Items.field_151042_j);
            loot.addRareDrop("rare", "Gem", Items.field_151045_i, Items.field_151166_bC);
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).enchant(5, 30, true).toLootEntry()).toLootPool());
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
        }

        @Override
        public void decorateSpawner(WorldGenSpawner generator, BlockPos spawnerPos, Config dimConfig, World world, Random random) {
        }
    };

    public static final String FEATURE_PATH = "deadly_spawners/";
    public static final PropertyEnum<EnumSpawnerType> PROPERTY;
    public final ResourceLocation LOOT_TABLE_BLOCK;
    public final ResourceLocation LOOT_TABLE_CHEST;
    public final String NAME;
    public final String DISPLAY_NAME;

    private EnumSpawnerType(String name) {
        this(name, name.replace("_", " ") + " spawners");
    }

    private EnumSpawnerType(String name, String prettyName) {
        this.NAME = name;
        this.DISPLAY_NAME = prettyName;
        this.LOOT_TABLE_BLOCK = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("deadlyworld", "blocks/deadly_spawner/" + name));
        this.LOOT_TABLE_CHEST = new ResourceLocation("deadlyworld", "feature_chests/deadly_spawners/" + name);
        if (!"dungeon".equals(name)) {
            LootTableList.func_186375_a((ResourceLocation)this.LOOT_TABLE_CHEST);
        }
    }

    public abstract Config.FeatureSpawner getFeatureConfig(Config var1);

    public abstract void buildBlockLootTable(LootTableBuilder var1);

    public void buildChestLootTable(LootTableBuilder loot) {
        loot.addLootTable("base", "Vanilla Chest", LootTableList.field_186422_d);
    }

    public boolean canTypeBePlaced(World world, BlockPos position) {
        return !world.func_180495_p(position.func_177982_a(0, 2, 0)).func_185917_h() && world.func_175623_d(position.func_177982_a(0, 1, 0)) && world.func_180495_p(position.func_177982_a(0, -1, 0)).func_185917_h();
    }

    public void decorateSpawner(WorldGenSpawner generator, BlockPos spawnerPos, Config dimConfig, World world, Random random) {
        WeightedBlockConfig.BlockList toppers = this.getFeatureConfig((Config)dimConfig).TOPPER_BLOCKS;
        if (toppers != null && toppers.TOTAL_WEIGHT > 0) {
            generator.setBlock(dimConfig, world, random, spawnerPos.func_177982_a(0, 1, 0), toppers.nextBlock(random));
        }
    }

    public void initializeEntity(EntityLiving entity, Config dimConfig, World world, BlockPos pos) {
        Config.FeatureSpawner config = this.getFeatureConfig(dimConfig);
        if (config.ADDED_ARMOR > 0.0f) {
            EnumSpawnerType.addAttribute((EntityLivingBase)entity, SharedMonsterAttributes.field_188791_g, config.ADDED_ARMOR);
        }
        if (config.ADDED_KNOCKBACK_RESIST > 0.0f) {
            EnumSpawnerType.addAttribute((EntityLivingBase)entity, SharedMonsterAttributes.field_111266_c, config.ADDED_KNOCKBACK_RESIST);
        }
        if (config.ADDED_ARMOR_TOUGHNESS > 0.0f) {
            EnumSpawnerType.addAttribute((EntityLivingBase)entity, SharedMonsterAttributes.field_189429_h, config.ADDED_ARMOR_TOUGHNESS);
        }
        if (config.MULTIPLIER_DAMAGE != 1.0f) {
            EnumSpawnerType.multAttribute((EntityLivingBase)entity, SharedMonsterAttributes.field_111264_e, config.MULTIPLIER_DAMAGE);
        }
        if (config.MULTIPLIER_HEALTH != 1.0f) {
            EnumSpawnerType.multAttribute((EntityLivingBase)entity, SharedMonsterAttributes.field_111267_a, config.MULTIPLIER_HEALTH);
        }
        if (config.MULTIPLIER_SPEED != 1.0f) {
            EnumSpawnerType.multAttribute((EntityLivingBase)entity, SharedMonsterAttributes.field_111263_d, config.MULTIPLIER_SPEED);
        }
        entity.func_70606_j(entity.func_110138_aP());
    }

    public WorldGenSpawner makeWorldGen() {
        return new WorldGenSpawner(this);
    }

    public String toString() {
        return this.NAME;
    }

    public String func_176610_l() {
        return this.NAME;
    }

    @Override
    public int getMetadata() {
        return this.ordinal();
    }

    public static EnumSpawnerType byMetadata(int meta) {
        if (meta < 0 || meta >= EnumSpawnerType.values().length) {
            DeadlyWorldMod.log().warn("Attempted to load invalid spawner type with metadata '{}'", (Object)meta);
            return DEFAULT;
        }
        return EnumSpawnerType.values()[meta];
    }

    private static void addAttribute(EntityLivingBase entity, IAttribute attribute, double amount) {
        try {
            entity.func_110148_a(attribute).func_111128_a(entity.func_110148_a(attribute).func_111125_b() + amount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void multAttribute(EntityLivingBase entity, IAttribute attribute, double amount) {
        try {
            entity.func_110148_a(attribute).func_111128_a(entity.func_110148_a(attribute).func_111125_b() * amount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        PROPERTY = PropertyEnum.func_177709_a((String)"type", EnumSpawnerType.class);
    }
}

