/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.block.state;

import fathertoast.deadlyworld.DeadlyWorldMod;
import fathertoast.deadlyworld.block.state.IExclusiveMetaProvider;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.featuregen.WorldGenFloorTrap;
import fathertoast.deadlyworld.loot.LootEntryItemBuilder;
import fathertoast.deadlyworld.loot.LootPoolBuilder;
import fathertoast.deadlyworld.loot.LootTableBuilder;
import fathertoast.deadlyworld.tileentity.EnumPotionTrapType;
import fathertoast.deadlyworld.tileentity.TileEntityFloorTrap;
import fathertoast.deadlyworld.tileentity.TrapHelper;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTableList;

public enum EnumFloorTrapType implements IExclusiveMetaProvider
{
    TNT("tnt"){

        @Override
        public Config.FeatureFloorTrap getFeatureConfig(Config dimConfig) {
            return dimConfig.FLOOR_TRAP_TNT;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Redstone", Items.field_151137_ax, 1, 8);
            loot.addSemicommonDrop("semicommon", "Iron Ingot", Items.field_151042_j);
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomEnchant(Enchantments.field_185297_d, Enchantments.field_185309_u, Enchantments.field_185302_k).toLootEntry()).toLootPool());
            loot.addClusterDrop("cluster", "Gunpowder", Items.field_151016_H, 5);
            loot.addRareDrop("rare", "TNT", Blocks.field_150335_W);
        }

        @Override
        public void triggerTrap(Config dimConfig, TileEntityFloorTrap trapEntity) {
            World world = trapEntity.func_145831_w();
            double x = (double)trapEntity.func_174877_v().func_177958_n() + 0.5;
            double y = trapEntity.func_174877_v().func_177956_o() + 1;
            double z = (double)trapEntity.func_174877_v().func_177952_p() + 0.5;
            int fuseRange = dimConfig.FLOOR_TRAP_TNT.FUSE_TIME_MAX - dimConfig.FLOOR_TRAP_TNT.FUSE_TIME_MIN;
            if (fuseRange <= 0) {
                fuseRange = 1;
            }
            for (int i = 0; i < dimConfig.FLOOR_TRAP_TNT.TNT_COUNT; ++i) {
                EntityTNTPrimed tntPrimed = new EntityTNTPrimed(world, x, y, z, null);
                float speed = dimConfig.FLOOR_TRAP_TNT.LAUNCH_SPEED * world.field_73012_v.nextFloat() + 0.02f;
                tntPrimed.func_184534_a(dimConfig.FLOOR_TRAP_TNT.FUSE_TIME_MIN + world.field_73012_v.nextInt(fuseRange));
                tntPrimed.field_70159_w *= (double)speed;
                tntPrimed.field_70181_x += (double)(0.1f * world.field_73012_v.nextFloat());
                tntPrimed.field_70179_y *= (double)speed;
                world.func_72838_d((Entity)tntPrimed);
            }
            world.func_184148_a(null, x, y, z, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
    ,
    TNT_MOB("tnt_mob"){

        @Override
        public Config.FeatureFloorTrap getFeatureConfig(Config dimConfig) {
            return dimConfig.FLOOR_TRAP_TNT_MOB;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Redstone", Items.field_151137_ax, 1, 8);
            loot.addSemicommonDrop("semicommon", "Iron Ingot", Items.field_151042_j);
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomEnchant(Enchantments.field_185297_d, Enchantments.field_185309_u, Enchantments.field_185302_k).toLootEntry()).toLootPool());
            loot.addClusterDrop("cluster", "Gunpowder", Items.field_151016_H, 5);
            loot.addRareDrop("rare", "TNT", Blocks.field_150335_W);
            loot.addRareDrop("???", "Cake", Blocks.field_150414_aQ);
        }

        @Override
        public void triggerTrap(Config dimConfig, TileEntityFloorTrap trapEntity) {
            EntityZombie entity;
            ResourceLocation registryName;
            Class<EntityZombie> entityToSpawn;
            World world = trapEntity.func_145831_w();
            double x = (double)trapEntity.func_174877_v().func_177958_n() + 0.5;
            double y = trapEntity.func_174877_v().func_177956_o() + 1;
            double z = (double)trapEntity.func_174877_v().func_177952_p() + 0.5;
            int fuseRange = dimConfig.FLOOR_TRAP_TNT_MOB.FUSE_TIME_MAX - dimConfig.FLOOR_TRAP_TNT_MOB.FUSE_TIME_MIN;
            if (fuseRange <= 0) {
                fuseRange = 1;
            }
            if ((entityToSpawn = EntityList.getClass((ResourceLocation)(registryName = dimConfig.FLOOR_TRAP_TNT_MOB.SPAWN_LIST.nextItem(world.field_73012_v)))) == null) {
                DeadlyWorldMod.log().warn("TNT mob floor trap received non-registered entity name '{}' - This is probably caused by an error or change in the config for DIM_{} (defaulting to zombie)", (Object)registryName, (Object)world.field_73011_w.getDimension());
                entityToSpawn = EntityZombie.class;
            }
            EntityLivingBase livingEntity = null;
            try {
                entity = (Entity)entityToSpawn.getConstructor(World.class).newInstance(world);
            }
            catch (Exception ex) {
                DeadlyWorldMod.log().error("Encountered exception while constructing entity '{}'", entityToSpawn, (Object)ex);
                entity = new EntityZombie(world);
            }
            entity.func_70080_a(x, y, z, world.field_73012_v.nextFloat() * 2.0f * (float)Math.PI, 0.0f);
            entity.field_70181_x = 0.3f;
            if (entity instanceof EntityLivingBase) {
                IAttributeInstance attrib;
                livingEntity = (EntityLivingBase)entity;
                if (dimConfig.FLOOR_TRAP_TNT_MOB.MULTIPLIER_HEALTH != 1.0f) {
                    try {
                        attrib = livingEntity.func_110148_a(SharedMonsterAttributes.field_111267_a);
                        attrib.func_111128_a(attrib.func_111125_b() * (double)dimConfig.FLOOR_TRAP_TNT_MOB.MULTIPLIER_HEALTH);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (dimConfig.FLOOR_TRAP_TNT_MOB.MULTIPLIER_SPEED != 1.0f) {
                    try {
                        attrib = livingEntity.func_110148_a(SharedMonsterAttributes.field_111263_d);
                        attrib.func_111128_a(attrib.func_111125_b() * (double)dimConfig.FLOOR_TRAP_TNT_MOB.MULTIPLIER_SPEED);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                livingEntity.func_70606_j(livingEntity.func_110138_aP());
                livingEntity.func_70604_c((EntityLivingBase)trapEntity.getTarget());
            }
            EntityTNTPrimed tntPrimed = new EntityTNTPrimed(world, x, y, z, livingEntity);
            tntPrimed.func_82149_j((Entity)entity);
            tntPrimed.func_184534_a(dimConfig.FLOOR_TRAP_TNT_MOB.FUSE_TIME_MIN + world.field_73012_v.nextInt(fuseRange));
            tntPrimed.func_184205_a((Entity)entity, true);
            world.func_72838_d((Entity)entity);
            world.func_72838_d((Entity)tntPrimed);
            world.func_184148_a(null, x, y, z, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
    ,
    POTION("potion"){

        @Override
        public Config.FeatureFloorTrap getFeatureConfig(Config dimConfig) {
            return dimConfig.FLOOR_TRAP_POTION;
        }

        @Override
        public void buildBlockLootTable(LootTableBuilder loot) {
            loot.addCommonDrop("common", "Redstone", Items.field_151137_ax, 1, 8);
            loot.addSemicommonDrop("semicommon", "Gold Ingot", Items.field_151043_k);
            loot.addPool(new LootPoolBuilder("enchant").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Enchants", Items.field_151122_aG).applyOneRandomEnchant(Enchantments.field_180310_c, Enchantments.field_92091_k, Enchantments.field_185306_r).toLootEntry()).toLootPool());
            loot.addLootTable("external", "Witch Loot", LootTableList.field_186432_n);
            loot.addUncommonDrop("uncommon", "Brewing", Items.field_179556_br, Items.field_151065_br, Items.field_151060_bw, Items.field_151073_bk, Items.field_151064_bs, Items.field_151150_bK, Items.field_151071_bq);
        }

        @Override
        public void triggerTrap(Config dimConfig, TileEntityFloorTrap trapEntity) {
            EnumPotionTrapType type;
            String TAG_POTION_TYPE = "PotionType";
            World world = trapEntity.func_145831_w();
            double x = (double)trapEntity.func_174877_v().func_177958_n() + 0.5;
            double y = (double)trapEntity.func_174877_v().func_177956_o() + 1.1;
            double z = (double)trapEntity.func_174877_v().func_177952_p() + 0.5;
            int resetRange = dimConfig.FLOOR_TRAP_POTION.RESET_TIME_MAX - dimConfig.FLOOR_TRAP_POTION.RESET_TIME_MIN;
            if (resetRange <= 0) {
                resetRange = 1;
            }
            trapEntity.disableTrap(dimConfig.FLOOR_TRAP_POTION.RESET_TIME_MIN + world.field_73012_v.nextInt(resetRange));
            NBTTagCompound typeData = trapEntity.getOrCreateTypeData();
            if (typeData.func_150297_b("PotionType", TrapHelper.NBT_TYPE_STRING)) {
                type = EnumPotionTrapType.fromString(typeData.func_74779_i("PotionType"));
            } else {
                type = dimConfig.FLOOR_TRAP_POTION.POTION_TYPE_LIST.nextItem(world.field_73012_v);
                if (type == null) {
                    type = EnumPotionTrapType.HARM;
                }
                typeData.func_74778_a("PotionType", type.toString());
            }
            ItemStack potionStack = type.getPotion(dimConfig);
            TrapHelper.setPotionColorFromEffects(potionStack);
            EntityPotion potionEntity = new EntityPotion(world, x, y, z, potionStack);
            potionEntity.field_70181_x = 0.33f + 0.04f * world.field_73012_v.nextFloat();
            world.func_72838_d((Entity)potionEntity);
            world.func_184148_a(null, x, y, z, SoundEvents.field_187578_au, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    };

    public static final PropertyEnum<EnumFloorTrapType> PROPERTY;
    public final ResourceLocation LOOT_TABLE_BLOCK;
    public final String NAME;
    public final String DISPLAY_NAME;

    private EnumFloorTrapType(String name) {
        this(name, name.replace("_", " ") + " floor traps");
    }

    private EnumFloorTrapType(String name, String prettyName) {
        this.NAME = name;
        this.DISPLAY_NAME = prettyName;
        this.LOOT_TABLE_BLOCK = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("deadlyworld", "blocks/floor_trap/" + name));
    }

    public abstract Config.FeatureFloorTrap getFeatureConfig(Config var1);

    public abstract void buildBlockLootTable(LootTableBuilder var1);

    public boolean canTypeBePlaced(World world, BlockPos position) {
        return !world.func_180495_p(position.func_177982_a(0, 2, 0)).func_185917_h() && world.func_175623_d(position.func_177982_a(0, 1, 0)) && world.func_180495_p(position.func_177982_a(0, -1, 0)).func_185917_h();
    }

    public abstract void triggerTrap(Config var1, TileEntityFloorTrap var2);

    public WorldGenFloorTrap makeWorldGen() {
        return new WorldGenFloorTrap(this);
    }

    public String toString() {
        return this.NAME;
    }

    public String func_176610_l() {
        return this.NAME;
    }

    @Override
    public int getMetadata() {
        return this.ordinal();
    }

    public static EnumFloorTrapType byMetadata(int meta) {
        if (meta < 0 || meta >= EnumFloorTrapType.values().length) {
            DeadlyWorldMod.log().warn("Attempted to load invalid floortrap type with metadata '{}'", (Object)meta);
            return TNT;
        }
        return EnumFloorTrapType.values()[meta];
    }

    static {
        PROPERTY = PropertyEnum.func_177709_a((String)"type", EnumFloorTrapType.class);
    }
}

