/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.block;

import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.block.BlockDeadlySilverfish;
import java.util.Random;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SilverfishBlockEventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntitySilverfish) {
            EntitySilverfish silverfish = (EntitySilverfish)event.getEntity();
            boolean addedHideAI = false;
            boolean addedSummonAI = false;
            for (EntityAITasks.EntityAITaskEntry entry : silverfish.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
                Class<?> enclosing = entry.field_75733_a.getClass().getEnclosingClass();
                if (enclosing == null || !enclosing.equals(EntitySilverfish.class)) continue;
                silverfish.field_70714_bg.func_85156_a(entry.field_75733_a);
                if (!addedHideAI && entry.field_75733_a instanceof EntityAIWander) {
                    addedHideAI = true;
                    silverfish.field_70714_bg.func_75776_a(entry.field_75731_b, (EntityAIBase)new EntityAIHideInBlock(silverfish));
                } else if (!addedSummonAI) {
                    addedSummonAI = true;
                    silverfish.field_70714_bg.func_75776_a(entry.field_75731_b, (EntityAIBase)new EntityAISummonSilverfish(silverfish));
                }
                if (addedHideAI && addedSummonAI) break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingAttack(LivingAttackEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntitySilverfish && (event.getSource() instanceof EntityDamageSource || event.getSource() == DamageSource.field_76376_m)) {
            EntitySilverfish silverfish = (EntitySilverfish)event.getEntity();
            for (EntityAITasks.EntityAITaskEntry entry : silverfish.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
                if (!(entry.field_75733_a instanceof EntityAISummonSilverfish)) continue;
                ((EntityAISummonSilverfish)entry.field_75733_a).notifyHurt();
                break;
            }
        }
    }

    static class EntityAISummonSilverfish
    extends EntityAIBase {
        private final EntitySilverfish silverfish;
        private int lookForFriends;

        EntityAISummonSilverfish(EntitySilverfish silverfishIn) {
            this.silverfish = silverfishIn;
        }

        void notifyHurt() {
            if (this.lookForFriends == 0) {
                this.lookForFriends = 20;
            }
        }

        public boolean func_75250_a() {
            return this.lookForFriends > 0;
        }

        public void func_75246_d() {
            --this.lookForFriends;
            if (this.lookForFriends <= 0) {
                this.summonSilverfish();
            }
        }

        void summonSilverfish() {
            World world = this.silverfish.field_70170_p;
            Random random = this.silverfish.func_70681_au();
            BlockPos silverfishPos = new BlockPos((Entity)this.silverfish);
            int y = 0;
            while (y <= 5 && y >= -5) {
                int x = 0;
                while (x <= 10 && x >= -10) {
                    int z = 0;
                    while (z <= 10 && z >= -10) {
                        BlockPos pos = silverfishPos.func_177982_a(x, y, z);
                        IBlockState state = world.func_180495_p(pos);
                        if (state.func_177230_c() instanceof BlockDeadlySilverfish || state.func_177230_c() == Blocks.field_150418_aU) {
                            if (ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)this.silverfish)) {
                                world.func_175655_b(pos, true);
                            } else if (state.func_177230_c() instanceof BlockDeadlySilverfish) {
                                world.func_180501_a(pos, ((BlockDeadlySilverfish)state.func_177230_c()).toDisguise(state), 3);
                            } else {
                                world.func_180501_a(pos, ((BlockSilverfish.EnumType)state.func_177229_b((IProperty)BlockSilverfish.field_176378_a)).func_176883_d(), 3);
                            }
                            if (random.nextBoolean()) {
                                return;
                            }
                        }
                        z = (z <= 0 ? 1 : 0) - z;
                    }
                    x = (x <= 0 ? 1 : 0) - x;
                }
                y = (y <= 0 ? 1 : 0) - y;
            }
        }
    }

    static class EntityAIHideInBlock
    extends EntityAIWander {
        private EnumFacing facing;
        private boolean doMerge;

        EntityAIHideInBlock(EntitySilverfish silverfish) {
            super((EntityCreature)silverfish, 1.0, 10);
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (this.field_75457_a.func_70638_az() != null) {
                return false;
            }
            if (!this.field_75457_a.func_70661_as().func_75500_f()) {
                return false;
            }
            Random random = this.field_75457_a.func_70681_au();
            if (ForgeEventFactory.getMobGriefingEvent((World)this.field_75457_a.field_70170_p, (Entity)this.field_75457_a) && random.nextInt(10) == 0) {
                this.facing = EnumFacing.func_176741_a((Random)random);
                BlockPos pos = new BlockPos(this.field_75457_a.field_70165_t, this.field_75457_a.field_70163_u + 0.5, this.field_75457_a.field_70161_v).func_177972_a(this.facing);
                IBlockState state = this.field_75457_a.field_70170_p.func_180495_p(pos);
                if (BlockSilverfish.func_176377_d((IBlockState)state) || ModObjects.getInfestedVersionIfReplaceable(state) != null) {
                    this.doMerge = true;
                    return true;
                }
            }
            this.doMerge = false;
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.doMerge && super.func_75253_b();
        }

        public void func_75249_e() {
            if (!this.doMerge) {
                super.func_75249_e();
            } else {
                boolean success;
                BlockPos pos = new BlockPos(this.field_75457_a.field_70165_t, this.field_75457_a.field_70163_u + 0.5, this.field_75457_a.field_70161_v).func_177972_a(this.facing);
                IBlockState state = this.field_75457_a.field_70170_p.func_180495_p(pos);
                IBlockState infestedState = ModObjects.getInfestedVersion(state);
                if (infestedState != null) {
                    this.field_75457_a.field_70170_p.func_180501_a(pos, infestedState, 3);
                    success = true;
                } else if (BlockSilverfish.func_176377_d((IBlockState)state)) {
                    this.field_75457_a.field_70170_p.func_180501_a(pos, Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.func_176878_a((IBlockState)state)), 3);
                    success = true;
                } else {
                    success = false;
                }
                if (success) {
                    this.field_75457_a.func_70656_aK();
                    this.field_75457_a.func_70106_y();
                }
            }
        }
    }
}

