/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.block;

import fathertoast.deadlyworld.DeadlyWorldMod;
import fathertoast.deadlyworld.block.state.EnumTowerType;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.tileentity.TileEntityTowerDispenser;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public class BlockTowerDispenser
extends BlockContainer {
    public static final String ID = "tower_dispenser";

    public BlockTowerDispenser() {
        super(Material.field_151576_e, MapColor.field_151665_m);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(Config.get().GENERAL.TOWER_DISPENSER_HARDNESS);
        this.func_149752_b(Config.get().GENERAL.TOWER_DISPENSER_RESISTANCE);
        this.setHarvestLevel("pickaxe", Config.get().GENERAL.TOWER_DISPENSER_HARVEST_LEVEL);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumTowerType.PROPERTY, (Comparable)((Object)EnumTowerType.DEFAULT)));
    }

    public void initTileEntity(World world, BlockPos pos, IBlockState state, Config dimConfig, Random random) {
        TileEntity spawnerData = world.func_175625_s(pos);
        if (spawnerData instanceof TileEntityTowerDispenser) {
            ((TileEntityTowerDispenser)spawnerData).initializeTowerTrap((EnumTowerType)((Object)state.func_177229_b(EnumTowerType.PROPERTY)), dimConfig, random);
        } else {
            DeadlyWorldMod.log().error("Failed to fetch tower dispenser tile entity at [{}]!", (Object)pos);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityTowerDispenser();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumTowerType.PROPERTY});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(EnumTowerType.PROPERTY, (Comparable)((Object)EnumTowerType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumTowerType)((Object)state.func_177229_b(EnumTowerType.PROPERTY))).getMetadata();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (EnumTowerType type : EnumTowerType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return 15 + RANDOM.nextInt(15) + RANDOM.nextInt(15);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            this.initTileEntity(world, pos, state, Config.getOrDefault(world), world.field_73012_v);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumTowerType)((Object)state.func_177229_b(EnumTowerType.PROPERTY))).getMetadata();
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess blockAccess, BlockPos pos, IBlockState state, int fortune) {
        if (!(blockAccess instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)blockAccess;
        LootTable loot = world.func_184146_ak().func_186521_a(((EnumTowerType)((Object)state.func_177229_b(EnumTowerType.PROPERTY))).LOOT_TABLE_BLOCK);
        LootContext.Builder lootContext = new LootContext.Builder(world);
        if (this.harvesters.get() != null) {
            lootContext.func_186469_a(((EntityPlayer)this.harvesters.get()).func_184817_da()).func_186470_a((EntityPlayer)this.harvesters.get());
        }
        drops.addAll((Collection)loot.func_186462_a(world.field_73012_v, lootContext.func_186471_a()));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

