/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.block;

import com.mojang.realmsclient.gui.ChatFormatting;
import fathertoast.deadlyworld.block.state.PropertyDisguiseBlock;
import fathertoast.deadlyworld.config.Config;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDeadlySilverfish
extends Block {
    public static final String ID = "infested";
    private static Block builderDisguise;
    private static PropertyDisguiseBlock builderProperty;
    public final Block DISGUISE = builderDisguise;
    public final PropertyDisguiseBlock DISGUISE_PROPERTY = builderProperty;

    public static BlockDeadlySilverfish buildFor(Block block) {
        builderDisguise = block;
        IBlockState state = block.func_176223_P();
        builderProperty = state.func_177227_a().isEmpty() ? null : new PropertyDisguiseBlock(block);
        BlockDeadlySilverfish infestedBlock = new BlockDeadlySilverfish();
        builderDisguise = null;
        builderProperty = null;
        return infestedBlock;
    }

    private BlockDeadlySilverfish() {
        super(Material.field_151571_B, MapColor.field_151665_m);
        IBlockState state = this.DISGUISE.func_176223_P();
        if (this.DISGUISE_PROPERTY != null) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.DISGUISE_PROPERTY, (Comparable)Integer.valueOf(this.DISGUISE.func_176201_c(state))));
        }
        this.func_149711_c(0.0f);
        this.func_149672_a(this.DISGUISE.func_185467_w());
        this.field_149763_I = this.DISGUISE.field_149763_I;
        this.field_149765_K = this.DISGUISE.field_149765_K;
        this.field_149787_q = state.func_185914_p();
        this.field_149786_r = this.DISGUISE.func_149717_k(state);
    }

    protected BlockStateContainer func_180661_e() {
        if (builderProperty == null) {
            return new BlockStateContainer((Block)this, new IProperty[0]);
        }
        BlockDeadlySilverfish.builderProperty.parentBlock = this;
        return new BlockStateContainer((Block)this, new IProperty[]{builderProperty});
    }

    public IBlockState toDisguise(IBlockState infestedState) {
        return this.DISGUISE_PROPERTY == null ? this.DISGUISE.func_176223_P() : this.DISGUISE_PROPERTY.toDisguise(infestedState);
    }

    public IBlockState fromDisguise(IBlockState disguiseState) {
        return this.DISGUISE_PROPERTY == null ? this.func_176223_P() : this.DISGUISE_PROPERTY.fromDisguise(disguiseState);
    }

    public IBlockState func_176203_a(int meta) {
        return this.DISGUISE_PROPERTY == null ? this.func_176223_P() : this.DISGUISE_PROPERTY.setMeta(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.DISGUISE_PROPERTY == null ? 0 : this.DISGUISE_PROPERTY.getMeta(state);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.DISGUISE_PROPERTY == null) {
            items.add((Object)new ItemStack((Block)this, 1, 0));
        } else {
            for (int meta : this.DISGUISE_PROPERTY.func_177700_c()) {
                items.add((Object)new ItemStack((Block)this, 1, meta));
            }
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tileEntity, ItemStack stack) {
        if (this.canSilkHarvest(world, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            this.DISGUISE.func_180657_a(world, player, pos, this.toDisguise(state), tileEntity, stack);
        } else {
            super.func_180657_a(world, player, pos, state, tileEntity, stack);
        }
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            EntitySilverfish silverfish = new EntitySilverfish(world);
            silverfish.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            silverfish.func_180482_a(world.func_175649_E(pos), null);
            world.func_72838_d((Entity)silverfish);
            silverfish.func_70656_aK();
            if (silverfish.func_70681_au().nextFloat() < Config.getOrDefault((World)world).TERRAIN.SILVERFISH_AGGRO_CHANCE) {
                if (silverfish.func_70638_az() == null) {
                    double range;
                    try {
                        range = silverfish.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
                    }
                    catch (Exception ex) {
                        range = 16.0;
                    }
                    List nearbyPlayers = world.func_72872_a(EntityPlayer.class, silverfish.func_174813_aQ().func_72321_a(range, range / 2.0, range));
                    for (EntityPlayer player : nearbyPlayers) {
                        if (player == null || !silverfish.func_70685_l((Entity)player)) continue;
                        silverfish.func_70624_b((EntityLivingBase)player);
                        break;
                    }
                }
                if (silverfish.func_70638_az() != null) {
                    silverfish.func_70097_a(DamageSource.field_76376_m, 0.0f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(ChatFormatting.RED + new TextComponentTranslation("tile.deadlyworld.deadly_silverfish.tooltip", new Object[0]).func_150261_e());
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        this.DISGUISE.func_180634_a(world, pos, state, entity);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        this.DISGUISE.func_180658_a(world, pos, entity, fallDistance);
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.DISGUISE.func_180659_g(this.toDisguise(state), world, pos);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return this.fromDisguise(this.DISGUISE.func_185499_a(this.toDisguise(state), rotation));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return this.fromDisguise(this.DISGUISE.func_185471_a(this.toDisguise(state), mirror));
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public String func_149732_F() {
        return this.DISGUISE.func_149732_F();
    }

    public String func_149739_a() {
        return this.DISGUISE.func_149739_a();
    }

    public IBlockState getStateAtViewpoint(IBlockState state, IBlockAccess world, BlockPos pos, Vec3d viewpoint) {
        return this.fromDisguise(this.DISGUISE.getStateAtViewpoint(this.toDisguise(state), world, pos, viewpoint));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.fromDisguise(this.DISGUISE.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand));
    }
}

