/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld;

import fathertoast.deadlyworld.DeadlyWorldMod;
import fathertoast.deadlyworld.block.BlockDeadlySilverfish;
import fathertoast.deadlyworld.block.BlockDeadlySpawner;
import fathertoast.deadlyworld.block.BlockFloorTrap;
import fathertoast.deadlyworld.block.BlockTowerDispenser;
import fathertoast.deadlyworld.block.state.EnumFloorTrapType;
import fathertoast.deadlyworld.block.state.EnumSpawnerType;
import fathertoast.deadlyworld.block.state.EnumTowerType;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.item.ItemBlockDeadlySilverfish;
import fathertoast.deadlyworld.item.ItemDeadlyEvent;
import fathertoast.deadlyworld.item.ItemFeatureTester;
import fathertoast.deadlyworld.tileentity.TileEntityDeadlySpawner;
import fathertoast.deadlyworld.tileentity.TileEntityFloorTrap;
import fathertoast.deadlyworld.tileentity.TileEntityTowerDispenser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModObjects {
    public static final String BLOCK_LOOT_TABLE_PATH = "blocks/";
    public static final String TOOL_NAME_PICKAXE = "pickaxe";
    public static final BlockDeadlySpawner DEADLY_SPAWNER = ModObjects.addInfo("deadly_spawner", CreativeTabs.field_78031_c, new BlockDeadlySpawner());
    public static final BlockFloorTrap FLOOR_TRAP = ModObjects.addInfo("floor_trap", CreativeTabs.field_78031_c, new BlockFloorTrap());
    public static final BlockTowerDispenser TOWER_DISPENSER = ModObjects.addInfo("tower_dispenser", CreativeTabs.field_78031_c, new BlockTowerDispenser());
    public static BlockDeadlySilverfish INFESTED_COBBLE;
    public static final ItemDeadlyEvent EVENT_ITEM;
    public static final ItemFeatureTester FEATURE_TESTER;
    private static final List<BlockDeadlySilverfish> SILVERFISH_ORDERED;
    private static final Map<Block, BlockDeadlySilverfish> SILVERFISH_LOOKUP;

    public static BlockDeadlySilverfish getInfestedVersion(Block block) {
        return SILVERFISH_LOOKUP.get(block);
    }

    public static IBlockState infest(IBlockState state) {
        IBlockState infestedState = ModObjects.getInfestedVersion(state);
        return infestedState == null ? state : infestedState;
    }

    public static IBlockState getInfestedVersion(IBlockState state) {
        BlockDeadlySilverfish infested = ModObjects.getInfestedVersion(state.func_177230_c());
        if (infested != null) {
            return infested.fromDisguise(state);
        }
        return null;
    }

    public static IBlockState getInfestedVersionIfReplaceable(IBlockState state) {
        if (Config.get().GENERAL.SILVERFISH_REPLACEABLE.matches(state)) {
            return ModObjects.getInfestedVersion(state);
        }
        return null;
    }

    public static List<BlockDeadlySilverfish> getSilverfishBlocksOrdered() {
        return SILVERFISH_ORDERED;
    }

    private static <T extends Block> T addInfo(String name, CreativeTabs tab, T block) {
        ((Block)block.setRegistryName("deadlyworld", name)).func_149663_c("deadlyworld." + name).func_149647_a(tab);
        return block;
    }

    private static void buildSilverfishBlock(Block block) {
        if (SILVERFISH_LOOKUP.containsKey(block)) {
            return;
        }
        ResourceLocation disguiseRegName = block.getRegistryName();
        if (disguiseRegName == null) {
            DeadlyWorldMod.log().error("Failed to find registry entry for block '{}'", (Object)block);
            return;
        }
        BlockDeadlySilverfish infestedBlock = BlockDeadlySilverfish.buildFor(block);
        ResourceLocation infestedRegName = new ResourceLocation("deadlyworld", "infested_" + disguiseRegName.func_110624_b() + "_" + disguiseRegName.func_110623_a());
        ((Block)infestedBlock.setRegistryName(infestedRegName)).func_149663_c(block.func_149739_a().substring("tile.".length())).func_149647_a(CreativeTabs.field_78031_c);
        SILVERFISH_ORDERED.add(infestedBlock);
        SILVERFISH_LOOKUP.put(block, infestedBlock);
    }

    private static <T extends Item> T addInfo(String name, CreativeTabs tab, T item) {
        ((Item)item.setRegistryName("deadlyworld", name)).func_77655_b("deadlyworld." + name).func_77637_a(tab);
        return item;
    }

    public static void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityDeadlySpawner.class, (ResourceLocation)new ResourceLocation("deadlyworld", "deadly_spawner"));
        GameRegistry.registerTileEntity(TileEntityFloorTrap.class, (ResourceLocation)new ResourceLocation("deadlyworld", "floor_trap"));
        GameRegistry.registerTileEntity(TileEntityTowerDispenser.class, (ResourceLocation)new ResourceLocation("deadlyworld", "tower_dispenser"));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{DEADLY_SPAWNER, FLOOR_TRAP, TOWER_DISPENSER});
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerBlocksLate(RegistryEvent.Register<Block> event) {
        SILVERFISH_ORDERED.clear();
        SILVERFISH_LOOKUP.clear();
        ModObjects.buildSilverfishBlock(Blocks.field_150347_e);
        if (Config.get().GENERAL.SILVERFISH_AUTOGEN) {
            List<Block> disguiseBlocks = Config.get().GENERAL.SILVERFISH_REPLACEABLE.getSortedBlocks();
            for (Block block : disguiseBlocks) {
                ModObjects.buildSilverfishBlock(block);
            }
        }
        INFESTED_COBBLE = ModObjects.getInfestedVersion(Blocks.field_150347_e);
        event.getRegistry().registerAll((IForgeRegistryEntry[])SILVERFISH_ORDERED.toArray(new BlockDeadlySilverfish[0]));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)EVENT_ITEM);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{this.itemForBlock((Block)DEADLY_SPAWNER, itemStack -> EnumSpawnerType.byMetadata(itemStack.func_77960_j()).func_176610_l()), this.itemForBlock((Block)FLOOR_TRAP, itemStack -> EnumFloorTrapType.byMetadata(itemStack.func_77960_j()).func_176610_l()), this.itemForBlock((Block)TOWER_DISPENSER, itemStack -> EnumTowerType.byMetadata(itemStack.func_77960_j()).func_176610_l())});
        if (Config.get().GENERAL.FEATURE_TESTER) {
            event.getRegistry().register((IForgeRegistryEntry)FEATURE_TESTER);
        }
        for (BlockDeadlySilverfish infestedBlock : SILVERFISH_ORDERED) {
            event.getRegistry().register(new ItemBlockDeadlySilverfish(infestedBlock).setRegistryName(infestedBlock.getRegistryName()));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void registerModels(ModelRegistryEvent event) {
        DeadlyWorldMod.sidedProxy.registerModels();
    }

    private Item itemForBlock(Block block) {
        return (Item)new ItemBlock(block).setRegistryName(block.getRegistryName());
    }

    private Item itemForBlock(Block block, ItemMultiTexture.Mapper mapper) {
        return (Item)new ItemMultiTexture(block, block, mapper).setRegistryName(block.getRegistryName());
    }

    static {
        EVENT_ITEM = ModObjects.addInfo("event_item", CreativeTabs.field_78026_f, new ItemDeadlyEvent());
        FEATURE_TESTER = ModObjects.addInfo("feature_tester", CreativeTabs.field_78026_f, new ItemFeatureTester());
        SILVERFISH_ORDERED = new ArrayList<BlockDeadlySilverfish>();
        SILVERFISH_LOOKUP = new HashMap<Block, BlockDeadlySilverfish>();
    }
}

