/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld;

import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.SidedModProxy;
import fathertoast.deadlyworld.block.SilverfishBlockEventHandler;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.featuregen.FeatureGenerator;
import fathertoast.deadlyworld.item.DeadlyEventHandler;
import fathertoast.deadlyworld.loot.LootTableHelper;
import fathertoast.deadlyworld.oregen.OreGenerator;
import java.io.File;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="deadlyworld", name="Deadly World", version="1.1.1_for_mc1.12.2", acceptedMinecraftVersions="[1.12.2]")
public class DeadlyWorldMod {
    public static final String MOD_ID = "deadlyworld";
    public static final String NAME = "Deadly World";
    public static final String VERSION = "1.1.1_for_mc1.12.2";
    @SidedProxy(modId="deadlyworld", clientSide="fathertoast.deadlyworld.client.ClientProxy", serverSide="fathertoast.deadlyworld.server.ServerProxy")
    public static SidedModProxy sidedProxy;
    public static final String LANG_KEY = "deadlyworld.";
    private File configDirectory;
    private static Logger logger;

    public static Logger log() {
        return logger;
    }

    public static void mark(World world, BlockPos pos) {
        DeadlyWorldMod.mark(world, pos, Blocks.field_150359_w.func_176223_P());
    }

    public static void mark(World world, BlockPos pos, IBlockState block) {
        if (Config.get().GENERAL.DEBUG) {
            for (int y = pos.func_177956_o() + 1; y < world.func_72800_K(); ++y) {
                world.func_180501_a(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()), block, 18);
            }
            DeadlyWorldMod.log().info("Marked: {}", (Object)pos);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configDirectory = event.getModConfigurationDirectory();
        logger = event.getModLog();
        Config.load(logger, "Deadly_World", this.configDirectory);
        if (Config.get().GENERAL.DEBUG) {
            DeadlyWorldMod.log().warn("Loaded in debug mode!");
        }
        MinecraftForge.EVENT_BUS.register((Object)new ModObjects());
        sidedProxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModObjects.registerTileEntities();
        MinecraftForge.EVENT_BUS.register((Object)new DeadlyEventHandler());
        FeatureGenerator featureGenerator = new FeatureGenerator();
        MinecraftForge.EVENT_BUS.register((Object)featureGenerator);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)featureGenerator);
        OreGenerator oreGenerator = new OreGenerator();
        MinecraftForge.EVENT_BUS.register((Object)oreGenerator);
        MinecraftForge.ORE_GEN_BUS.register((Object)oreGenerator);
        sidedProxy.init();
        if (!ModObjects.getSilverfishBlocksOrdered().isEmpty()) {
            MinecraftForge.EVENT_BUS.register((Object)new SilverfishBlockEventHandler());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        boolean isInDev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        if (isInDev) {
            LootTableHelper.generateBaseLootTables(this.configDirectory);
        }
        this.configDirectory = null;
    }
}

