/*
 * Decompiled with CFR 0.152.
 */
package meldexun.matrixutil;

import meldexun.matrixutil.MathUtil;

public class Quaternion {
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion() {
    }

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Quaternion quaternion = (Quaternion)obj;
            return Float.compare(quaternion.x, this.x) == 0 && Float.compare(quaternion.y, this.y) == 0 && Float.compare(quaternion.z, this.z) == 0 && Float.compare(quaternion.w, this.w) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        i = 31 * i + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        i = 31 * i + (this.z != 0.0f ? Float.floatToIntBits(this.z) : 0);
        return 31 * i + (this.w != 0.0f ? Float.floatToIntBits(this.w) : 0);
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("Quaternion: ");
        stringbuilder.append(this.x);
        stringbuilder.append(" ");
        stringbuilder.append(this.y);
        stringbuilder.append(" ");
        stringbuilder.append(this.z);
        stringbuilder.append(" ");
        stringbuilder.append(this.w);
        return stringbuilder.toString();
    }

    public static Quaternion createIdentity() {
        return new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static Quaternion createRotate(float radian, float x, float y, float z) {
        float q = (float)MathUtil.sin(radian *= 0.5f);
        return new Quaternion(x * q, y * q, z * q, (float)MathUtil.cos(radian));
    }

    public static Quaternion createRotateX(float radian) {
        return new Quaternion((float)MathUtil.sin(radian *= 0.5f), 0.0f, 0.0f, (float)MathUtil.cos(radian));
    }

    public static Quaternion createRotateY(float radian) {
        return new Quaternion(0.0f, (float)MathUtil.sin(radian *= 0.5f), 0.0f, (float)MathUtil.cos(radian));
    }

    public static Quaternion createRotateZ(float radian) {
        return new Quaternion(0.0f, 0.0f, (float)MathUtil.sin(radian *= 0.5f), (float)MathUtil.cos(radian));
    }

    public void setIndentity() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public void multiply(Quaternion quaternion) {
        this.multiply(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public void multiply(float x, float y, float z, float w) {
        float x0 = this.x;
        float y0 = this.y;
        float z0 = this.z;
        float w0 = this.w;
        this.x = x0 * w + y0 * z - z0 * y + w0 * x;
        this.y = -x0 * z + y0 * w + z0 * x + w0 * y;
        this.z = x0 * y - y0 * x + z0 * w + w0 * z;
        this.w = -x0 * x - y0 * y - z0 * z + w0 * w;
    }

    public void rotate(float radian, float x, float y, float z) {
        float q = (float)MathUtil.sin(radian *= 0.5f);
        this.multiply(x * q, y * q, z * q, (float)MathUtil.cos(radian));
    }

    public void rotateX(float radian) {
        float x = (float)MathUtil.sin(radian *= 0.5f);
        float w = (float)MathUtil.cos(radian);
        float x0 = this.x;
        float y0 = this.y;
        float z0 = this.z;
        float w0 = this.w;
        this.x = x0 * w + w0 * x;
        this.y = y0 * w + z0 * x;
        this.z = -y0 * x + z0 * w;
        this.w = -x0 * x + w0 * w;
    }

    public void rotateY(float radian) {
        float y = (float)MathUtil.sin(radian *= 0.5f);
        float w = (float)MathUtil.cos(radian);
        float x0 = this.x;
        float y0 = this.y;
        float z0 = this.z;
        float w0 = this.w;
        this.x = x0 * w - z0 * y;
        this.y = y0 * w + w0 * y;
        this.z = x0 * y + z0 * w;
        this.w = -y0 * y + w0 * w;
    }

    public void rotateZ(float radian) {
        float z = (float)MathUtil.sin(radian *= 0.5f);
        float w = (float)MathUtil.cos(radian);
        float x0 = this.x;
        float y0 = this.y;
        float z0 = this.z;
        float w0 = this.w;
        this.x = x0 * w + y0 * z;
        this.y = -x0 * z + y0 * w;
        this.z = z0 * w + w0 * z;
        this.w = -z0 * z + w0 * w;
    }
}

