/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching.matcher;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreDictionary;
import wanion.lib.common.matching.AbstractMatching;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.MatcherEnum;

public final class OreDictMatcher
extends AbstractMatcher<OreDictMatcher> {
    private String oreName;
    private int[] ores;
    private int actualOre;

    public OreDictMatcher(@Nonnull AbstractMatching<?> matching) {
        this(matching, null);
    }

    public OreDictMatcher(@Nonnull AbstractMatching<?> matching, String oreName) {
        super(matching);
        this.oreName = oreName;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeNBT() {
        NBTTagCompound matchingNbt = super.writeNBT();
        matchingNbt.func_74778_a("oreName", this.oreName != null ? this.oreName : "");
        return matchingNbt;
    }

    @Override
    public void readNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        this.oreName = nbtTagCompound.func_74779_i("oreName");
    }

    @Override
    @Nonnull
    public MatcherEnum getMatcherEnum() {
        return MatcherEnum.ORE_DICT;
    }

    @Override
    @Nonnull
    public AbstractMatcher<?> validate() {
        ItemStack matchingStack = this.getStack();
        if (!matchingStack.func_190926_b() && this.ores == null) {
            this.ores = OreDictionary.getOreIDs((ItemStack)matchingStack);
        }
        if (this.ores == null) {
            return this.matching.getDefaultMatcher();
        }
        if ((this.oreName == null || this.oreName.isEmpty()) && this.ores.length > 0) {
            this.actualOre = 0;
            this.oreName = OreDictionary.getOreName((int)this.getOre());
        }
        if (this.ores != null && this.oreName != null && !this.oreName.isEmpty() && this.actualOre < this.ores.length && OreDictionary.getOres((String)this.oreName).stream().anyMatch(stack -> OreDictionary.itemMatches((ItemStack)stack, (ItemStack)matchingStack, (boolean)false))) {
            for (int x = 0; x < this.ores.length; ++x) {
                if (!OreDictionary.getOreName((int)this.ores[x]).equals(this.oreName)) continue;
                this.actualOre = x;
                return this;
            }
        }
        return this.matching.getDefaultMatcher();
    }

    @Override
    public boolean canMoveOn() {
        if (++this.actualOre >= this.ores.length) {
            return true;
        }
        this.oreName = OreDictionary.getOreName((int)this.ores[this.actualOre]);
        return false;
    }

    @Override
    public boolean matches(@Nonnull ItemStack otherItemStack) {
        int[] ores = OreDictionary.getOreIDs((ItemStack)otherItemStack);
        return ores.length != 0 && this.matches(ores);
    }

    @Override
    @Nonnull
    public String getDescription() {
        return super.getDescription() + " " + TextFormatting.GOLD + this.oreName;
    }

    public int getOre() {
        return this.ores[this.actualOre];
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OreDictMatcher) {
            OreDictMatcher oreDictMatcher = (OreDictMatcher)obj;
            if (!this.oreName.equals(oreDictMatcher.oreName)) {
                return false;
            }
            if (this.actualOre != oreDictMatcher.actualOre || this.ores.length != oreDictMatcher.ores.length) {
                return false;
            }
            for (int i = 0; i < this.ores.length; ++i) {
                if (this.ores[i] == oreDictMatcher.ores[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matches(int[] ores) {
        int actualOre = this.ores[this.actualOre];
        for (int ore : ores) {
            if (ore != actualOre) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public OreDictMatcher copy() {
        OreDictMatcher nOreDictMatcher = new OreDictMatcher(this.matching);
        nOreDictMatcher.readNBT(this.writeNBT());
        return nOreDictMatcher;
    }
}

