/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import wanion.lib.common.matching.AbstractMatching;
import wanion.lib.common.matching.matcher.MatcherEnum;

public class Matching
extends AbstractMatching<Matching> {
    protected final boolean shouldUseNbt;

    public Matching(@Nonnull List<ItemStack> itemStacks, int number) {
        this(itemStacks, number, false);
    }

    public Matching(@Nonnull List<ItemStack> itemStacks, int number, boolean shouldUseNbt) {
        this(itemStacks, number, shouldUseNbt, null);
    }

    public Matching(@Nonnull List<ItemStack> itemStacks, int number, boolean shouldUseNbt, NBTTagCompound tagToRead) {
        this(() -> (ItemStack)itemStacks.get(number), number, shouldUseNbt, tagToRead);
    }

    public Matching(@Nonnull Supplier<ItemStack> stackSupplier, int number, boolean shouldUseNbt, NBTTagCompound tagToRead) {
        super(stackSupplier, number, tagToRead);
        this.shouldUseNbt = shouldUseNbt;
    }

    public final boolean shouldUseNbt() {
        return this.shouldUseNbt;
    }

    @Override
    public void nextMatcher() {
        ItemStack stack = this.getStack();
        MatcherEnum matcherEnum = this.matcher.getMatcherEnum();
        do {
            matcherEnum = matcherEnum.getNextMatcherEnum(this.matcher);
        } while ((!this.shouldUseNbt && matcherEnum == MatcherEnum.NBT || !matcherEnum.accepts(stack)) && matcherEnum != MatcherEnum.ITEM_STACK);
        this.matcher = matcherEnum.getMatcher(this).validate();
    }

    @Override
    @Nonnull
    public Matching copy() {
        return new Matching(this.stackSupplier, this.number, this.shouldUseNbt, this.writeNBT());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Matching) {
            Matching matching = (Matching)obj;
            if (matching.number == this.number) {
                return this.matcher.equals(matching.matcher);
            }
            return false;
        }
        return false;
    }
}

