/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.lumen.common.init;

import java.util.function.Function;
import ladysnake.lumen.client.renders.entities.RenderCompanionOrb;
import ladysnake.lumen.client.renders.entities.RenderCompanionOrbAnimated;
import ladysnake.lumen.client.renders.entities.RenderEmber;
import ladysnake.lumen.client.renders.entities.RenderFaerie;
import ladysnake.lumen.client.renders.entities.RenderFirefly;
import ladysnake.lumen.client.renders.entities.RenderLightningBug;
import ladysnake.lumen.client.renders.entities.RenderPsiFirefly;
import ladysnake.lumen.client.renders.entities.RenderRadFlame;
import ladysnake.lumen.client.renders.entities.RenderWillOWisp;
import ladysnake.lumen.common.config.LumenConfig;
import ladysnake.lumen.common.entities.EntityCompanionOrb;
import ladysnake.lumen.common.entities.EntityCompanionOrbAnimated;
import ladysnake.lumen.common.entities.EntityEmber;
import ladysnake.lumen.common.entities.EntityFaerie;
import ladysnake.lumen.common.entities.EntityFirefly;
import ladysnake.lumen.common.entities.EntityLightningBug;
import ladysnake.lumen.common.entities.EntityPsiFirefly;
import ladysnake.lumen.common.entities.EntityRadFlame;
import ladysnake.lumen.common.entities.EntityWillOWisp;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="lumen")
public class ModEntities {
    private static int id = 0;

    @SubscribeEvent
    public static void register(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry reg = event.getRegistry();
        reg.register((IForgeRegistryEntry)ModEntities.createEntry(EntityFirefly::new, "firefly", 64, true).spawn(EnumCreatureType.AMBIENT, 50, 0, LumenConfig.spawnAmountFireFlies, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WET)).spawn(EnumCreatureType.AMBIENT, 50, 0, LumenConfig.spawnAmountFireFlies, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST)).build());
        reg.register((IForgeRegistryEntry)ModEntities.createEntry(EntityPsiFirefly::new, "psi_firefly", 64, true).spawn(EnumCreatureType.CREATURE, 50, 0, LumenConfig.spawnAmountPsiFireflies, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL)).build());
        reg.register((IForgeRegistryEntry)ModEntities.createEntry(EntityLightningBug::new, "lightning_bug", 64, true).spawn(EnumCreatureType.AMBIENT, 50, 0, LumenConfig.spawnAmountLightingBugs, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WET)).spawn(EnumCreatureType.AMBIENT, 50, 0, LumenConfig.spawnAmountLightingBugs, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST)).build());
        reg.register((IForgeRegistryEntry)ModEntities.createEntry(EntityEmber::new, "ember", 64, true).spawn(EnumCreatureType.AMBIENT, 50, 0, LumenConfig.spawnAmountEmbers, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER)).build());
        reg.register((IForgeRegistryEntry)ModEntities.createEntry(EntityCompanionOrb::new, "companion_orb", 64, true).build());
        reg.register((IForgeRegistryEntry)ModEntities.createEntry(EntityCompanionOrbAnimated::new, "companion_orb_a", 64, true).build());
        reg.register((IForgeRegistryEntry)ModEntities.createEntry(EntityWillOWisp::new, "will_o_wisp", 64, true).spawn(EnumCreatureType.CREATURE, 50, 0, LumenConfig.spawnAmountWilloWisps, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)).spawn(EnumCreatureType.CREATURE, 50, 0, LumenConfig.spawnAmountWilloWisps, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)).spawn(EnumCreatureType.CREATURE, 50, 0, LumenConfig.spawnAmountWilloWisps, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DEAD)).build());
        reg.register((IForgeRegistryEntry)ModEntities.createEntry(EntityFaerie::new, "faerie", 64, true).spawn(EnumCreatureType.CREATURE, 50, 0, LumenConfig.spawnAmountFaeries, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DENSE)).spawn(EnumCreatureType.CREATURE, 50, 0, LumenConfig.spawnAmountFaeries, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL)).build());
        reg.register((IForgeRegistryEntry)ModEntities.createEntry(EntityRadFlame::new, "rad_flame", 64, true).build());
    }

    private static EntityEntryBuilder<Entity> createEntry(Function<World, Entity> entityFactory, String name, int trackingRange, boolean sendsVelocityUpdates) {
        return EntityEntryBuilder.create().entity(entityFactory.apply(null).getClass()).factory(entityFactory).id(new ResourceLocation("lumen", name), id++).name(name).tracker(trackingRange, 1, sendsVelocityUpdates);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityFirefly.class, RenderFirefly::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPsiFirefly.class, RenderPsiFirefly::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningBug.class, RenderLightningBug::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityEmber.class, RenderEmber::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCompanionOrb.class, RenderCompanionOrb::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCompanionOrbAnimated.class, RenderCompanionOrbAnimated::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityWillOWisp.class, RenderWillOWisp::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFaerie.class, RenderFaerie::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityRadFlame.class, RenderRadFlame::new);
    }

    public static enum Companion {
        SOLAR_ORB("solar_orb", 243, 126, 74, 8, false),
        THUNDERBALL("thunderball", 204, 234, 255, 8, false),
        SPLINTER("splinter", 220, 220, 220, 8, true);

        private String name;
        private int lightingR;
        private int lightingG;
        private int lightingB;
        private int lightingRadius;
        private boolean isAnimated;

        private Companion(String name, int lightingR, int lightingG, int lightingB, int lightingRadius, boolean isAnimated) {
            this.name = name;
            this.lightingR = lightingR;
            this.lightingG = lightingG;
            this.lightingB = lightingB;
            this.lightingRadius = lightingRadius;
            this.isAnimated = isAnimated;
        }

        public String getName() {
            return this.name;
        }

        public int getLightingR() {
            return this.lightingR;
        }

        public int getLightingG() {
            return this.lightingG;
        }

        public int getLightingB() {
            return this.lightingB;
        }

        public int getLightingRadius() {
            return this.lightingRadius;
        }

        public boolean isAnimated() {
            return this.isAnimated;
        }
    }
}

