/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.lumen.common.entities;

import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import javax.annotation.Nonnull;
import ladysnake.lumen.common.config.LumenConfig;
import ladysnake.lumen.common.entities.AbstractLightOrb;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity", modid="hammercore")
public class EntityWillOWisp
extends AbstractLightOrb
implements IGlowingEntity {
    private double groundLevel;
    private double xTarget;
    private double yTarget;
    private double zTarget;
    private int targetChangeCooldown = 0;

    public EntityWillOWisp(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityWillOWisp(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    @Override
    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_70601_bi() {
        return LumenConfig.spawnWillOWisps && !this.field_70170_p.func_72935_r();
    }

    public boolean func_180431_b(@Nonnull DamageSource source) {
        return !source.func_76363_c();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.targetChangeCooldown -= this.func_174791_d().func_186679_c(this.field_70142_S, this.field_70137_T, this.field_70136_U) < 0.0125 ? 10 : 1;
            if (this.xTarget == 0.0 && this.yTarget == 0.0 && this.zTarget == 0.0 || this.func_180425_c().func_177954_c(this.xTarget, this.yTarget, this.zTarget) < 9.0 || this.targetChangeCooldown <= 0) {
                this.selectBlockTarget();
            }
            Vec3d targetVector = new Vec3d(this.xTarget - this.field_70165_t, this.yTarget - this.field_70163_u, this.zTarget - this.field_70161_v);
            double length = targetVector.func_72433_c();
            targetVector = targetVector.func_186678_a(0.1 / length);
            this.field_70159_w = 0.9 * this.field_70159_w + 0.1 * targetVector.field_72450_a;
            this.field_70181_x = 0.9 * this.field_70181_x + 0.1 * targetVector.field_72448_b;
            this.field_70179_y = 0.9 * this.field_70179_y + 0.1 * targetVector.field_72449_c;
            if (this.func_180425_c() != this.getTargetPosition()) {
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
    }

    private void selectBlockTarget() {
        this.groundLevel = 0.0;
        for (int i = 0; i < 20; ++i) {
            if (!this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - (double)i, this.field_70161_v)).func_177230_c().func_181623_g()) {
                this.groundLevel = this.field_70163_u - (double)i;
            }
            if (this.groundLevel != 0.0) break;
        }
        this.xTarget = this.field_70165_t + this.field_70146_Z.nextGaussian() * 10.0;
        this.yTarget = Math.min(Math.max(this.field_70163_u + this.field_70146_Z.nextGaussian() * 10.0, this.groundLevel), this.groundLevel + 8.0);
        this.zTarget = this.field_70161_v + this.field_70146_Z.nextGaussian() * 10.0;
        while (!this.field_70170_p.func_180495_p(new BlockPos(this.xTarget, this.yTarget, this.zTarget)).func_177230_c().func_181623_g()) {
            this.yTarget += 1.0;
        }
        this.targetChangeCooldown = this.field_70146_Z.nextInt() % 100;
    }

    public BlockPos getTargetPosition() {
        return new BlockPos(this.xTarget, this.yTarget + 0.5, this.zTarget);
    }

    private void detectGroundLevel() {
        for (int i = 0; i < 20; ++i) {
            double groundTmp = 0.0;
            if (!this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - (double)i, this.field_70161_v)).func_177230_c().func_181623_g()) {
                groundTmp = this.field_70163_u - (double)i;
            }
            if (groundTmp == 0.0) continue;
            this.groundLevel = groundTmp;
            break;
        }
    }

    public ColoredLight produceColoredLight(float partialTicks) {
        return ColoredLight.builder().pos((Entity)this).radius(10.0f).color(0.2f, 0.78f, 0.9f, 1.0f).build();
    }
}

