/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.lumen.common.entities;

import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import ladysnake.lumen.common.entities.AbstractLightOrb;
import ladysnake.lumen.common.init.ModEntities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity", modid="hammercore")
public class EntityCompanionOrb
extends AbstractLightOrb
implements IGlowingEntity {
    private UUID ownerUUID;
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityCompanionOrb.class, (DataSerializer)DataSerializers.field_187192_b);
    private double xTarget;
    private double yTarget;
    private double zTarget;
    private int targetChangeCooldown = 0;

    public EntityCompanionOrb(World world) {
        super(world);
    }

    public EntityCompanionOrb(World world, double x, double y, double z, UUID ownerUUID, ModEntities.Companion type) {
        this(world);
        this.func_70107_b(x, y, z);
        this.ownerUUID = ownerUUID;
        this.func_184212_Q().func_187227_b(TYPE, (Object)type.ordinal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TYPE, (Object)0);
    }

    public EntityPlayer getOwner() {
        try {
            return this.ownerUUID == null ? null : this.field_70170_p.func_152378_a(this.ownerUUID);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public ResourceLocation getEntityTexture() {
        return new ResourceLocation("lumen", "textures/entities/" + ModEntities.Companion.values()[(Integer)this.field_70180_af.func_187225_a(TYPE)].getName() + ".png");
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.ownerUUID = compound.func_186857_a("ownerUUID");
        this.func_184212_Q().func_187227_b(TYPE, (Object)compound.func_74762_e("type"));
    }

    @Nonnull
    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        super.func_189511_e(compound);
        if (this.ownerUUID != null) {
            compound.func_186854_a("ownerUUID", this.ownerUUID);
        }
        compound.func_74768_a("type", ((Integer)this.func_184212_Q().func_187225_a(TYPE)).intValue());
        return compound;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_180431_b(@Nonnull DamageSource source) {
        return this.getOwner() != null;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && this.getOwner() != null) {
            if (this.field_70165_t > this.getOwner().field_70165_t + 20.0 || this.field_70165_t < this.getOwner().field_70165_t - 20.0 || this.field_70163_u > this.getOwner().field_70163_u + 20.0 || this.field_70163_u < this.getOwner().field_70163_u - 20.0 || this.field_70161_v > this.getOwner().field_70161_v + 20.0 || this.field_70161_v < this.getOwner().field_70161_v - 20.0) {
                this.func_70107_b(this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v);
            }
            this.targetChangeCooldown -= this.func_174791_d().func_186679_c(this.field_70142_S, this.field_70137_T, this.field_70136_U) < 0.0125 ? 10 : 1;
            if (this.xTarget == 0.0 && this.yTarget == 0.0 && this.zTarget == 0.0 || this.func_180425_c().func_177954_c(this.xTarget, this.yTarget, this.zTarget) < 9.0 || this.targetChangeCooldown <= 0) {
                this.selectBlockTarget();
                this.verifyIfOnlyCompanion();
            }
            Vec3d targetVector = new Vec3d(this.xTarget - this.field_70165_t, this.yTarget - this.field_70163_u, this.zTarget - this.field_70161_v);
            double length = targetVector.func_72433_c();
            targetVector = targetVector.func_186678_a(0.1 / length);
            this.field_70159_w = 0.9 * this.field_70159_w + 0.1 * targetVector.field_72450_a;
            this.field_70181_x = 0.9 * this.field_70181_x + 0.1 * targetVector.field_72448_b;
            this.field_70179_y = 0.9 * this.field_70179_y + 0.1 * targetVector.field_72449_c;
            double speedModifier = Math.max(this.getOwner().func_174791_d().func_178788_d(this.func_174791_d()).func_72433_c() - 2.0, 0.0) * 10.0;
            if (this.func_180425_c() != this.getTargetPosition()) {
                this.func_70091_d(MoverType.SELF, this.field_70159_w * speedModifier, this.field_70181_x * speedModifier, this.field_70179_y * speedModifier);
            }
        }
    }

    private void selectBlockTarget() {
        this.xTarget = this.getOwner().field_70165_t + this.field_70146_Z.nextGaussian();
        this.yTarget = this.getOwner().field_70163_u + this.field_70146_Z.nextGaussian() + 2.0;
        this.zTarget = this.getOwner().field_70161_v + this.field_70146_Z.nextGaussian();
        this.targetChangeCooldown = this.field_70146_Z.nextInt() % 100;
    }

    public BlockPos getTargetPosition() {
        return new BlockPos(this.xTarget, this.yTarget + 0.5, this.zTarget);
    }

    public void verifyIfOnlyCompanion() {
        List companions = this.field_70170_p.func_175644_a(EntityCompanionOrb.class, entity -> ((EntityCompanionOrb)((Object)entity)).getOwner() == this.getOwner());
        if (companions.size() > 1) {
            this.func_70106_y();
        }
    }

    public ColoredLight produceColoredLight(float partialTicks) {
        ModEntities.Companion type = ModEntities.Companion.values()[(Integer)this.func_184212_Q().func_187225_a(TYPE)];
        return ColoredLight.builder().pos((Entity)this).radius((float)type.getLightingRadius()).color((float)type.getLightingR(), (float)type.getLightingG(), (float)type.getLightingB(), 1.0f).build();
    }
}

