/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.IShape;
import java.util.Collection;

public interface BlockBrush {
    public static final boolean FILL_AIR_DEFAULT = true;
    public static final boolean REPLACE_SOLID_DEFAULT = true;

    public boolean stroke(WorldEditor var1, Coord var2, boolean var3, boolean var4);

    default public boolean stroke(WorldEditor editor, Coord pos) {
        return this.stroke(editor, pos, true, true);
    }

    default public IShape fill(WorldEditor editor, IShape shape) {
        return this.fill(editor, shape, true, true);
    }

    default public IShape fill(WorldEditor editor, IShape shape, boolean fillAir, boolean replaceSolid) {
        return shape.fill(editor, this, fillAir, replaceSolid);
    }

    default public void fill(WorldEditor editor, Collection<Coord> coords, boolean fillAir, boolean replaceSolid) {
        coords.forEach(coord -> this.stroke(editor, (Coord)coord, fillAir, replaceSolid));
    }

    default public void fill(WorldEditor editor, Collection<Coord> coords) {
        this.fill(editor, coords, true, true);
    }

    default public BlockBrush setFacing(Direction direction) {
        return this;
    }

    public BlockBrush copy();
}

