/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.books;

import com.github.fnar.minecraft.block.BlockType;
import greymerk.roguelike.treasure.loot.Book;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class BookStatistics
extends Book {
    public BookStatistics(WorldEditor editor) {
        super("greymerk", "Statistics");
        for (String page : this.getPages(editor)) {
            this.addPage(page);
        }
    }

    private List<String> getPages(WorldEditor editor) {
        ArrayList<String> pages = new ArrayList<String>();
        Map<BlockType, Integer> stats = editor.getStats();
        int[] counter = new int[]{0};
        StringBuilder[] page = new StringBuilder[]{new StringBuilder()};
        Set<Map.Entry<BlockType, Integer>> entries = stats.entrySet();
        entries.stream().sorted(Comparator.comparingInt(Map.Entry::getValue).reversed()).forEach(entry -> {
            BlockType blockType = (BlockType)((Object)((Object)entry.getKey()));
            Integer count = (Integer)entry.getValue();
            String name = StringUtils.abbreviate((String)blockType.toString(), (int)16);
            String line = name + ": " + count + "\n";
            page[0].append(line);
            counter[0] = counter[0] + 1;
            if (counter[0] == 12) {
                counter[0] = 0;
                pages.add(page[0].toString());
                page[0] = new StringBuilder();
            }
        });
        pages.add(page[0].toString());
        return pages;
    }
}

