/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.dungeon.rooms;

import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.normal.StairsBlock;
import com.github.fnar.minecraft.block.spawner.MobType;
import com.github.fnar.roguelike.worldgen.generatables.NetherPortal;
import com.github.fnar.roguelike.worldgen.generatables.Pillar;
import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.base.BaseRoom;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class NetherPortalRoom
extends BaseRoom {
    public NetherPortalRoom(RoomSetting roomsSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomsSetting, levelSettings, worldEditor);
        this.wallDist = 9;
        this.ceilingHeight = 7;
        this.depth = 3;
    }

    @Override
    public BaseRoom generate(Coord at, List<Direction> entrances) {
        super.generate(at, entrances);
        Direction front = this.getEntrance(entrances);
        this.createPathFromEachEntranceToTheCenterOverTheLiquid(at, front);
        this.generateNetherPortalWithPlatform(at, front);
        this.generateChestInCorner(at, front);
        return null;
    }

    @Override
    protected void generateFloor(Coord at, List<Direction> entrances) {
        this.primaryFloorBrush().fill(this.worldEditor, at.copy().down(2).newRect(4).withHeight(2));
        this.generateCatwalks(at);
        this.theFloorIsLava(at);
    }

    private void generateCatwalks(Coord origin) {
        StairsBlock stair = this.primaryStairBrush();
        for (Direction side : Direction.cardinals()) {
            Coord catwalkOrigin = origin.copy().translate(side, this.getWallDist() - 1);
            this.primaryFloorBrush().fill(this.worldEditor, RectSolid.newRect(catwalkOrigin.copy().translate(side.left(), this.getWallDist()), catwalkOrigin.copy().translate(side.right(), this.getWallDist()).translate(side.back()).down(2)));
            SingleBlockBrush.AIR.fill(this.worldEditor, RectSolid.newRect(catwalkOrigin.copy().translate(side.left(), 2), catwalkOrigin.copy().translate(side.right(), 2).translate(side.back())));
            for (Direction orthogonal : side.orthogonals()) {
                Coord place = catwalkOrigin.copy().translate(orthogonal, 2);
                stair.setUpsideDown(false).setFacing(orthogonal.reverse());
                stair.stroke(this.worldEditor, place);
                stair.stroke(this.worldEditor, place.translate(side.back()));
            }
        }
    }

    private void createPathFromEachEntranceToTheCenterOverTheLiquid(Coord origin, Direction front) {
        Direction walkwayDirection = front.reverse();
        this.primaryFloorBrush().fill(this.worldEditor, RectSolid.newRect(origin.copy().translate(walkwayDirection.left()).down(), origin.copy().translate(walkwayDirection.right()).translate(walkwayDirection, this.getWallDist()).down(2)));
    }

    private void generateNetherPortalWithPlatform(Coord origin, Direction front) {
        int portalHeight = 7;
        int portalWidth = 5;
        Coord portalBase = origin.copy().down(2);
        this.primaryPillarBrush().fill(this.worldEditor, RectSolid.newRect(portalBase.copy().translate(front).translate(front.left(), 3), portalBase.copy().translate(front.back()).translate(front.right(), 3).up(portalHeight)));
        StairsBlock stairsBrush = this.primaryStairBrush();
        Stream.of(front, front.reverse()).forEach(side -> {
            Coord platformStairs = portalBase.copy().translate((Direction)((Object)side), 2).up();
            stairsBrush.setUpsideDown(false);
            stairsBrush.setFacing(side.reverse());
            stairsBrush.stroke(this.worldEditor, platformStairs);
            stairsBrush.stroke(this.worldEditor, platformStairs.copy().translate(front.left()));
            stairsBrush.stroke(this.worldEditor, platformStairs.copy().translate(front.right()));
        });
        new NetherPortal(this.worldEditor).generate(portalBase, front, portalWidth, portalHeight);
        for (Direction orthogonal : front.orthogonals()) {
            this.generateSpawner(portalBase.copy().translate(orthogonal, 2), new MobType[0]);
        }
    }

    @Override
    protected void generateDecorations(Coord at, List<Direction> entrances) {
        ArrayList pillarCoords = Lists.newArrayList();
        for (Direction c : Direction.cardinals()) {
            Direction l = c.left();
            Direction r = c.right();
            pillarCoords.add(at.copy().translate(l, 3).translate(c, 8));
            pillarCoords.add(at.copy().translate(r, 3).translate(c, 8));
            pillarCoords.add(at.copy().translate(l, 8).translate(c, 8));
        }
        Pillar pillar = Pillar.newPillar(this.worldEditor).withHeight(this.getCeilingHeight()).withStairs(this.primaryStairBrush()).withPillar(this.secondaryPillarBrush());
        pillarCoords.forEach(pillar::generate);
    }

    private void generateChestInCorner(Coord origin, Direction front) {
        if (this.random().nextInt(3) == 0) {
            return;
        }
        int distanceFromOrigin = this.getWallDist() - 2;
        Coord cursor = origin.copy().up().translate(front.reverse(), distanceFromOrigin).translate(front.reverse().left(), distanceFromOrigin);
        new TreasureChest(cursor, this.worldEditor).withChestType(this.getChestTypeOrUse(ChestType.chooseRandomAmong(this.random(), ChestType.UNCOMMON_TREASURES))).withFacing(front).withTrap(false).stroke(this.worldEditor, cursor);
    }
}

