/*
 * Decompiled with CFR 0.152.
 */
package jackyy.gunpowderlib.helper;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.oredict.OreDictionary;

public class ObjectHelper {
    public static Item getItemByName(String path) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(path));
    }

    public static Item getItemByName(String namespace, String path) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(namespace, path));
    }

    public static ItemStack getItemStackByName(String path, int amount, int meta) {
        return new ItemStack(ObjectHelper.getItemByName(path), amount, meta);
    }

    public static ItemStack getItemStackByName(String namespace, String path, int amount, int meta) {
        return new ItemStack(ObjectHelper.getItemByName(namespace, path), amount, meta);
    }

    public static ItemStack getStackWithNBT(ItemStack stack, NBTTagCompound nbt) {
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack[] getStacksFromOreDict(String oredict) {
        NonNullList stacks = OreDictionary.getOres((String)oredict);
        Object[] oredictlist = new ItemStack[stacks.size()];
        oredictlist = (ItemStack[])stacks.toArray(oredictlist);
        return oredictlist;
    }

    public static Block getBlockByName(String path) {
        return (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(path));
    }

    public static Block getBlockByName(String namespace, String path) {
        return (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(namespace, path));
    }

    public static ItemStack getBlockStackByName(String path, int amount, int meta) {
        return new ItemStack(ObjectHelper.getBlockByName(path), amount, meta);
    }

    public static ItemStack getBlockStackByName(String namespace, String path, int amount, int meta) {
        return new ItemStack(ObjectHelper.getBlockByName(namespace, path), amount, meta);
    }

    public static SoundEvent getSoundByName(String namespace, String path) {
        return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(namespace, path));
    }

    public static Potion getPotionByName(String namespace, String path) {
        return (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(namespace, path));
    }

    public static PotionEffect getPotionEffectByName(String namespace, String path) {
        return new PotionEffect(ObjectHelper.getPotionByName(namespace, path));
    }

    public static PotionEffect getPotionEffectByName(String namespace, String path, int duration) {
        return new PotionEffect(ObjectHelper.getPotionByName(namespace, path), duration);
    }

    public static PotionEffect getPotionEffectByName(String namespace, String path, int duration, int amplifier) {
        return new PotionEffect(ObjectHelper.getPotionByName(namespace, path), duration, amplifier);
    }

    public static PotionEffect getPotionEffectByName(String namespace, String path, int duration, int amplifier, boolean beacon, boolean particles) {
        return new PotionEffect(ObjectHelper.getPotionByName(namespace, path), duration, amplifier, beacon, particles);
    }

    public static ItemStack getBotaniaFlower(String type) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", type);
        return ObjectHelper.getStackWithNBT(ObjectHelper.getItemStackByName("botania", "specialflower", 1, 0), tag);
    }
}

