/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiButtonText;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiOptionButtonMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;

public class GuiMinimapPerformance
extends GuiScreenMinimap {
    private static final EnumOptionsMinimap[] relevantOptions = new EnumOptionsMinimap[]{EnumOptionsMinimap.LIGHTING, EnumOptionsMinimap.TERRAIN, EnumOptionsMinimap.WATERTRANSPARENCY, EnumOptionsMinimap.BLOCKTRANSPARENCY, EnumOptionsMinimap.BIOMES, EnumOptionsMinimap.FILTERING, EnumOptionsMinimap.CHUNKGRID, EnumOptionsMinimap.BIOMEOVERLAY, EnumOptionsMinimap.SLIMECHUNKS};
    private final int worldSeedButtonID = relevantOptions.length;
    private GuiButtonText worldSeedButton;
    private GuiScreen parentScreen;
    protected String screenTitle = "Details / Performance";
    private MapSettingsManager options;
    IVoxelMap master;

    public GuiMinimapPerformance(GuiScreen par1GuiScreen, IVoxelMap master) {
        this.parentScreen = par1GuiScreen;
        this.options = master.getMapOptions();
        this.master = master;
    }

    private int getLeftBorder() {
        return this.getWidth() / 2 - 155;
    }

    public void func_73866_w_() {
        this.screenTitle = I18nUtils.getString("options.minimap.detailsperformance", new Object[0]);
        Keyboard.enableRepeatEvents((boolean)true);
        int leftBorder = this.getLeftBorder();
        int var2 = 0;
        for (int t = 0; t < relevantOptions.length; ++t) {
            EnumOptionsMinimap option = relevantOptions[t];
            String text = this.options.getKeyText(option);
            if ((option == EnumOptionsMinimap.WATERTRANSPARENCY || option == EnumOptionsMinimap.BLOCKTRANSPARENCY || option == EnumOptionsMinimap.BIOMES) && !this.options.multicore && this.options.getOptionBooleanValue(option)) {
                text = "\u00a7c" + text;
            }
            GuiOptionButtonMinimap var7 = new GuiOptionButtonMinimap(option.returnEnumOrdinal(), leftBorder + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, text);
            this.field_146292_n.add(var7);
            ++var2;
        }
        String worldSeedDisplay = this.master.getWorldSeed();
        if (worldSeedDisplay.equals("")) {
            worldSeedDisplay = I18nUtils.getString("selectWorld.versionUnknown", new Object[0]);
        }
        String buttonText = I18nUtils.getString("options.minimap.worldseed", new Object[0]) + ": " + worldSeedDisplay;
        this.worldSeedButton = new GuiButtonText(this.worldSeedButtonID, this.getFontRenderer(), leftBorder + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), 150, 20, buttonText);
        this.worldSeedButton.setText(this.master.getWorldSeed());
        this.field_146292_n.add(this.worldSeedButton);
        ++var2;
        for (GuiButton buttonObj : this.getButtonList()) {
            GuiOptionButtonMinimap button;
            if (!(buttonObj instanceof GuiOptionButtonMinimap) || !(button = (GuiOptionButtonMinimap)buttonObj).returnEnumOptions().equals((Object)EnumOptionsMinimap.SLIMECHUNKS)) continue;
            button.field_146124_l = this.field_146297_k.func_71387_A() || !this.master.getWorldSeed().equals("");
        }
        this.worldSeedButton.field_146124_l = !this.field_146297_k.func_71387_A();
        this.field_146292_n.add(new GuiButton(200, this.getWidth() / 2 - 100, this.getHeight() / 6 + 168, I18nUtils.getString("gui.done", new Object[0])));
    }

    @Override
    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146127_k < 100 && par1GuiButton instanceof GuiOptionButtonMinimap) {
            this.options.setOptionValue(((GuiOptionButtonMinimap)par1GuiButton).returnEnumOptions(), 1);
            String perfBomb = "";
            if ((par1GuiButton.field_146127_k == EnumOptionsMinimap.WATERTRANSPARENCY.ordinal() || par1GuiButton.field_146127_k == EnumOptionsMinimap.BLOCKTRANSPARENCY.ordinal() || par1GuiButton.field_146127_k == EnumOptionsMinimap.BIOMES.ordinal()) && !this.options.multicore && this.options.getOptionBooleanValue(EnumOptionsMinimap.getEnumOptions(par1GuiButton.field_146127_k))) {
                perfBomb = "\u00a7c";
            }
            par1GuiButton.field_146126_j = perfBomb + this.options.getKeyText(EnumOptionsMinimap.getEnumOptions(par1GuiButton.field_146127_k));
        }
        for (GuiButton buttonObj : this.getButtonList()) {
            GuiOptionButtonMinimap button;
            if (!(buttonObj instanceof GuiOptionButtonMinimap) || !(button = (GuiOptionButtonMinimap)buttonObj).returnEnumOptions().equals((Object)EnumOptionsMinimap.SLIMECHUNKS)) continue;
            button.field_146124_l = this.field_146297_k.func_71387_A() || !this.master.getWorldSeed().equals("");
        }
        boolean bl = this.worldSeedButton.field_146124_l = !this.field_146297_k.func_71387_A();
        if (par1GuiButton.field_146127_k == 200) {
            this.getMinecraft().func_147108_a(this.parentScreen);
        }
    }

    protected void func_73869_a(char character, int keycode) throws IOException {
        if (character == '\r' && this.worldSeedButton.isFocused()) {
            String buttonText;
            String newSeed = this.worldSeedButton.getText();
            this.master.setWorldSeed(newSeed);
            String worldSeedDisplay = this.master.getWorldSeed();
            if (worldSeedDisplay.equals("")) {
                worldSeedDisplay = I18nUtils.getString("selectWorld.versionUnknown", new Object[0]);
            }
            this.worldSeedButton.field_146126_j = buttonText = I18nUtils.getString("options.minimap.worldseed", new Object[0]) + ": " + worldSeedDisplay;
            this.worldSeedButton.setText(this.master.getWorldSeed());
            this.master.getMap().forceFullRender(true);
            for (GuiButton buttonObj : this.getButtonList()) {
                GuiOptionButtonMinimap button;
                if (!(buttonObj instanceof GuiOptionButtonMinimap) || !(button = (GuiOptionButtonMinimap)buttonObj).returnEnumOptions().equals((Object)EnumOptionsMinimap.SLIMECHUNKS)) continue;
                button.field_146124_l = this.field_146297_k.func_71387_A() || !this.master.getWorldSeed().equals("");
            }
        }
        this.worldSeedButton.textboxKeyTyped(character, keycode);
        super.func_73869_a(character, keycode);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.drawMap();
        this.func_146276_q_();
        this.func_73732_a(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        super.func_73863_a(par1, par2, par3);
    }

    public void func_73876_c() {
        this.worldSeedButton.updateCursorCounter();
    }
}

