/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mezz.jei.Internal;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.IGlobalGuiHandler;
import mezz.jei.api.gui.IGuiScreenHandler;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.Config;
import mezz.jei.gui.GuiEventHandler;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import mezz.jei.gui.overlay.bookmarks.LeftAreaDispatcher;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientListElement;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.input.InputHandler;
import mezz.jei.plugins.vanilla.VanillaPlugin;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.runtime.JeiHelpers;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.runtime.SubtypeRegistry;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.startup.ModIngredientRegistration;
import mezz.jei.startup.ModRegistry;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import mezz.jei.util.LoggedTimer;
import net.minecraftforge.fml.common.ProgressManager;

public class JeiStarter {
    private boolean started;

    public void start(List<IModPlugin> plugins, Textures textures) {
        LoggedTimer totalTime = new LoggedTimer();
        totalTime.start("Starting HEI");
        IngredientListElement.canonicalizedStringArrays = new ObjectOpenHashSet();
        IModIdHelper modIdHelper = ForgeModIdHelper.getInstance();
        ErrorUtil.setModIdHelper(modIdHelper);
        SubtypeRegistry subtypeRegistry = new SubtypeRegistry();
        Internal.setSubtypeRegistry(subtypeRegistry);
        JeiStarter.registerItemSubtypes(plugins, subtypeRegistry);
        StackHelper stackHelper = new StackHelper(subtypeRegistry);
        stackHelper.enableUidCache();
        Internal.setStackHelper(stackHelper);
        IngredientBlacklistInternal blacklist = new IngredientBlacklistInternal();
        ModIngredientRegistration modIngredientRegistry = JeiStarter.registerIngredients(plugins);
        IngredientRegistry ingredientRegistry = modIngredientRegistry.createIngredientRegistry(modIdHelper, blacklist);
        Internal.setIngredientRegistry(ingredientRegistry);
        GuiHelper guiHelper = new GuiHelper(ingredientRegistry, textures);
        JeiHelpers jeiHelpers = new JeiHelpers(guiHelper, ingredientRegistry, blacklist, stackHelper);
        Internal.setHelpers(jeiHelpers);
        ModRegistry modRegistry = new ModRegistry(jeiHelpers, ingredientRegistry);
        LoggedTimer timer = new LoggedTimer();
        timer.start("Registering recipe categories");
        JeiStarter.registerCategories(plugins, modRegistry);
        timer.stop();
        timer.start("Registering mod plugins");
        JeiStarter.registerPlugins(plugins, modRegistry);
        timer.stop();
        timer.start("Building recipe registry");
        RecipeRegistry recipeRegistry = modRegistry.createRecipeRegistry(ingredientRegistry);
        timer.stop();
        timer.start("Building ingredient filter and search trees");
        IngredientFilter ingredientFilter = new IngredientFilter(blacklist, IngredientListElementFactory.createBaseList(ingredientRegistry, modIdHelper));
        Internal.setIngredientFilter(ingredientFilter);
        timer.stop();
        timer.start("Building bookmarks");
        BookmarkList bookmarkList = new BookmarkList(ingredientRegistry);
        bookmarkList.loadBookmarks();
        timer.stop();
        timer.start("Building runtime");
        List<IAdvancedGuiHandler<?>> advancedGuiHandlers = modRegistry.getAdvancedGuiHandlers();
        List<IGlobalGuiHandler> globalGuiHandlers = modRegistry.getGlobalGuiHandlers();
        Map<Class, IGuiScreenHandler> guiScreenHandlers = modRegistry.getGuiScreenHandlers();
        Map<Class, IGhostIngredientHandler> ghostIngredientHandlers = modRegistry.getGhostIngredientHandlers();
        GuiScreenHelper guiScreenHelper = new GuiScreenHelper(ingredientRegistry, globalGuiHandlers, advancedGuiHandlers, ghostIngredientHandlers, guiScreenHandlers);
        IngredientListOverlay ingredientListOverlay = new IngredientListOverlay(ingredientFilter, ingredientRegistry, guiScreenHelper);
        BookmarkOverlay bookmarkOverlay = new BookmarkOverlay(bookmarkList, jeiHelpers.getGuiHelper(), guiScreenHelper);
        RecipesGui recipesGui = new RecipesGui(recipeRegistry, ingredientRegistry);
        JeiRuntime jeiRuntime = new JeiRuntime(recipeRegistry, ingredientListOverlay, bookmarkOverlay, recipesGui, ingredientFilter);
        Internal.setRuntime(jeiRuntime);
        timer.stop();
        stackHelper.disableUidCache();
        JeiStarter.sendRuntime(plugins, jeiRuntime);
        LeftAreaDispatcher leftAreaDispatcher = new LeftAreaDispatcher(guiScreenHelper);
        leftAreaDispatcher.addContent(bookmarkOverlay);
        GuiEventHandler guiEventHandler = new GuiEventHandler(guiScreenHelper, leftAreaDispatcher, ingredientListOverlay, recipeRegistry);
        Internal.setGuiEventHandler(guiEventHandler);
        InputHandler inputHandler = new InputHandler(jeiRuntime, ingredientRegistry, ingredientListOverlay, guiScreenHelper, leftAreaDispatcher, bookmarkList);
        Internal.setInputHandler(inputHandler);
        Config.checkForModNameFormatOverride();
        IngredientListElement.canonicalizedStringArrays = new ObjectOpenHashSet();
        this.started = true;
        totalTime.stop();
    }

    public boolean hasStarted() {
        return this.started;
    }

    private static void registerItemSubtypes(List<IModPlugin> plugins, SubtypeRegistry subtypeRegistry) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering item subtypes", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                plugin.registerSubtypes(subtypeRegistry);
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Failed to register item subtypes for mod plugin: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static ModIngredientRegistration registerIngredients(List<IModPlugin> plugins) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering ingredients", (int)plugins.size());
        ModIngredientRegistration modIngredientRegistry = new ModIngredientRegistration();
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                plugin.registerIngredients(modIngredientRegistry);
            }
            catch (LinkageError | RuntimeException e) {
                if (plugin instanceof VanillaPlugin) {
                    throw e;
                }
                Log.get().error("Failed to register Ingredients for mod plugin: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        return modIngredientRegistry;
    }

    private static void registerCategories(List<IModPlugin> plugins, ModRegistry modRegistry) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering categories", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                long start_time = System.currentTimeMillis();
                Log.get().debug("Registering categories: {} ...", (Object)plugin.getClass().getName());
                plugin.registerCategories(modRegistry);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                Log.get().debug("Registered  categories: {} in {} ms", (Object)plugin.getClass().getName(), (Object)timeElapsedMs);
            }
            catch (AbstractMethodError start_time) {
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Failed to register mod categories: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static void registerPlugins(List<IModPlugin> plugins, ModRegistry modRegistry) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering plugins", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                long start_time = System.currentTimeMillis();
                Log.get().debug("Registering plugin: {} ...", (Object)plugin.getClass().getName());
                plugin.register(modRegistry);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                Log.get().debug("Registered  plugin: {} in {} ms", (Object)plugin.getClass().getName(), (Object)timeElapsedMs);
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Failed to register mod plugin: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static void sendRuntime(List<IModPlugin> plugins, IJeiRuntime jeiRuntime) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Sending Runtime", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                long start_time = System.currentTimeMillis();
                Log.get().debug("Sending runtime to plugin: {} ...", (Object)plugin.getClass().getName());
                plugin.onRuntimeAvailable(jeiRuntime);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                if (timeElapsedMs <= 100L) continue;
                Log.get().warn("Sending runtime to plugin: {} took {} ms", (Object)plugin.getClass().getName(), (Object)timeElapsedMs);
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Sending runtime to plugin failed: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }
}

