/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.search.IBuildable;
import mezz.jei.search.ISearchStorage;
import mezz.jei.search.ISearchable;
import mezz.jei.search.PrefixInfo;
import mezz.jei.util.LoggedTimer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.ProgressManager;

public class PrefixedSearchable
implements ISearchable<IIngredientListElement<?>>,
IBuildable {
    protected final ISearchStorage<IIngredientListElement<?>> searchStorage;
    protected final PrefixInfo prefixInfo;
    protected LoggedTimer timer;

    public PrefixedSearchable(ISearchStorage<IIngredientListElement<?>> searchStorage, PrefixInfo prefixInfo) {
        this.searchStorage = searchStorage;
        this.prefixInfo = prefixInfo;
    }

    public ISearchStorage<IIngredientListElement<?>> getSearchStorage() {
        return this.searchStorage;
    }

    public Collection<String> getStrings(IIngredientListElement<?> element) {
        return this.prefixInfo.getStrings(element);
    }

    @Override
    public Config.SearchMode getMode() {
        return this.prefixInfo.getMode();
    }

    @Override
    public void submit(IIngredientListElement<?> ingredient) {
        Collection<String> strings = this.prefixInfo.getStrings(ingredient);
        for (String string : strings) {
            this.searchStorage.put(string, ingredient);
        }
    }

    @Override
    public void submitAll(NonNullList<IIngredientListElement> ingredients) {
        if (IngredientFilter.firstBuild) {
            this.start();
            ProgressManager.ProgressBar progressBar = null;
            if (!IngredientFilter.rebuild) {
                long modNameCount = ingredients.stream().map(IIngredientListElement::getModNameForSorting).distinct().count();
                progressBar = ProgressManager.push((String)"Indexing ingredients", (int)((int)modNameCount));
            }
            String currentModName = null;
            for (IIngredientListElement ingredient : ingredients) {
                String modname = ingredient.getModNameForSorting();
                if (!Objects.equals(currentModName, modname)) {
                    currentModName = modname;
                    if (progressBar != null) {
                        progressBar.step(modname);
                    }
                }
                this.submit(ingredient);
            }
            if (progressBar != null) {
                ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
            }
            this.stop();
        } else {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Adding ingredients at runtime", (int)ingredients.size());
            for (IIngredientListElement ingredient : ingredients) {
                progressBar.step(ingredient.getDisplayName());
                this.submit(ingredient);
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    @Override
    public void getSearchResults(String token, Set<IIngredientListElement<?>> results) {
        this.searchStorage.getSearchResults(token, results);
    }

    @Override
    public void getAllElements(Set<IIngredientListElement<?>> results) {
        this.searchStorage.getAllElements(results);
    }

    @Override
    public void start() {
        this.timer = new LoggedTimer();
        this.timer.start("Building [" + this.prefixInfo.getDesc() + "] search tree");
    }

    @Override
    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }
}

