/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.ISlowRenderItem;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.render.IngredientRenderer;
import mezz.jei.render.ItemStackFastRenderer;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.ItemStack;

public class IngredientListBatchRenderer {
    private final List<IngredientListSlot> slots = new ArrayList<IngredientListSlot>();
    private final List<ItemStackFastRenderer> renderItems2d = new ArrayList<ItemStackFastRenderer>();
    private final List<ItemStackFastRenderer> renderItems3d = new ArrayList<ItemStackFastRenderer>();
    private final List<IngredientRenderer> renderOther = new ArrayList<IngredientRenderer>();
    @Nullable
    private Framebuffer framebuffer = null;
    private boolean refreshBuffer = true;
    private int blocked = 0;

    public void clear() {
        this.slots.clear();
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
        this.blocked = 0;
    }

    public int size() {
        return this.slots.size() - this.blocked;
    }

    public void add(IngredientListSlot ingredientListSlot) {
        this.slots.add(ingredientListSlot);
    }

    public List<IngredientListSlot> getAllGuiIngredientSlots() {
        return this.slots;
    }

    public void set(int startIndex, List<IIngredientListElement> ingredientList) {
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
        this.blocked = 0;
        int i = startIndex;
        for (IngredientListSlot ingredientListSlot : this.slots) {
            if (ingredientListSlot.isBlocked()) {
                ingredientListSlot.clear();
                ++this.blocked;
                continue;
            }
            if (i >= ingredientList.size()) {
                ingredientListSlot.clear();
            } else {
                IIngredientListElement element = ingredientList.get(i);
                this.set(ingredientListSlot, element);
            }
            ++i;
        }
        this.refreshBuffer = true;
    }

    private <V> void set(IngredientListSlot ingredientListSlot, IIngredientListElement<V> element) {
        ingredientListSlot.clear();
        V ingredient = element.getIngredient();
        if (ingredient instanceof ItemStack) {
            IBakedModel bakedModel;
            IIngredientListElement<ItemStack> itemStackElement = element;
            ItemStack itemStack = (ItemStack)itemStackElement.getIngredient();
            ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
            try {
                bakedModel = itemModelMesher.func_178089_a(itemStack);
                bakedModel = bakedModel.func_188617_f().handleItemState(bakedModel, itemStack, null, null);
                Preconditions.checkNotNull((Object)bakedModel, (Object)"IBakedModel must not be null.");
            }
            catch (Throwable throwable) {
                String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
                Log.get().error("ItemStack crashed getting IBakedModel. {}", (Object)stackInfo, (Object)throwable);
                return;
            }
            if (!bakedModel.func_188618_c() && !(itemStack.func_77973_b() instanceof ISlowRenderItem)) {
                ItemStackFastRenderer renderer = new ItemStackFastRenderer(itemStackElement);
                ingredientListSlot.setIngredientRenderer(renderer);
                if (bakedModel.func_177556_c()) {
                    this.renderItems3d.add(renderer);
                } else {
                    this.renderItems2d.add(renderer);
                }
                return;
            }
        }
        IngredientRenderer<V> renderer = new IngredientRenderer<V>(element);
        ingredientListSlot.setIngredientRenderer(renderer);
        this.renderOther.add(renderer);
    }

    @Nullable
    public ClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        IngredientRenderer hovered = this.getHovered(mouseX, mouseY);
        if (hovered != null) {
            IIngredientListElement element = hovered.getElement();
            return ClickedIngredient.create(element.getIngredient(), hovered.getArea());
        }
        return null;
    }

    @Nullable
    public IngredientRenderer getHovered(int mouseX, int mouseY) {
        for (IngredientListSlot slot : this.slots) {
            if (!slot.isMouseOver(mouseX, mouseY)) continue;
            return slot.getIngredientRenderer();
        }
        return null;
    }

    public void render(Minecraft minecraft) {
        if (!Config.isEditModeEnabled() && Config.bufferIngredientRenders() && OpenGlHelper.field_148823_f) {
            if (this.framebuffer == null) {
                this.framebuffer = new Framebuffer(minecraft.field_71443_c, minecraft.field_71440_d, true);
                this.framebuffer.field_147625_i[0] = 0.0f;
                this.framebuffer.field_147625_i[1] = 0.0f;
                this.framebuffer.field_147625_i[2] = 0.0f;
            }
            if (this.refreshBuffer) {
                this.framebuffer.func_147613_a(minecraft.field_71443_c, minecraft.field_71440_d);
                this.framebuffer.func_147614_f();
                this.framebuffer.func_147610_a(false);
                GlStateManager.func_179084_k();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)1, (int)771, (int)1, (int)771);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.framebuffer.func_147612_c();
                GlStateManager.func_179098_w();
                ScaledResolution res = new ScaledResolution(minecraft);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buffer.func_181662_b(0.0, res.func_78324_d(), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b(res.func_78327_c(), res.func_78324_d(), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(res.func_78327_c(), 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                return;
            }
        }
        this.renderImpl(minecraft);
        if (!Config.isEditModeEnabled() && Config.bufferIngredientRenders() && this.refreshBuffer && OpenGlHelper.field_148823_f) {
            this.refreshBuffer = false;
            minecraft.func_147110_a().func_147610_a(false);
        }
    }

    private void renderImpl(Minecraft minecraft) {
        RenderHelper.func_74520_c();
        RenderItem renderItem = minecraft.func_175599_af();
        TextureManager textureManager = minecraft.func_110434_K();
        renderItem.field_77023_b += 50.0f;
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems3d) {
            itemStackFastRenderer.renderItemAndEffectIntoGUI();
        }
        GlStateManager.func_179140_f();
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems2d) {
            itemStackFastRenderer.renderItemAndEffectIntoGUI();
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        renderItem.field_77023_b -= 50.0f;
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems3d) {
            itemStackFastRenderer.renderOverlay();
        }
        for (ItemStackFastRenderer itemStackFastRenderer : this.renderItems2d) {
            itemStackFastRenderer.renderOverlay();
        }
        GlStateManager.func_179140_f();
        for (IngredientRenderer ingredientRenderer : this.renderOther) {
            ingredientRenderer.renderSlow();
        }
        RenderHelper.func_74518_a();
    }
}

