/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.NibbleArray;
import silly511.backups.BackupsMod;
import silly511.backups.util.GzipInputStream;

public class GzippedRegionLoader {
    private final Map<ChunkPos, ChunkData> chunkCache = new HashMap<ChunkPos, ChunkData>();
    private File regionDir;

    public GzippedRegionLoader(File dimDir) {
        this.regionDir = new File(dimDir, "region");
    }

    public IBlockState getBlockState(BlockPos pos) {
        ChunkData chunk = this.getChunk(new ChunkPos(pos));
        if (chunk.isEmpty) {
            return Blocks.field_150350_a.func_176223_P();
        }
        IBlockState state = chunk.blockStates[pos.func_177958_n() & 0xF][pos.func_177956_o()][pos.func_177952_p() & 0xF];
        return state == null ? Blocks.field_150350_a.func_176223_P() : state;
    }

    public NBTTagCompound getTileEntityData(BlockPos pos) {
        return (NBTTagCompound)this.getChunk(new ChunkPos(pos)).tileEntityData.get(pos);
    }

    public TileTick getTileTick(BlockPos pos) {
        return (TileTick)this.getChunk(new ChunkPos(pos)).tileTicks.get(pos);
    }

    protected ChunkData getChunk(ChunkPos pos) {
        ChunkData chunkData = this.chunkCache.get(pos);
        if (chunkData == null) {
            File regionFile = new File(this.regionDir, "r." + (pos.field_77276_a >> 5) + "." + (pos.field_77275_b >> 5) + ".mca.gz");
            if (regionFile.exists()) {
                try (DataInputStream stream = new DataInputStream(new GzipInputStream(new FileInputStream(regionFile)));){
                    chunkData = new ChunkData(GzippedRegionLoader.getChunkNBT(stream, pos.field_77276_a & 0x1F, pos.field_77275_b & 0x1F));
                }
                catch (IOException ex) {
                    BackupsMod.logger.error("Unable to read chunk " + pos.field_77276_a + ", " + pos.field_77275_b, (Throwable)ex);
                    chunkData = new ChunkData();
                }
            } else {
                chunkData = new ChunkData();
            }
            this.chunkCache.put(pos, chunkData);
        }
        return chunkData;
    }

    private static NBTTagCompound getChunkNBT(DataInputStream stream, int chunkX, int chunkZ) throws IOException {
        stream.skip((chunkX + chunkZ * 32) * 4);
        int offset = stream.readInt();
        if (offset == 0) {
            return null;
        }
        stream.skip((offset >> 8) * 4096 - (chunkX + chunkZ * 32 + 1) * 4);
        int length = stream.readInt();
        if (length > (offset & 0xFF) * 4096 || length <= 0) {
            throw new IOException("Invalid length");
        }
        byte compressionType = stream.readByte();
        byte[] bytes = new byte[length - 1];
        stream.readFully(bytes);
        InputStream inputStream = new ByteArrayInputStream(bytes);
        if (compressionType == 1) {
            inputStream = new GZIPInputStream(inputStream);
        } else if (compressionType == 2) {
            inputStream = new InflaterInputStream(inputStream);
        } else {
            throw new IOException("Invalid compression type");
        }
        return CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(inputStream));
    }

    public static class TileTick {
        public final Block block;
        public final int time;
        public final int priority;

        public TileTick(Block block, int time, int priority) {
            this.block = block;
            this.time = time;
            this.priority = priority;
        }
    }

    protected static class ChunkData {
        private final boolean isEmpty;
        private final IBlockState[][][] blockStates;
        private final Map<BlockPos, NBTTagCompound> tileEntityData = new HashMap<BlockPos, NBTTagCompound>();
        private final Map<BlockPos, TileTick> tileTicks = new HashMap<BlockPos, TileTick>();
        private final List<NBTTagCompound> entities = new ArrayList<NBTTagCompound>();

        public ChunkData() {
            this.isEmpty = true;
            this.blockStates = null;
        }

        public ChunkData(NBTTagCompound nbt) {
            this.isEmpty = false;
            this.blockStates = new IBlockState[16][256][16];
            NBTTagCompound tag = nbt.func_74775_l("Level");
            NBTTagList sections = tag.func_150295_c("Sections", 10);
            for (int i = 0; i < sections.func_74745_c(); ++i) {
                NBTTagCompound section = sections.func_150305_b(i);
                int sectionY = section.func_74771_c("Y") << 4;
                byte[] blocks = section.func_74770_j("Blocks");
                NibbleArray metadata = new NibbleArray(section.func_74770_j("Data"));
                NibbleArray blocksExtra = section.func_150297_b("Add", 7) ? new NibbleArray(section.func_74770_j("Add")) : null;
                for (int j = 0; j < blocks.length; ++j) {
                    int x = j & 0xF;
                    int y = j >> 8 & 0xF;
                    int z = j >> 4 & 0xF;
                    int extra = blocksExtra != null ? blocksExtra.func_76582_a(x, y, z) : 0;
                    int blockStateId = extra << 12 | (blocks[j] & 0xFF) << 4 | metadata.func_76582_a(x, y, z);
                    this.blockStates[x][y + sectionY][z] = (IBlockState)Block.field_176229_d.func_148745_a(blockStateId);
                }
            }
            NBTTagList tileEntities = tag.func_150295_c("TileEntities", 10);
            for (int i = 0; i < tileEntities.func_74745_c(); ++i) {
                NBTTagCompound tileData = tileEntities.func_150305_b(i);
                BlockPos pos = new BlockPos(tileData.func_74762_e("x"), tileData.func_74762_e("y"), tileData.func_74762_e("z"));
                this.tileEntityData.put(pos, tileData);
            }
            NBTTagList tileTicksList = tag.func_150295_c("TileTicks", 10);
            for (int i = 0; i < tileTicksList.func_74745_c(); ++i) {
                NBTTagCompound tickData = tileTicksList.func_150305_b(i);
                BlockPos pos = new BlockPos(tickData.func_74762_e("x"), tickData.func_74762_e("y"), tickData.func_74762_e("z"));
                this.tileTicks.put(pos, new TileTick(Block.func_149684_b((String)tickData.func_74779_i("i")), tickData.func_74762_e("t"), tickData.func_74762_e("p")));
            }
            NBTTagList entitiesList = tag.func_150295_c("Entities", 10);
            for (int i = 0; i < entitiesList.func_74745_c(); ++i) {
                this.entities.add(entitiesList.func_150305_b(i));
            }
        }
    }
}

