/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups;

import java.io.File;
import java.io.IOException;
import silly511.backups.helpers.BackupHelper;

public class CommandLineRestore {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            CommandLineRestore.error("Usage: <backup dir> <world dir>");
        }
        File backupDir = new File(args[0]).getAbsoluteFile();
        File worldDir = new File(args[1]).getAbsoluteFile();
        if (!backupDir.isDirectory() || !new File(backupDir, "backupMetadata.dat").isFile()) {
            CommandLineRestore.error("Backup is invalid");
        }
        System.out.println("Restoring...");
        BackupHelper.restoreBackup(backupDir.toPath(), worldDir.toPath(), worldDir.toPath().getParent(), null);
    }

    private static void error(String s) {
        System.err.println(s);
        System.exit(-1);
    }
}

