/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.network.messages;

import de.srendi.advancedperipherals.common.blocks.tileentity.ARControllerTile;
import de.srendi.advancedperipherals.network.MNetwork;
import de.srendi.advancedperipherals.network.messages.UpdateHudCanvasMessage;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class RequestHudCanvasMessage {
    private BlockPos blockPos;
    private String dimensionKey;

    public RequestHudCanvasMessage(BlockPos blockPos, String dimensionKey) {
        this.blockPos = blockPos;
        this.dimensionKey = dimensionKey;
    }

    public static RequestHudCanvasMessage decode(PacketBuffer buf) {
        BlockPos blockPos = buf.func_179259_c();
        String dimensionKey = buf.func_150789_c(Short.MAX_VALUE);
        return new RequestHudCanvasMessage(blockPos, dimensionKey);
    }

    public static void encode(RequestHudCanvasMessage mes, PacketBuffer buf) {
        buf.func_179255_a(mes.getBlockPos());
        buf.func_211400_a(mes.getDimensionKey(), Short.MAX_VALUE);
    }

    public static void handle(RequestHudCanvasMessage mes, Supplier<NetworkEvent.Context> cont) {
        cont.get().enqueueWork(() -> {
            Iterable worlds = ((NetworkEvent.Context)cont.get()).getSender().func_184102_h().func_212370_w();
            for (ServerWorld world : worlds) {
                if (!world.func_234923_W_().toString().equals(mes.getDimensionKey())) continue;
                TileEntity te = world.func_175625_s(mes.getBlockPos());
                if (!(te instanceof ARControllerTile)) {
                    return;
                }
                ARControllerTile controller = (ARControllerTile)te;
                MNetwork.sendTo(new UpdateHudCanvasMessage(controller.getCanvas()), ((NetworkEvent.Context)cont.get()).getSender());
                break;
            }
        });
        cont.get().setPacketHandled(true);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public String getDimensionKey() {
        return this.dimensionKey;
    }
}

