/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib.peripherals.owner;

import dan200.computercraft.api.pocket.IPocketAccess;
import de.srendi.advancedperipherals.common.util.DataStorageUtil;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import de.srendi.advancedperipherals.lib.peripherals.owner.BasePeripheralOwner;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PocketPeripheralOwner
extends BasePeripheralOwner {
    private final IPocketAccess pocket;

    public PocketPeripheralOwner(IPocketAccess pocket) {
        this.pocket = pocket;
    }

    @Override
    @Nullable
    public String getCustomName() {
        return null;
    }

    @Override
    @Nullable
    public World getWorld() {
        Entity owner = this.pocket.getEntity();
        if (owner == null) {
            return null;
        }
        return owner.func_130014_f_();
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        Entity owner = this.pocket.getEntity();
        if (owner == null) {
            return new BlockPos(0, 0, 0);
        }
        return owner.func_233580_cy_();
    }

    @Override
    @NotNull
    public Direction getFacing() {
        Entity owner = this.pocket.getEntity();
        if (owner == null) {
            return Direction.NORTH;
        }
        return owner.func_174811_aO();
    }

    @Override
    @Nullable
    public PlayerEntity getOwner() {
        Entity owner = this.pocket.getEntity();
        if (owner instanceof PlayerEntity) {
            return (PlayerEntity)owner;
        }
        return null;
    }

    @Override
    @NotNull
    public CompoundNBT getDataStorage() {
        return DataStorageUtil.getDataStorage(this.pocket);
    }

    @Override
    public void markDataStorageDirty() {
        this.pocket.updateUpgradeNBTData();
    }

    @Override
    public <T> T withPlayer(Function<APFakePlayer, T> function) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public ItemStack getToolInMainHand() {
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack storeItem(ItemStack stored) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void destroyUpgrade() {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public boolean isMovementPossible(@NotNull World world, @NotNull BlockPos pos) {
        return false;
    }

    @Override
    public boolean move(@NotNull World world, @NotNull BlockPos pos) {
        return false;
    }
}

