/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import org.apache.logging.log4j.Level;

public class NBTUtil {
    public static INBT toDirectNBT(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return ByteNBT.func_229671_a_((byte)((byte)((Boolean)object != false ? 1 : 0)));
        }
        if (object instanceof Integer) {
            return IntNBT.func_229692_a_((int)((Integer)object));
        }
        if (object instanceof Number) {
            return DoubleNBT.func_229684_a_((double)((Number)object).doubleValue());
        }
        if (object instanceof String) {
            return StringNBT.func_229705_a_((String)object.toString());
        }
        if (object instanceof Map) {
            Map m = (Map)object;
            CompoundNBT nbt = new CompoundNBT();
            for (Map.Entry item : m.entrySet()) {
                INBT value = NBTUtil.toDirectNBT(item.getValue());
                if (item.getKey() == null || value == null) continue;
                nbt.func_218657_a(item.getKey().toString(), value);
            }
            return nbt;
        }
        return null;
    }

    public static CompoundNBT fromText(String json) {
        try {
            return json == null ? null : JsonToNBT.func_180713_a((String)json);
        }
        catch (CommandSyntaxException ex) {
            AdvancedPeripherals.debug("Could not parse json data to NBT", Level.ERROR);
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompoundNBT fromBinary(String base64) {
        if (base64 == null) {
            return null;
        }
        try (InputStream inputStream = Base64.getDecoder().wrap(new ByteArrayInputStream(base64.getBytes()));){
            CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            return compoundNBT;
        }
        catch (IOException ex) {
            AdvancedPeripherals.debug("Could not parse binary data to NBT", Level.ERROR);
            ex.printStackTrace();
            return null;
        }
    }

    public static CompoundNBT toNBT(BlockPos pos) {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a("x", pos.func_177958_n());
        data.func_74768_a("y", pos.func_177956_o());
        data.func_74768_a("z", pos.func_177952_p());
        return data;
    }

    public static BlockPos blockPosFromNBT(CompoundNBT nbt) {
        return new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
    }

    public static CompoundNBT toNBT(ChunkPos pos) {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a("x", pos.field_77276_a);
        data.func_74768_a("z", pos.field_77275_b);
        return data;
    }

    public static ChunkPos chunkPosFromNBT(CompoundNBT nbt) {
        return new ChunkPos(nbt.func_74762_e("x"), nbt.func_74762_e("z"));
    }
}

