/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.TableHelper;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AppEngApi;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorage;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

public class ItemUtil {
    @ObjectHolder(value="computercraft:turtle_normal")
    public static Item TURTLE_NORMAL;
    @ObjectHolder(value="computercraft:turtle_advanced")
    public static Item TURTLE_ADVANCED;
    @ObjectHolder(value="computercraft:pocket_computer_normal")
    public static Item POCKET_NORMAL;
    @ObjectHolder(value="computercraft:pocket_computer_advanced")
    public static Item POCKET_ADVANCED;

    public static <T extends ForgeRegistryEntry<T>> T getRegistryEntry(String name, IForgeRegistry<T> forgeRegistry) {
        ForgeRegistryEntry value;
        ResourceLocation location;
        try {
            location = new ResourceLocation(name);
        }
        catch (ResourceLocationException ex) {
            location = null;
        }
        if (location != null && forgeRegistry.containsKey(location) && (value = (ForgeRegistryEntry)forgeRegistry.getValue(location)) != null) {
            return (T)value;
        }
        return null;
    }

    public static ItemStack getItemStack(Map<?, ?> table, IMEMonitor<IAEItemStack> monitor) throws LuaException {
        if (table == null || table.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (table.containsKey("fingerprint")) {
            ItemStack fingerprint = AppEngApi.getInstance().findMatchingFingerprint(TableHelper.getStringField(table, (String)"fingerprint"), monitor);
            if (table.containsKey("count")) {
                fingerprint.func_190920_e(TableHelper.getIntField(table, (String)"count"));
            }
            return fingerprint;
        }
        if (!table.containsKey("name")) {
            return ItemStack.field_190927_a;
        }
        String name = TableHelper.getStringField(table, (String)"name");
        Item item = (Item)ItemUtil.getRegistryEntry(name, ForgeRegistries.ITEMS);
        ItemStack stack = new ItemStack((IItemProvider)item, 1);
        if (table.containsKey("count")) {
            stack.func_190920_e(TableHelper.getIntField(table, (String)"count"));
        }
        if (table.containsKey("nbt") || table.containsKey("json") || table.containsKey("tag")) {
            stack.func_77982_d(ItemUtil.getTag(stack, table, monitor));
        }
        return stack;
    }

    private static CompoundNBT getTag(ItemStack stack, Map<?, ?> table, IMEMonitor<IAEItemStack> monitor) throws LuaException {
        CompoundNBT nbt = NBTUtil.fromText(TableHelper.optStringField(table, (String)"json", null));
        if (nbt == null && (nbt = NBTUtil.fromBinary(TableHelper.optStringField(table, (String)"tag", null))) == null) {
            nbt = ItemUtil.parseNBTHash(stack, table, monitor);
        }
        return nbt;
    }

    private static CompoundNBT parseNBTHash(ItemStack stack, Map<?, ?> table, IMEMonitor<IAEItemStack> monitor) throws LuaException {
        String nbt = TableHelper.optStringField(table, (String)"nbt", null);
        if (nbt == null || nbt.isEmpty()) {
            return null;
        }
        CompoundNBT tag = AppEngApi.getInstance().findMatchingTag(stack, nbt, monitor);
        if (tag != null) {
            return tag;
        }
        tag = new CompoundNBT();
        tag.func_218657_a("_apPlaceholder_", (INBT)IntNBT.func_229692_a_((int)1));
        return tag;
    }

    public static ItemStack getItemStackRS(Map<?, ?> table, List<ItemStack> items) throws LuaException {
        if (table == null || table.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (table.containsKey("fingerprint")) {
            ItemStack fingerprint = RefinedStorage.findMatchingFingerprint(TableHelper.getStringField(table, (String)"fingerprint"), items);
            if (table.containsKey("count")) {
                fingerprint.func_190920_e(TableHelper.getIntField(table, (String)"count"));
            }
            return fingerprint;
        }
        if (!table.containsKey("name")) {
            return ItemStack.field_190927_a;
        }
        String name = TableHelper.getStringField(table, (String)"name");
        Item item = (Item)ItemUtil.getRegistryEntry(name, ForgeRegistries.ITEMS);
        ItemStack stack = new ItemStack((IItemProvider)item, 1);
        if (table.containsKey("count")) {
            stack.func_190920_e(TableHelper.getIntField(table, (String)"count"));
        }
        if (table.containsKey("nbt") || table.containsKey("json") || table.containsKey("tag")) {
            stack.func_77982_d(ItemUtil.getTagRS(stack, table, items));
        }
        return stack;
    }

    private static CompoundNBT getTagRS(ItemStack stack, Map<?, ?> table, List<ItemStack> items) throws LuaException {
        CompoundNBT nbt = NBTUtil.fromText(TableHelper.optStringField(table, (String)"json", null));
        if (nbt == null && (nbt = NBTUtil.fromBinary(TableHelper.optStringField(table, (String)"tag", null))) == null) {
            nbt = ItemUtil.parseNBTHashRS(stack, table, items);
        }
        return nbt;
    }

    private static CompoundNBT parseNBTHashRS(ItemStack stack, Map<?, ?> table, List<ItemStack> items) throws LuaException {
        String nbt = TableHelper.optStringField(table, (String)"nbt", null);
        if (nbt == null || nbt.isEmpty()) {
            return null;
        }
        CompoundNBT tag = RefinedStorage.findMatchingTag(stack, nbt, items);
        if (tag != null) {
            return tag;
        }
        tag = new CompoundNBT();
        return tag;
    }

    public static ItemStack makeTurtle(Item turtle, String upgrade) {
        ItemStack stack = new ItemStack((IItemProvider)turtle);
        stack.func_196082_o().func_74778_a("RightUpgrade", upgrade);
        return stack;
    }

    public static ItemStack makePocket(Item turtle, String upgrade) {
        ItemStack stack = new ItemStack((IItemProvider)turtle);
        stack.func_196082_o().func_74778_a("Upgrade", upgrade);
        return stack;
    }
}

