/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="advancedperipherals")
public class ChunkManager
extends WorldSavedData {
    private static final String DATA_NAME = "advancedperipherals_ForcedChunks";
    private static final String FORCED_CHUNKS_TAG = "forcedChunks";
    private static int tickCounter = 0;
    private final Map<UUID, LoadChunkRecord> forcedChunks = new HashMap<UUID, LoadChunkRecord>();
    private boolean initialized = false;

    public ChunkManager() {
        super(DATA_NAME);
    }

    @NotNull
    public static ChunkManager get(@NotNull ServerWorld world) {
        return (ChunkManager)world.func_217481_x().func_215752_a(ChunkManager::new, DATA_NAME);
    }

    @SubscribeEvent
    public static void beforeServerStopped(FMLServerStoppingEvent event) {
        ChunkManager.get(event.getServer().func_241755_D_()).stop();
    }

    @SubscribeEvent
    public static void afterServerStarted(FMLServerStartedEvent event) {
        ChunkManager.get(event.getServer().func_241755_D_()).init();
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++tickCounter % ((Integer)APConfig.PERIPHERALS_CONFIG.CHUNK_LOAD_VALID_TIME.get() / 2) == 0) {
            ChunkManager.get(ServerLifecycleHooks.getCurrentServer().func_241755_D_()).cleanup();
        }
    }

    public synchronized boolean addForceChunk(ServerWorld world, UUID owner, ChunkPos pos) {
        AdvancedPeripherals.debug("Trying to load forced chunk " + pos, Level.WARN);
        if (this.forcedChunks.containsKey(owner)) {
            throw new IllegalArgumentException(String.format("You need to cleanup force loaded chunk for %s first", owner));
        }
        this.forcedChunks.put(owner, new LoadChunkRecord(world.func_234923_W_().func_240901_a_().toString(), pos));
        this.func_76185_a();
        return ForgeChunkManager.forceChunk((ServerWorld)world, (String)"advancedperipherals", (UUID)owner, (int)pos.field_77276_a, (int)pos.field_77275_b, (boolean)true, (boolean)true);
    }

    public synchronized void touch(UUID owner) {
        if (this.forcedChunks.containsKey(owner)) {
            this.forcedChunks.get(owner).touch();
        }
    }

    public synchronized boolean removeForceChunk(ServerWorld world, UUID owner, ChunkPos pos) {
        AdvancedPeripherals.debug("Trying to unload forced chunk " + pos, Level.WARN);
        if (!this.forcedChunks.containsKey(owner)) {
            return true;
        }
        LoadChunkRecord record = this.forcedChunks.get(owner);
        String dimensionName = world.func_234923_W_().func_240901_a_().toString();
        if (!record.getDimensionName().equals(dimensionName)) {
            throw new IllegalArgumentException(String.format("Incorrect dimension! Should be %s instead of %s", record.getDimensionName(), dimensionName));
        }
        boolean result = ForgeChunkManager.forceChunk((ServerWorld)world, (String)"advancedperipherals", (UUID)owner, (int)pos.field_77276_a, (int)pos.field_77275_b, (boolean)false, (boolean)true);
        if (result) {
            this.forcedChunks.remove(owner);
            this.func_76185_a();
        }
        return result;
    }

    public synchronized void init() {
        if (!this.initialized) {
            AdvancedPeripherals.debug("Schedule chunk manager init", Level.WARN);
            ServerLifecycleHooks.getCurrentServer().func_212370_w().forEach(world -> {
                String dimensionName = world.func_234923_W_().func_240901_a_().toString();
                this.forcedChunks.entrySet().stream().filter(entry -> ((LoadChunkRecord)entry.getValue()).getDimensionName().equals(dimensionName)).forEach(entry -> ForgeChunkManager.forceChunk((ServerWorld)world, (String)"advancedperipherals", (UUID)((UUID)entry.getKey()), (int)((LoadChunkRecord)entry.getValue()).getPos().field_77276_a, (int)((LoadChunkRecord)entry.getValue()).getPos().field_77275_b, (boolean)true, (boolean)true));
            });
            this.initialized = true;
        }
    }

    public synchronized void stop() {
        if (this.initialized) {
            AdvancedPeripherals.debug("Schedule chunk manager stop", Level.WARN);
            ServerLifecycleHooks.getCurrentServer().func_212370_w().forEach(world -> {
                String dimensionName = world.func_234923_W_().func_240901_a_().toString();
                this.forcedChunks.entrySet().stream().filter(entry -> ((LoadChunkRecord)entry.getValue()).getDimensionName().equals(dimensionName)).forEach(entry -> ForgeChunkManager.forceChunk((ServerWorld)world, (String)"advancedperipherals", (UUID)((UUID)entry.getKey()), (int)((LoadChunkRecord)entry.getValue()).getPos().field_77276_a, (int)((LoadChunkRecord)entry.getValue()).getPos().field_77275_b, (boolean)false, (boolean)true));
            });
            this.initialized = false;
        }
    }

    public synchronized void cleanup() {
        AdvancedPeripherals.debug("Schedule chunk manager cleanup", Level.WARN);
        ServerLifecycleHooks.getCurrentServer().func_212370_w().forEach(world -> {
            String dimensionName = world.func_234923_W_().func_240901_a_().toString();
            ArrayList purgeList = new ArrayList();
            this.forcedChunks.entrySet().stream().filter(entry -> ((LoadChunkRecord)entry.getValue()).getDimensionName().equals(dimensionName) && !((LoadChunkRecord)entry.getValue()).isValid()).forEach(entry -> purgeList.add(entry.getKey()));
            purgeList.forEach(uuid -> {
                AdvancedPeripherals.debug(String.format("Purge forced chunk for %s", uuid), Level.WARN);
                this.removeForceChunk((ServerWorld)world, (UUID)uuid, this.forcedChunks.get(uuid).getPos());
            });
        });
    }

    public void func_76184_a(@NotNull CompoundNBT data) {
        CompoundNBT forcedData = data.func_74775_l(FORCED_CHUNKS_TAG);
        for (String key : forcedData.func_150296_c()) {
            this.forcedChunks.put(UUID.fromString(key), LoadChunkRecord.deserialize(forcedData.func_74775_l(key)));
        }
    }

    @NotNull
    public CompoundNBT func_189551_b(@NotNull CompoundNBT data) {
        CompoundNBT forcedChunksTag = new CompoundNBT();
        this.forcedChunks.forEach((key, value) -> forcedChunksTag.func_218657_a(key.toString(), (INBT)value.serialize()));
        return data;
    }

    private static class LoadChunkRecord {
        private static final String POS_TAG = "pos";
        private static final String DIMENSION_NAME_TAG = "dimensionName";
        @NotNull
        private final String dimensionName;
        @NotNull
        private final ChunkPos pos;
        private long lastTouch;

        public LoadChunkRecord(@NotNull String dimensionName, @NotNull ChunkPos pos) {
            this.dimensionName = dimensionName;
            this.pos = pos;
            this.lastTouch = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
        }

        public static LoadChunkRecord deserialize(@NotNull CompoundNBT tag) {
            return new LoadChunkRecord(tag.func_74779_i(DIMENSION_NAME_TAG), NBTUtil.chunkPosFromNBT(tag.func_74775_l(POS_TAG)));
        }

        @NotNull
        public ChunkPos getPos() {
            return this.pos;
        }

        @NotNull
        public String getDimensionName() {
            return this.dimensionName;
        }

        public void touch() {
            this.lastTouch = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
        }

        public boolean isValid() {
            long currentEpoch = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
            return this.lastTouch + (long)((Integer)APConfig.PERIPHERALS_CONFIG.CHUNK_LOAD_VALID_TIME.get()).intValue() >= currentEpoch;
        }

        @NotNull
        public CompoundNBT serialize() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a(DIMENSION_NAME_TAG, this.dimensionName);
            tag.func_218657_a(POS_TAG, (INBT)NBTUtil.toNBT(this.pos));
            return tag;
        }
    }
}

