/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.items;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.client.HudOverlayHandler;
import de.srendi.advancedperipherals.common.addons.curios.CuriosHelper;
import de.srendi.advancedperipherals.common.blocks.tileentity.ARControllerTile;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.setup.Blocks;
import de.srendi.advancedperipherals.common.util.EnumColor;
import de.srendi.advancedperipherals.common.util.SideHelper;
import de.srendi.advancedperipherals.network.MNetwork;
import de.srendi.advancedperipherals.network.messages.RequestHudCanvasMessage;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class ARGogglesItem
extends ArmorItem {
    private static final String CONTROLLER_POS = "controller_pos";
    private static final String CONTROLLER_WORLD = "controller_world";

    public ARGogglesItem() {
        super((IArmorMaterial)ArmorMaterial.LEATHER, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(AdvancedPeripherals.TAB).func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick(ClientPlayerEntity player, ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(CONTROLLER_POS) && stack.func_77978_p().func_74764_b(CONTROLLER_WORLD)) {
            World world;
            int[] arr = stack.func_77978_p().func_74759_k(CONTROLLER_POS);
            if (arr.length < 3) {
                return;
            }
            BlockPos pos = new BlockPos(arr[0], arr[1], arr[2]);
            String dimensionKey = stack.func_77978_p().func_74779_i(CONTROLLER_WORLD);
            if (!dimensionKey.equals((world = player.field_70170_p).func_234923_W_().toString())) {
                MNetwork.sendToServer(new RequestHudCanvasMessage(pos, dimensionKey));
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof ARControllerTile)) {
                MNetwork.sendToServer(new RequestHudCanvasMessage(pos, dimensionKey));
                return;
            }
            ARControllerTile controller = (ARControllerTile)te;
            HudOverlayHandler.updateCanvas(controller.getCanvas());
        }
    }

    public ITextComponent func_200296_o() {
        return new TranslationTextComponent("item.advancedperipherals.tooltip.ar_goggles");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)341)) {
            tooltip.add(EnumColor.buildTextComponent((ITextComponent)new TranslationTextComponent("item.advancedperipherals.tooltip.show_desc")));
        } else {
            tooltip.add(EnumColor.buildTextComponent(this.func_200296_o()));
        }
        if (!((Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_AR_GOGGLES.get()).booleanValue()) {
            tooltip.add(EnumColor.buildTextComponent((ITextComponent)new TranslationTextComponent("item.advancedperipherals.tooltip.disabled")));
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b(CONTROLLER_POS, 11)) {
            int[] pos = stack.func_77978_p().func_74759_k(CONTROLLER_POS);
            tooltip.add((ITextComponent)new TranslationTextComponent("item.advancedperipherals.tooltip.ar_goggles.binding", new Object[]{pos[0], pos[1], pos[2]}));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        if (!AdvancedPeripherals.isCuriosLoaded()) {
            return null;
        }
        return CuriosHelper.createARGogglesProvider(stack);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "advancedperipherals:textures/models/ar_goggles.png";
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!SideHelper.isClientPlayer((LivingEntity)player)) {
            return;
        }
        ARGogglesItem.clientTick((ClientPlayerEntity)player, stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        World world = context.func_195991_k();
        if (!world.func_180495_p(blockpos).func_203425_a((Block)Blocks.AR_CONTROLLER.get())) {
            return super.func_195939_a(context);
        }
        TileEntity entity = world.func_175625_s(blockpos);
        if (!(entity instanceof ARControllerTile)) {
            return super.func_195939_a(context);
        }
        ARControllerTile controller = (ARControllerTile)entity;
        if (!context.func_195991_k().field_72995_K) {
            ItemStack item = context.func_195996_i();
            if (!item.func_77942_o()) {
                item.func_77982_d(new CompoundNBT());
            }
            CompoundNBT nbt = item.func_77978_p();
            BlockPos pos = controller.func_174877_v();
            nbt.func_74783_a(CONTROLLER_POS, new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
            nbt.func_74778_a(CONTROLLER_WORLD, controller.func_145831_w().func_234923_W_().toString());
            item.func_77982_d(nbt);
        }
        context.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("text.advancedperipherals.linked_goggles"), true);
        return ActionResultType.SUCCESS;
    }
}

