/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.tileentity;

import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.tile.config.IRedstoneConfigurable;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.RsBridgePeripheral;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorageNode;
import de.srendi.advancedperipherals.common.setup.TileEntityTypes;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RsBridgeTile
extends NetworkNodeTile<RefinedStorageNode>
implements INetworkNodeProxy<RefinedStorageNode>,
IRedstoneConfigurable,
IPeripheralTileEntity {
    private static final String PERIPHERAL_SETTINGS = "AP_SETTINGS";
    protected CompoundNBT peripheralSettings;
    protected RsBridgePeripheral peripheral = new RsBridgePeripheral(this);
    private LazyOptional<IPeripheral> peripheralCap;

    public RsBridgeTile() {
        super((TileEntityType)TileEntityTypes.RS_BRIDGE.get());
        this.peripheralSettings = new CompoundNBT();
    }

    @NotNull
    public <T1> LazyOptional<T1> getCapability(@NotNull Capability<T1> cap, @Nullable Direction direction) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheral.isEnabled()) {
                if (this.peripheralCap == null) {
                    this.peripheralCap = LazyOptional.of(() -> this.peripheral);
                }
                return this.peripheralCap.cast();
            }
            AdvancedPeripherals.debug(this.peripheral.getType() + " is disabled, you can enable it in the Configuration.");
        }
        return super.getCapability(cap, direction);
    }

    public RefinedStorageNode createNode(World world, BlockPos blockPos) {
        return new RefinedStorageNode(world, blockPos);
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.peripheralSettings.isEmpty()) {
            compound.func_218657_a(PERIPHERAL_SETTINGS, (INBT)this.peripheralSettings);
        }
        return compound;
    }

    public void func_230337_a_(@NotNull BlockState state, CompoundNBT compound) {
        this.peripheralSettings = compound.func_74775_l(PERIPHERAL_SETTINGS);
        super.func_230337_a_(state, compound);
    }

    @Override
    public CompoundNBT getPeripheralSettings() {
        return this.peripheralSettings;
    }

    @Override
    public void markSettingsChanged() {
        this.func_70296_d();
    }
}

