/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.common.addons.storagedrawers.DrawerItemHandler;
import de.srendi.advancedperipherals.common.util.InventoryUtil;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DrawerIntegration
extends TileEntityIntegrationPeripheral<TileEntityDrawers> {
    public DrawerIntegration(TileEntity entity) {
        super(entity);
    }

    @NotNull
    public String getType() {
        return "standardDrawer";
    }

    @LuaFunction
    public final MethodResult drawerAttributes() {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        IDrawerAttributes attributes = ((TileEntityDrawers)this.tileEntity).getDrawerAttributes();
        data.put("showingQuantity", attributes.isShowingQuantity());
        data.put("voiding", attributes.isVoid());
        data.put("unlimitedStorage", attributes.isUnlimitedStorage());
        return MethodResult.of(data);
    }

    @LuaFunction
    public final MethodResult size() {
        return MethodResult.of((Object)((TileEntityDrawers)this.tileEntity).getGroup().getDrawerCount());
    }

    @LuaFunction
    public final MethodResult list() {
        HashMap<Integer, 1> data = new HashMap<Integer, 1>();
        IDrawerGroup group = ((TileEntityDrawers)this.tileEntity).getGroup();
        for (int slot = 0; slot < group.getDrawerCount(); ++slot) {
            final IDrawer drawer = group.getDrawer(slot);
            if (drawer.isEmpty()) continue;
            data.put(slot + 1, new HashMap<String, Object>(){
                {
                    this.put("count", drawer.getStoredItemCount());
                    ResourceLocation registryName = drawer.getStoredItemPrototype().func_77973_b().getRegistryName();
                    if (registryName != null) {
                        this.put("name", registryName.toString());
                    } else {
                        this.put("name", "unknown");
                    }
                }
            });
        }
        return MethodResult.of(data);
    }

    @LuaFunction
    public final MethodResult getItemDetail(int slot) {
        int javaSlot = slot - 1;
        IDrawerGroup group = ((TileEntityDrawers)this.tileEntity).getGroup();
        if (javaSlot >= group.getDrawerCount()) {
            return MethodResult.of((Object[])new Object[]{null, "Slot is out of range"});
        }
        IDrawer drawer = group.getDrawer(javaSlot);
        if (drawer.isEmpty()) {
            return MethodResult.of(new HashMap());
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        ItemStack storedItem = drawer.getStoredItemPrototype();
        data.put("count", drawer.getStoredItemCount());
        data.put("displayName", storedItem.func_151000_E().getString());
        ResourceLocation registryName = drawer.getStoredItemPrototype().func_77973_b().getRegistryName();
        if (registryName != null) {
            data.put("name", registryName.toString());
        } else {
            data.put("name", "unknown");
        }
        data.put("tags", storedItem.func_77973_b().getTags());
        data.put("maxCount", drawer.getMaxCapacity(storedItem));
        return MethodResult.of(data);
    }

    @LuaFunction
    public final MethodResult getItemLimit(int slot) {
        int javaSlot = slot - 1;
        IDrawerGroup group = ((TileEntityDrawers)this.tileEntity).getGroup();
        if (javaSlot >= group.getDrawerCount()) {
            return MethodResult.of((Object[])new Object[]{null, "Slot is out of range"});
        }
        IDrawer drawer = group.getDrawer(javaSlot);
        if (drawer.isEmpty()) {
            return MethodResult.of((Object)drawer.getMaxCapacity());
        }
        return MethodResult.of((Object)drawer.getMaxCapacity(drawer.getStoredItemPrototype()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult pushItems(@Nonnull IComputerAccess access, @Nonnull IArguments arguments) throws LuaException {
        return InventoryUtil.pushItems(arguments, access, new DrawerItemHandler(((TileEntityDrawers)this.tileEntity).getGroup()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult pullItems(@Nonnull IComputerAccess access, @Nonnull IArguments arguments) throws LuaException {
        return InventoryUtil.pullItems(arguments, access, new DrawerItemHandler(((TileEntityDrawers)this.tileEntity).getGroup()));
    }
}

