/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.item.AEItemStack;
import com.google.common.collect.UnmodifiableIterator;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AppEngApi;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.CraftJob;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.InventoryUtil;
import de.srendi.advancedperipherals.common.util.ItemUtil;
import de.srendi.advancedperipherals.common.util.ServerWorker;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.owner.TileEntityPeripheralOwner;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class MeBridgePeripheral
extends BasePeripheral<TileEntityPeripheralOwner<?>> {
    public static final String TYPE = "meBridge";
    private final IActionSource source;
    private IGridNode node;

    public MeBridgePeripheral(IActionSource source, PeripheralTileEntity<?> tileEntity) {
        super(TYPE, new TileEntityPeripheralOwner(tileEntity));
        this.source = source;
    }

    public void setNode(IGridNode node) {
        this.node = node;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_ME_BRIDGE.get();
    }

    protected int _exportItem(@NotNull IArguments arguments, @NotNull IItemHandler targetInventory) throws LuaException {
        AppEngApi appEngApi = AppEngApi.getInstance();
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(appEngApi.getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ItemStack stack = ItemUtil.getItemStack(arguments.getTable(0), (IMEMonitor<IAEItemStack>)monitor);
        AEItemStack targetStack = AEItemStack.fromItemStack((ItemStack)stack);
        if (targetStack == null) {
            throw new LuaException("Illegal AE2 state ...");
        }
        IAEItemStack extracted = (IAEItemStack)monitor.extractItems((IAEStack)targetStack, Actionable.SIMULATE, this.source);
        if (extracted == null) {
            throw new LuaException("Item " + stack + " does not exists in the ME system or the system is offline");
        }
        int transferableAmount = (int)extracted.getStackSize();
        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)extracted.createItemStack(), (boolean)true);
        if (!remaining.func_190926_b()) {
            transferableAmount -= remaining.func_190916_E();
        }
        if (transferableAmount == 0) {
            return transferableAmount;
        }
        targetStack.setStackSize((long)transferableAmount);
        extracted = (IAEItemStack)monitor.extractItems((IAEStack)targetStack, Actionable.MODULATE, this.source);
        remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)extracted.createItemStack(), (boolean)false);
        if (!remaining.func_190926_b()) {
            monitor.injectItems((IAEStack)AEItemStack.fromItemStack((ItemStack)remaining), Actionable.MODULATE, this.source);
        }
        return transferableAmount;
    }

    protected int _importItem(@NotNull IArguments arguments, @NotNull IItemHandler targetInventory) throws LuaException {
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ItemStack stack = ItemUtil.getItemStack(arguments.getTable(0), (IMEMonitor<IAEItemStack>)monitor);
        AEItemStack aeStack = AEItemStack.fromItemStack((ItemStack)stack);
        if (aeStack == null) {
            throw new LuaException("Illegal AE2 state ...");
        }
        IAEItemStack remaining = (IAEItemStack)monitor.injectItems((IAEStack)aeStack, Actionable.SIMULATE, this.source);
        if (remaining != null && remaining.getStackSize() != 0L) {
            aeStack.setStackSize(aeStack.getStackSize() - remaining.getStackSize());
        }
        if (aeStack.getStackSize() == 0L) {
            return 0;
        }
        int amount = (int)aeStack.getStackSize();
        int transferableAmount = 0;
        for (int i = 0; i < targetInventory.getSlots(); ++i) {
            if (!targetInventory.getStackInSlot(i).func_77969_a(stack)) continue;
            AEItemStack cStack = AEItemStack.fromItemStack((ItemStack)targetInventory.getStackInSlot(i));
            int countInSlot = targetInventory.getStackInSlot(i).func_190916_E();
            int extractCount = Math.min(countInSlot, amount);
            IAEItemStack extractionStack = cStack.copy();
            extractionStack.setStackSize((long)extractCount);
            remaining = (IAEItemStack)monitor.injectItems((IAEStack)extractionStack, Actionable.MODULATE, this.source);
            if (remaining != null) {
                extractCount = (int)((long)extractCount - remaining.getStackSize());
            }
            targetInventory.extractItem(i, extractCount, false);
            transferableAmount += extractCount;
        }
        return transferableAmount;
    }

    @LuaFunction
    public final MethodResult craftItem(IComputerAccess computer, IArguments arguments) throws LuaException {
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ItemStack itemToCraft = ItemUtil.getItemStack(arguments.getTable(0), (IMEMonitor<IAEItemStack>)monitor);
        if (itemToCraft.func_190926_b()) {
            throw new LuaException("Item " + itemToCraft + " does not exists");
        }
        CraftJob job = new CraftJob(((TileEntityPeripheralOwner)this.owner).getWorld(), computer, this.node, itemToCraft, this.source);
        ServerWorker.add(job::startCrafting);
        return MethodResult.pullEvent((String)"crafting", (ILuaCallback)job);
    }

    @LuaFunction(mainThread=true)
    public final double getEnergyUsage() {
        return ((IEnergyGrid)this.node.getGrid().getCache(IEnergyGrid.class)).getAvgPowerUsage();
    }

    @LuaFunction(mainThread=true)
    public final double getEnergyStorage() {
        return ((IEnergyGrid)this.node.getGrid().getCache(IEnergyGrid.class)).getStoredPower();
    }

    @LuaFunction(mainThread=true)
    public final double getMaxEnergyStorage() {
        return ((IEnergyGrid)this.node.getGrid().getCache(IEnergyGrid.class)).getMaxStoredPower();
    }

    @LuaFunction(mainThread=true)
    public final boolean isItemCrafting(IArguments arguments) throws LuaException {
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ICraftingGrid grid = (ICraftingGrid)this.node.getGrid().getCache(ICraftingGrid.class);
        return grid.isRequesting(AppEngApi.getInstance().findAEStackFromItemStack((IMEMonitor<IAEItemStack>)monitor, ItemUtil.getItemStack(arguments.getTable(0), (IMEMonitor<IAEItemStack>)monitor)));
    }

    @LuaFunction(mainThread=true)
    public final boolean isItemCraftable(IArguments arguments) throws LuaException {
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        return AppEngApi.getInstance().findAEStackFromItemStack((IMEMonitor<IAEItemStack>)monitor, ItemUtil.getItemStack(arguments.getTable(0), (IMEMonitor<IAEItemStack>)monitor)).isCraftable();
    }

    @LuaFunction(mainThread=true)
    public final int exportItem(@NotNull IArguments arguments) throws LuaException {
        IItemHandler inventory = InventoryUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        return this._exportItem(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final int exportItemToPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        IItemHandler inventory = InventoryUtil.getHandlerFromName(computer, arguments.getString(1));
        return this._exportItem(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final int importItem(IArguments arguments) throws LuaException {
        IItemHandler inventory = InventoryUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        return this._importItem(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final int importItemFromPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        IItemHandler inventory = InventoryUtil.getHandlerFromName(computer, arguments.getString(1));
        return this._importItem(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getItem(IArguments arguments) throws LuaException {
        AppEngApi INSTANCE = AppEngApi.getInstance();
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(INSTANCE.getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ItemStack stack = ItemUtil.getItemStack(arguments.getTable(0), (IMEMonitor<IAEItemStack>)monitor);
        AEItemStack aeStack = AEItemStack.fromItemStack((ItemStack)stack);
        if (aeStack == null) {
            return MethodResult.of((Object[])new Object[]{null, "Cannot determinate item for search"});
        }
        for (IAEItemStack potentialStack : monitor.getStorageList()) {
            if (!potentialStack.isSameType((IAEItemStack)aeStack)) continue;
            return MethodResult.of(INSTANCE.getMapFromStack(potentialStack));
        }
        aeStack.setStackSize(0L);
        return MethodResult.of(INSTANCE.getMapFromStack((IAEItemStack)aeStack));
    }

    @LuaFunction(mainThread=true)
    public final Object[] listItems() {
        IMEMonitor inventory = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        return new Object[]{AppEngApi.getInstance().iteratorToMapStack(inventory.getStorageList().iterator(), 0)};
    }

    @LuaFunction(mainThread=true)
    public final Object[] listCraftableItems() {
        IMEMonitor inventory = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        return new Object[]{AppEngApi.getInstance().iteratorToMapStack(inventory.getStorageList().iterator(), 2)};
    }

    @LuaFunction(mainThread=true)
    public final Object[] listFluid() {
        IMEMonitor inventory = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IFluidStorageChannel.class));
        return new Object[]{AppEngApi.getInstance().iteratorToMapFluid(inventory.getStorageList().iterator(), 0)};
    }

    @LuaFunction(mainThread=true)
    public final Object[] listCraftableFluid() {
        IMEMonitor inventory = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IFluidStorageChannel.class));
        return new Object[]{AppEngApi.getInstance().iteratorToMapFluid(inventory.getStorageList().iterator(), 2)};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getCraftingCPUs() throws LuaException {
        ICraftingGrid grid = (ICraftingGrid)this.node.getGrid().getCache(ICraftingGrid.class);
        if (grid == null) {
            throw new LuaException("Not connected");
        }
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        UnmodifiableIterator iterator = grid.getCpus().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        int i = 1;
        while (iterator.hasNext()) {
            Object o = AppEngApi.getInstance().getObjectFromCPU((ICraftingCPU)iterator.next());
            if (o == null) continue;
            map.put(i++, o);
        }
        return new Object[]{map};
    }
}

