/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.integrations;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.integrations.BeaconIntegration;
import de.srendi.advancedperipherals.common.addons.computercraft.integrations.BlockIntegration;
import de.srendi.advancedperipherals.common.addons.computercraft.integrations.NoteblockIntegration;
import de.srendi.advancedperipherals.common.addons.computercraft.integrations.TileEntityIntegration;
import de.srendi.advancedperipherals.common.util.Platform;
import de.srendi.advancedperipherals.lib.integrations.IPeripheralIntegration;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.util.Comparator;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.Function;
import net.minecraft.block.NoteBlock;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class IntegrationPeripheralProvider
implements IPeripheralProvider {
    public static final String[] SUPPORTED_MODS = new String[]{"mekanismgenerators", "mekanism", "botania", "immersiveengineering", "integrateddynamics", "storagedrawers", "create", "draconicevolution"};
    public static final PriorityQueue<IPeripheralIntegration> integrations = new PriorityQueue<IPeripheralIntegration>(Comparator.comparingInt(IPeripheralIntegration::getPriority));

    public static void registerIntegration(IPeripheralIntegration integration) {
        integrations.add(integration);
    }

    public static <T extends TileEntity> void registerTileEntityIntegration(Function<TileEntity, TileEntityIntegrationPeripheral<T>> integration, Class<T> tileClass) {
        IntegrationPeripheralProvider.registerIntegration(new TileEntityIntegration(integration, tileClass::isInstance));
    }

    public static <T extends TileEntity> void registerTileEntityIntegration(Function<TileEntity, TileEntityIntegrationPeripheral<T>> integration, Class<T> tileClass, int priority) {
        IntegrationPeripheralProvider.registerIntegration(new TileEntityIntegration(integration, tileClass::isInstance, priority));
    }

    public static void load() {
        IntegrationPeripheralProvider.registerIntegration(new TileEntityIntegration(BeaconIntegration::new, BeaconTileEntity.class::isInstance));
        IntegrationPeripheralProvider.registerIntegration(new BlockIntegration(NoteblockIntegration::new, NoteBlock.class::isInstance));
        for (String mod : SUPPORTED_MODS) {
            Optional<Object> integration = Platform.maybeLoadIntegration(mod, mod + ".Integration");
            integration.ifPresent(obj -> {
                AdvancedPeripherals.LOGGER.warn("Successfully loaded integration for {}", (Object)mod);
                ((Runnable)obj).run();
            });
            if (integration.isPresent()) continue;
            AdvancedPeripherals.LOGGER.warn("Failed to load integration for {}", (Object)mod);
        }
    }

    @NotNull
    public LazyOptional<IPeripheral> getPeripheral(@NotNull World world, @NotNull BlockPos blockPos, @NotNull Direction direction) {
        for (IPeripheralIntegration integration : integrations) {
            if (!integration.isSuitable(world, blockPos, direction)) continue;
            return LazyOptional.of(() -> integration.buildPeripheral(world, blockPos, direction));
        }
        return LazyOptional.empty();
    }
}

