/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.crafting.ingredients;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.setup.Configuration;

public class ChanceResult {
    public static final ChanceResult EMPTY = new ChanceResult(ItemStack.field_190927_a, 1.0f);
    private final ItemStack stack;
    private final float chance;

    public ChanceResult(ItemStack stack, float chance) {
        this.stack = stack;
        this.chance = chance;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack rollOutput(Random rand, int fortuneLevel) {
        int outputAmount = this.stack.func_190916_E();
        double fortuneBonus = (Double)Configuration.CUTTING_BOARD_FORTUNE_BONUS.get() * (double)fortuneLevel;
        for (int roll = 0; roll < this.stack.func_190916_E(); ++roll) {
            if (!((double)rand.nextFloat() > (double)this.chance + fortuneBonus)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack out = this.stack.func_77946_l();
        out.func_190920_e(outputAmount);
        return out;
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        ResourceLocation resourceLocation = this.stack.func_77973_b().getRegistryName();
        json.addProperty("item", resourceLocation.toString());
        int count = this.stack.func_190916_E();
        if (count != 1) {
            json.addProperty("count", (Number)count);
        }
        if (this.stack.func_77942_o()) {
            json.add("nbt", new JsonParser().parse(this.stack.func_77978_p().toString()));
        }
        if (this.chance != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(this.chance));
        }
        return json;
    }

    public static ChanceResult deserialize(JsonElement je) {
        if (!je.isJsonObject()) {
            throw new JsonSyntaxException("Must be a json object");
        }
        JsonObject json = je.getAsJsonObject();
        String itemId = JSONUtils.func_151200_h((JsonObject)json, (String)"item");
        int count = JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1);
        float chance = JSONUtils.func_151221_a((JsonObject)json, (String)"chance", (float)1.0f);
        ItemStack itemstack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), count);
        if (JSONUtils.func_151201_f((JsonObject)json, (String)"nbt")) {
            try {
                JsonElement element = json.get("nbt");
                itemstack.func_77982_d(JsonToNBT.func_180713_a((String)(element.isJsonObject() ? FarmersDelight.GSON.toJson(element) : JSONUtils.func_151206_a((JsonElement)element, (String)"nbt"))));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return new ChanceResult(itemstack, chance);
    }

    public void write(PacketBuffer buf) {
        buf.func_150788_a(this.getStack());
        buf.writeFloat(this.getChance());
    }

    public static ChanceResult read(PacketBuffer buf) {
        return new ChanceResult(buf.func_150791_c(), buf.readFloat());
    }
}

