/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.trashcans.TrashCans;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrashCansAdvancementProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public TrashCansAdvancementProvider(GatherDataEvent e) {
        this.generator = e.getGenerator();
    }

    public void func_200398_a(DirectoryCache hashCache) {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            Path advancementPath = TrashCansAdvancementProvider.createPath(path, advancement);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)hashCache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)advancementPath);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)advancementPath, (Object)ioexception);
            }
        };
        Advancement trash_can = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)TrashCans.item_trash_can.func_199767_j(), (ITextComponent)TextComponents.translation((String)"trashcans.advancement.trash_can.title").get(), (ITextComponent)TextComponents.translation((String)"trashcans.advancement.trash_can.description").get(), new ResourceLocation("minecraft", "textures/block/cobblestone.png"), FrameType.TASK, true, true, false).func_200270_a(IRequirementsStrategy.field_223215_b_).func_200275_a("has_trash_can", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{TrashCans.item_trash_can})).func_200275_a("has_trash_can2", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{TrashCans.liquid_trash_can})).func_200275_a("has_trash_can3", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{TrashCans.energy_trash_can})).func_203904_a(consumer, "trashcans:trash_can");
        Advancement ultimate_trash_can = Advancement.Builder.func_200278_a().func_203905_a(trash_can).func_203902_a((IItemProvider)TrashCans.ultimate_trash_can.func_199767_j(), (ITextComponent)TextComponents.translation((String)"trashcans.advancement.ultimate_trash_can.title").get(), (ITextComponent)TextComponents.translation((String)"trashcans.advancement.ultimate_trash_can.description").get(), null, FrameType.TASK, true, true, false).func_200275_a("has_trash_can", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{TrashCans.ultimate_trash_can})).func_203904_a(consumer, "trashcans:ultimate_trash_can");
    }

    private static Path createPath(Path path, Advancement advancement) {
        return path.resolve("data/" + advancement.func_192067_g().func_110624_b() + "/advancements/" + advancement.func_192067_g().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Advancements";
    }
}

