/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.render;

import com.inventorypets.entities.MiniQuantumEndermanEntity;
import com.inventorypets.models.MiniQuantumEndermanModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MiniQuantumEndermanRenderer
extends MobRenderer<MiniQuantumEndermanEntity, MiniQuantumEndermanModel<MiniQuantumEndermanEntity>> {
    private static final ResourceLocation ENDERMAN_TEXTURES = new ResourceLocation("inventorypets:textures/entity/enderman/mq_enderman.png");
    private final Random rnd = new Random();

    public MiniQuantumEndermanRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new MiniQuantumEndermanModel(0.0f), 0.2f);
    }

    protected void preRenderCallback(MiniQuantumEndermanEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        float f = 0.7f;
        matrixStackIn.func_227862_a_(f, f, f);
    }

    public void render(MiniQuantumEndermanEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        BlockState blockstate = entityIn.getHeldBlockState();
        MiniQuantumEndermanModel endermanmodel = (MiniQuantumEndermanModel)this.func_217764_d();
        endermanmodel.isCarrying = blockstate != null;
        endermanmodel.isAttacking = entityIn.isScreaming();
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public Vector3d getRenderOffset(MiniQuantumEndermanEntity entityIn, float partialTicks) {
        if (entityIn.isScreaming()) {
            return new Vector3d(this.rnd.nextGaussian() * 0.02, 0.0, this.rnd.nextGaussian() * 0.02);
        }
        return super.func_225627_b_((Entity)entityIn, partialTicks);
    }

    public ResourceLocation getEntityTexture(MiniQuantumEndermanEntity entity) {
        return ENDERMAN_TEXTURES;
    }
}

