/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.entities;

import com.inventorypets.config.InventoryPetsConfig;
import com.inventorypets.helper.ProxyHelper;
import com.inventorypets.init.ModSoundEvents;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class BedPetEntity
extends MobEntity
implements IMob {
    private static final DataParameter<Integer> PET_SIZE = EntityDataManager.func_187226_a(BedPetEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(BedPetEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;
    private int deathDelay;

    public BedPetEntity(EntityType<? extends BedPetEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(0.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FloatGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HopGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.setSlimeSize(2, true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PET_SIZE, (Object)2);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
        this.deathDelay = 2400;
    }

    protected void setSlimeSize(int size, boolean resetHealth) {
        this.field_70180_af.func_187227_b(PET_SIZE, (Object)size);
        this.func_226264_Z_();
        this.func_213323_x_();
        this.field_70728_aV = size;
    }

    public int getSlimeSize() {
        return (Integer)this.field_70180_af.func_187225_a(PET_SIZE);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Size", this.getSlimeSize() - 1);
        compound.func_74757_a("wasOnGround", this.wasOnGround);
        if (this.getOwnerId() == null) {
            compound.func_74778_a("OwnerUUID", "");
        } else {
            compound.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        String s;
        int i = compound.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        }
        this.setSlimeSize(i + 1, false);
        super.func_70037_a(compound);
        this.wasOnGround = compound.func_74767_n("wasOnGround");
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_74779_i("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1).toString();
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isSmallSlime() {
        return this.getSlimeSize() <= 1;
    }

    protected IParticleData getSquishParticle() {
        return ParticleTypes.field_197592_C;
    }

    protected boolean func_225511_J_() {
        return this.getSlimeSize() > 0;
    }

    public void func_70071_h_() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        --this.deathDelay;
        if (this.deathDelay <= 0) {
            this.func_70106_y();
        } else if (this.deathDelay == 90 || this.deathDelay == 60 || this.deathDelay == 30) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ModSoundEvents.overbell, SoundCategory.PLAYERS, 0.4f, 1.0f);
        } else if (this.deathDelay < 20) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197593_D, this.func_226277_ct_(), this.func_226278_cu_() + 2.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        if (this.field_70122_E && !this.wasOnGround) {
            this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (PET_SIZE.equals(key)) {
            this.func_213323_x_();
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(key);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        PlayerEntity entityplayer = player;
        if (itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == Blocks.field_196556_aL.func_199767_j()) {
            if (!entityplayer.field_70170_p.func_72935_r()) {
                entityplayer.func_195064_c(new EffectInstance(Effects.field_76440_q, 50, 2, false, false));
                ProxyHelper.Sleep(entityplayer);
                if (!entityplayer.func_184812_l_()) {
                    itemstack.func_190920_e(itemstack.func_190916_E() - 1);
                    if (itemstack.func_190916_E() == 0) {
                        this.removeItem(entityplayer, itemstack);
                    }
                }
            }
            if (entityplayer.field_70170_p.func_72935_r() && !entityplayer.field_70170_p.field_72995_K) {
                entityplayer.func_146105_b((ITextComponent)new TranslationTextComponent("block.minecraft.bed.no_sleep", new Object[0]), true);
            }
            return ActionResultType.SUCCESS;
        }
        if (!entityplayer.field_70170_p.field_72995_K && itemstack == ItemStack.field_190927_a) {
            if (InventoryPetsConfig.petsEatWholeItems) {
                entityplayer.func_146105_b((ITextComponent)new TranslationTextComponent("info.ip.livingbedinteracthc", new Object[0]), true);
            } else {
                entityplayer.func_146105_b((ITextComponent)new TranslationTextComponent("info.ip.livingbedinteract", new Object[0]), true);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public void removeItem(PlayerEntity ep, ItemStack removeitem) {
        PlayerInventory inventoryPlayer = ep.field_71071_by;
        for (int i = 0; i < inventoryPlayer.func_70302_i_(); ++i) {
            ItemStack j;
            if (inventoryPlayer.func_70301_a(i) == ItemStack.field_190927_a || (j = inventoryPlayer.func_70301_a(i)) == ItemStack.field_190927_a || j.func_77973_b() != removeitem.func_77973_b()) continue;
            inventoryPlayer.func_70299_a(i, ItemStack.field_190927_a);
            break;
        }
    }

    public EntityType<? extends BedPetEntity> func_200600_R() {
        return super.func_200600_R();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.625f * sizeIn.field_220316_b;
    }

    protected boolean canDamagePlayer() {
        return false;
    }

    protected float func_225512_er_() {
        return (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187897_gY;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.bed_yawn;
    }

    protected SoundEvent getSquishSound() {
        return SoundEvents.field_187554_ai;
    }

    protected ResourceLocation func_184647_J() {
        return LootTables.field_186419_a;
    }

    protected float func_70599_aP() {
        return 0.4f * (float)this.getSlimeSize();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return this.getSlimeSize() > 0;
    }

    protected void func_70664_aZ() {
        Vector3d vec3d = this.func_213322_ci();
        this.func_213293_j(vec3d.field_72450_a, this.func_175134_bD(), vec3d.field_72449_c);
        this.field_70160_al = true;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int i = this.field_70146_Z.nextInt(3);
        if (i < 2 && this.field_70146_Z.nextFloat() < 0.5f * difficultyIn.func_180170_c()) {
            ++i;
        }
        int j = 1 << i;
        this.setSlimeSize(j, true);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected SoundEvent getJumpSound() {
        return this.isSmallSlime() ? SoundEvents.field_189110_fE : SoundEvents.field_187882_fq;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn).func_220313_a(0.765f);
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    static class MoveHelperController
    extends MovementController {
        private float yRot;
        private int jumpDelay;
        private final BedPetEntity slime;
        private boolean isAggressive;

        public MoveHelperController(BedPetEntity slimeIn) {
            super((MobEntity)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.func_233570_aj_()) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(Attributes.field_233821_d_).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        if (this.slime.makesSoundOnJump()) {
                            // empty if block
                        }
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                }
            }
        }
    }

    static class HopGoal
    extends Goal {
        private final BedPetEntity slime;

        public HopGoal(BedPetEntity slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            PlayerEntity entityplayer;
            boolean chkPlayer = false;
            if (this.slime.func_70638_az() != null && this.slime.func_70638_az() instanceof PlayerEntity && (entityplayer = (PlayerEntity)this.slime.func_70638_az()) != null) {
                int x = (int)entityplayer.func_226277_ct_();
                int z = (int)entityplayer.func_226281_cx_();
                int thisx = (int)this.slime.func_226277_ct_();
                int thisz = (int)this.slime.func_226281_cx_();
                chkPlayer = Math.abs(thisx - x) >= 3 || Math.abs(thisz - z) >= 3;
            }
            return chkPlayer;
        }

        public void func_75246_d() {
            if (this.slime.func_70605_aq() instanceof MoveHelperController) {
                ((MoveHelperController)this.slime.func_70605_aq()).setSpeed(1.0);
            }
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final BedPetEntity slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(BedPetEntity slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(Effects.field_188424_y)) && this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            if (this.slime.func_70605_aq() instanceof MoveHelperController) {
                ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
            }
        }
    }

    static class FloatGoal
    extends Goal {
        private final BedPetEntity slime;

        public FloatGoal(BedPetEntity slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slimeIn.func_70661_as().func_212239_d(true);
        }

        public boolean func_75250_a() {
            return (this.slime.func_70090_H() || this.slime.func_180799_ab()) && this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            if (this.slime.func_70605_aq() instanceof MoveHelperController) {
                ((MoveHelperController)this.slime.func_70605_aq()).setSpeed(1.2);
            }
        }
    }

    static class AttackGoal
    extends Goal {
        private final BedPetEntity slime;
        private int growTieredTimer;

        public AttackGoal(BedPetEntity slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.slime.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a ? false : this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.slime.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            if (this.slime.func_70605_aq() instanceof MoveHelperController) {
                ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.canDamagePlayer());
            }
        }
    }
}

