/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;

public class ModelUtils {
    private static final Random rnd = new Random(1234L);

    public static void renderModel(IRenderTypeBuffer buffer, World world, BlockPos pos, BlockState state, ResourceLocation modelLoc, MatrixStack stack, int combinedLight, int combinedOverlay) {
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)state, (boolean)false));
        IBakedModel model = Minecraft.func_71410_x().func_209506_al().getModel(modelLoc);
        IModelData data = model.getModelData((IBlockDisplayReader)world, pos, state, ModelDataManager.getModelData((World)world, (BlockPos)pos));
        for (BakedQuad quad : model.getQuads(state, null, rnd, data)) {
            vertexBuilder.addVertexData(stack.func_227866_c_(), quad, 1.0f, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, true);
        }
    }

    public static void renderModel(IVertexBuilder vertexBuilder, World world, BlockPos pos, BlockState state, ResourceLocation modelLoc, MatrixStack stack, int combinedLight, int combinedOverlay) {
        ModelUtils.renderModel(vertexBuilder, world, pos, state, modelLoc, stack, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, combinedLight, combinedOverlay);
    }

    public static void renderModel(IVertexBuilder vertexBuilder, World world, BlockPos pos, BlockState state, ResourceLocation modelLoc, MatrixStack stack, float[] argb, int combinedLight, int combinedOverlay) {
        IBakedModel model = Minecraft.func_71410_x().func_209506_al().getModel(modelLoc);
        IModelData data = model.getModelData((IBlockDisplayReader)world, pos, state, ModelDataManager.getModelData((World)world, (BlockPos)pos));
        for (BakedQuad quad : model.getQuads(state, null, rnd, data)) {
            vertexBuilder.addVertexData(stack.func_227866_c_(), quad, argb[1], argb[2], argb[3], argb[0], combinedLight, combinedOverlay, true);
        }
    }
}

