/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools.debugging;

import com.ma.ManaAndArtifice;
import com.ma.Registries;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Shape;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.spells.ComponentRecipe;
import com.ma.recipes.spells.ShapeRecipe;
import com.ma.spells.crafting.SpellRecipe;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.RecipeManager;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class SpellBalanceCalculator {
    public static void calculateMinMaxComplexityPerTier() {
        for (int i = 1; i <= 5; ++i) {
            List<Shape> tierShapes = SpellBalanceCalculator.getShapesForTier(i);
            List<Component> tierComponents = SpellBalanceCalculator.getComponentsForTier(i);
            float min = SpellBalanceCalculator.calculateMinComplexity(tierShapes, tierComponents);
            float max = SpellBalanceCalculator.calculateMaxComplexity(tierShapes, tierComponents);
            float avg = SpellBalanceCalculator.calculateAverageDefaultComplexity(tierShapes, tierComponents);
            ManaAndArtifice.LOGGER.debug(String.format("Tier %d min complexity %.2f max complexity %.2f avg baseline complexity %.2f", i, Float.valueOf(min), Float.valueOf(max), Float.valueOf(avg)));
        }
    }

    private static float calculateMinComplexity(List<Shape> shapes, List<Component> components) {
        MutableFloat minComplexity = new MutableFloat(9999999.0f);
        shapes.forEach(s -> components.forEach(c -> {
            SpellRecipe sr = new SpellRecipe();
            sr.setShape((Shape)s);
            sr.addComponent((Component)c);
            if (sr.getComplexity() < minComplexity.getValue().floatValue()) {
                minComplexity.setValue(sr.getComplexity());
            }
        }));
        return minComplexity.getValue().floatValue();
    }

    private static float calculateMaxComplexity(List<Shape> shapes, List<Component> components) {
        MutableFloat maxComplexity = new MutableFloat(0.0f);
        shapes.forEach(s -> components.forEach(c -> {
            SpellRecipe sr = new SpellRecipe();
            sr.setShape((Shape)s);
            sr.addComponent((Component)c);
            sr.maximize();
            if (sr.getComplexity() > maxComplexity.getValue().floatValue()) {
                maxComplexity.setValue(sr.getComplexity());
            }
        }));
        return maxComplexity.getValue().floatValue();
    }

    private static float calculateAverageDefaultComplexity(List<Shape> shapes, List<Component> components) {
        MutableFloat complexity = new MutableFloat(0.0f);
        MutableInt count = new MutableInt(0);
        shapes.forEach(s -> components.forEach(c -> {
            SpellRecipe sr = new SpellRecipe();
            sr.setShape((Shape)s);
            sr.addComponent((Component)c);
            complexity.add(sr.getComplexity());
            count.add(1);
        }));
        int c = count.getValue();
        if (c == 0) {
            c = 1;
        }
        return complexity.getValue().floatValue() / (float)c;
    }

    private static List<Shape> getShapesForTier(int tier) {
        Minecraft mc = Minecraft.func_71410_x();
        RecipeManager rm = mc.field_71441_e.func_199532_z();
        return rm.func_199510_b().stream().filter(r -> r.func_222127_g() == RecipeInit.SHAPE_TYPE).map(r -> (ShapeRecipe)r).filter(r -> r.getTier() <= tier).map(r -> (Shape)Registries.Shape.getValue(r.func_199560_c())).filter(r -> r != null).collect(Collectors.toList());
    }

    private static List<Component> getComponentsForTier(int tier) {
        Minecraft mc = Minecraft.func_71410_x();
        RecipeManager rm = mc.field_71441_e.func_199532_z();
        return rm.func_199510_b().stream().filter(r -> r.func_222127_g() == RecipeInit.COMPONENT_TYPE).map(r -> (ComponentRecipe)r).filter(r -> r.getTier() <= tier).map(r -> (Component)Registries.Component.getValue(r.func_199560_c())).filter(r -> r != null).collect(Collectors.toList());
    }
}

