/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools;

import com.ma.api.entities.posession.PosessionActions;
import com.ma.effects.EffectInit;
import com.ma.network.messages.to_server.PossessionInputMessage;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;

public class PosessionHelper {
    public static void handleRemoteInput(PossessionInputMessage message, PlayerEntity sendingPlayer, MobEntity living) {
        switch (message.getType()) {
            case CLICK: {
                if (sendingPlayer.field_70170_p.field_72995_K) {
                    return;
                }
                if (sendingPlayer.getPersistentData().func_74764_b("posession_left_click_time")) {
                    long time = sendingPlayer.getPersistentData().func_74763_f("posession_left_click_time");
                    if (sendingPlayer.field_70170_p.func_82737_E() < time) {
                        return;
                    }
                }
                if (!PosessionActions.Invoke(living) && !PosessionActions.InvokeDefault(living)) {
                    living.func_70642_aH();
                }
                sendingPlayer.getPersistentData().func_74772_a("posession_left_click_time", sendingPlayer.field_70170_p.func_82737_E() + 30L);
                break;
            }
            case MOVEMENT: {
                boolean canFly;
                living.func_70080_a(living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), message.getYaw(), message.getPitch());
                living.func_70034_d(message.getYawHead());
                double y = 0.0;
                boolean bl = canFly = living.func_189652_ae() || living instanceof FlyingEntity || living instanceof BatEntity || living.func_70644_a((Effect)EffectInit.LEVITATION.get());
                if (message.getJump()) {
                    if (living.func_233570_aj_() && !canFly) {
                        PosessionHelper.jump((LivingEntity)living);
                    } else if (canFly) {
                        living.func_189654_d(true);
                        y = 1.0;
                    }
                } else if (message.getSneak() && canFly) {
                    if (living.func_233570_aj_()) {
                        living.func_189654_d(false);
                    }
                    y = -1.0;
                }
                living.func_70659_e((float)living.func_233637_b_(Attributes.field_233821_d_) * 0.5f);
                if (living instanceof FlyingEntity) {
                    living.func_213352_e(new Vector3d((double)message.getStrafe(), y, (double)message.getForward()));
                    break;
                }
                PosessionHelper.doTravel((LivingEntity)living, new Vector3d((double)message.getStrafe(), y, (double)message.getForward()));
                break;
            }
        }
    }

    public static void doTravel(LivingEntity ent, Vector3d travelVector) {
        double d0 = 0.08;
        d0 = ent.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get()).func_111126_e();
        boolean flag = ent.func_213322_ci().field_72448_b <= 0.0;
        FluidState fluidstate = ent.field_70170_p.func_204610_c(ent.func_233580_cy_());
        if (ent.func_70090_H() && ent.func_241208_cS_() && !ent.func_230285_a_(fluidstate.func_206886_c())) {
            double d8 = ent.func_226278_cu_();
            float f5 = ent.func_70051_ag() ? 0.9f : 0.8f;
            float f6 = 0.02f;
            float f7 = EnchantmentHelper.func_185294_d((LivingEntity)ent);
            if (f7 > 3.0f) {
                f7 = 3.0f;
            }
            if (!ent.func_233570_aj_()) {
                f7 *= 0.5f;
            }
            if (f7 > 0.0f) {
                f5 += (0.54600006f - f5) * f7 / 3.0f;
                f6 += (ent.func_70689_ay() - f6) * f7 / 3.0f;
            }
            if (ent.func_70644_a(Effects.field_206827_D)) {
                f5 = 0.96f;
            }
            ent.func_213309_a(f6 *= (float)ent.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), travelVector);
            ent.func_213315_a(MoverType.SELF, ent.func_213322_ci());
            Vector3d vector3d6 = ent.func_213322_ci();
            if (ent.field_70123_F && ent.func_70617_f_()) {
                vector3d6 = new Vector3d(vector3d6.field_72450_a, 0.2, vector3d6.field_72449_c);
            }
            ent.func_213317_d(vector3d6.func_216372_d((double)f5, (double)0.8f, (double)f5));
            Vector3d vector3d2 = ent.func_233626_a_(d0, flag, ent.func_213322_ci());
            ent.func_213317_d(vector3d2);
            if (ent.field_70123_F && ent.func_70038_c(vector3d2.field_72450_a, vector3d2.field_72448_b + (double)0.6f - ent.func_226278_cu_() + d8, vector3d2.field_72449_c)) {
                ent.func_213293_j(vector3d2.field_72450_a, (double)0.3f, vector3d2.field_72449_c);
            }
        } else if (ent.func_180799_ab() && ent.func_241208_cS_() && !ent.func_230285_a_(fluidstate.func_206886_c())) {
            double d7 = ent.func_226278_cu_();
            ent.func_213309_a(0.02f, travelVector);
            ent.func_213315_a(MoverType.SELF, ent.func_213322_ci());
            if (ent.func_233571_b_((ITag)FluidTags.field_206960_b) <= ent.func_233579_cu_()) {
                ent.func_213317_d(ent.func_213322_ci().func_216372_d(0.5, (double)0.8f, 0.5));
                Vector3d vector3d3 = ent.func_233626_a_(d0, flag, ent.func_213322_ci());
                ent.func_213317_d(vector3d3);
            } else {
                ent.func_213317_d(ent.func_213322_ci().func_186678_a(0.5));
            }
            if (!ent.func_189652_ae()) {
                ent.func_213317_d(ent.func_213322_ci().func_72441_c(0.0, -d0 / 4.0, 0.0));
            }
            Vector3d vector3d4 = ent.func_213322_ci();
            if (ent.field_70123_F && ent.func_70038_c(vector3d4.field_72450_a, vector3d4.field_72448_b + (double)0.6f - ent.func_226278_cu_() + d7, vector3d4.field_72449_c)) {
                ent.func_213293_j(vector3d4.field_72450_a, (double)0.3f, vector3d4.field_72449_c);
            }
        } else if (ent.func_184613_cA()) {
            double d10;
            double d6;
            float f2;
            Vector3d vector3d = ent.func_213322_ci();
            if (vector3d.field_72448_b > -0.5) {
                ent.field_70143_R = 1.0f;
            }
            Vector3d vector3d1 = ent.func_70040_Z();
            float f = ent.field_70125_A * ((float)Math.PI / 180);
            double d1 = Math.sqrt(vector3d1.field_72450_a * vector3d1.field_72450_a + vector3d1.field_72449_c * vector3d1.field_72449_c);
            double d3 = Math.sqrt(Entity.func_213296_b((Vector3d)vector3d));
            double d4 = vector3d1.func_72433_c();
            float f1 = MathHelper.func_76134_b((float)f);
            f1 = (float)((double)f1 * (double)f1 * Math.min(1.0, d4 / 0.4));
            vector3d = ent.func_213322_ci().func_72441_c(0.0, d0 * (-1.0 + (double)f1 * 0.75), 0.0);
            if (vector3d.field_72448_b < 0.0 && d1 > 0.0) {
                double d5 = vector3d.field_72448_b * -0.1 * (double)f1;
                vector3d = vector3d.func_72441_c(vector3d1.field_72450_a * d5 / d1, d5, vector3d1.field_72449_c * d5 / d1);
            }
            if (f < 0.0f && d1 > 0.0) {
                double d9 = d3 * (double)(-MathHelper.func_76126_a((float)f)) * 0.04;
                vector3d = vector3d.func_72441_c(-vector3d1.field_72450_a * d9 / d1, d9 * 3.2, -vector3d1.field_72449_c * d9 / d1);
            }
            if (d1 > 0.0) {
                vector3d = vector3d.func_72441_c((vector3d1.field_72450_a / d1 * d3 - vector3d.field_72450_a) * 0.1, 0.0, (vector3d1.field_72449_c / d1 * d3 - vector3d.field_72449_c) * 0.1);
            }
            ent.func_213317_d(vector3d.func_216372_d((double)0.99f, (double)0.98f, (double)0.99f));
            ent.func_213315_a(MoverType.SELF, ent.func_213322_ci());
            if (ent.field_70123_F && !ent.field_70170_p.field_72995_K && (f2 = (float)((d6 = d3 - (d10 = Math.sqrt(Entity.func_213296_b((Vector3d)ent.func_213322_ci())))) * 10.0 - 3.0)) > 0.0f) {
                ent.func_184185_a(SoundEvents.field_187655_bw, (float)((double)0.9f + Math.random() * (double)0.2f), (float)((double)0.9f + Math.random() * (double)0.2f));
                ent.func_70097_a(DamageSource.field_188406_j, f2);
            }
            if (ent.func_233570_aj_() && !ent.field_70170_p.field_72995_K) {
                ent.func_70052_a(7, false);
            }
        } else {
            BlockPos blockpos = PosessionHelper.getPositionUnderneath(ent);
            float f3 = ent.field_70170_p.func_180495_p(PosessionHelper.getPositionUnderneath(ent)).getSlipperiness((IWorldReader)ent.field_70170_p, PosessionHelper.getPositionUnderneath(ent), (Entity)ent);
            float f4 = ent.func_233570_aj_() ? f3 * 0.91f : 0.91f;
            Vector3d vector3d5 = ent.func_233633_a_(travelVector, f3);
            double d2 = vector3d5.field_72448_b;
            if (ent.func_70644_a(Effects.field_188424_y)) {
                d2 += (0.05 * (double)(ent.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - vector3d5.field_72448_b) * 0.2;
                ent.field_70143_R = 0.0f;
            } else if (ent.field_70170_p.field_72995_K && !ent.field_70170_p.func_175667_e(blockpos)) {
                d2 = ent.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
            } else if (!ent.func_189652_ae()) {
                d2 -= d0;
            }
            ent.func_213293_j(vector3d5.field_72450_a * (double)f4, d2 * (double)0.98f, vector3d5.field_72449_c * (double)f4);
        }
    }

    public static BlockPos getPositionUnderneath(LivingEntity ent) {
        return new BlockPos(ent.func_213303_ch().field_72450_a, ent.func_174813_aQ().field_72338_b - 0.5000001, ent.func_213303_ch().field_72449_c);
    }

    public static float getJumpUpwardsMotion(LivingEntity ent) {
        return 0.42f * PosessionHelper.getJumpFactor(ent);
    }

    public static void jump(LivingEntity ent) {
        float f = PosessionHelper.getJumpUpwardsMotion(ent);
        if (ent.func_70644_a(Effects.field_76430_j)) {
            f += 0.1f * (float)(ent.func_70660_b(Effects.field_76430_j).func_76458_c() + 1);
        }
        Vector3d vector3d = ent.func_213322_ci();
        ent.func_213293_j(vector3d.field_72450_a, (double)f, vector3d.field_72449_c);
        if (ent.func_70051_ag()) {
            float f1 = ent.field_70177_z * ((float)Math.PI / 180);
            ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)f1) * 0.2f), 0.0, (double)(MathHelper.func_76134_b((float)f1) * 0.2f)));
        }
        ent.field_70160_al = true;
        ForgeHooks.onLivingJump((LivingEntity)ent);
    }

    public static float getJumpFactor(LivingEntity ent) {
        float f = ent.field_70170_p.func_180495_p(ent.func_233580_cy_()).func_177230_c().func_226892_n_();
        float f1 = ent.field_70170_p.func_180495_p(PosessionHelper.getPositionUnderneath(ent)).func_177230_c().func_226892_n_();
        return (double)f == 1.0 ? f1 : f;
    }
}

