/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.shapes;

import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.api.spells.targeting.SpellTargetHelper;
import com.ma.entities.sorcery.targeting.EntitySpellRune;
import com.ma.spells.shapes.ShapeRaytrace;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ShapeRune
extends ShapeRaytrace {
    public ShapeRune(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.RADIUS, 1.0f, 1.0f, 3.0f, 1.0f, 5.0f), new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 5.0f), new AttributeValuePair(Attribute.RANGE, 3.0f, 3.0f, 16.0f, 1.0f, 3.0f));
    }

    @Override
    public List<SpellTarget> Target(SpellSource source, World world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        BlockRayTraceResult brtr;
        if (!source.isPlayerCaster()) {
            return Arrays.asList(SpellTarget.NONE);
        }
        float range = modificationData.getValue(Attribute.RANGE);
        RayTraceResult targetResult = SpellTargetHelper.rayTrace((Entity)source.getCaster(), world, source.getOrigin(), source.getForward(), true, false, RayTraceContext.BlockMode.OUTLINE, entity -> entity.func_70067_L() && entity.func_70089_S() && entity != source.getCaster(), source.getBoundingBox().func_72314_b((double)range, (double)range, (double)range), range);
        RayTraceResult.Type targetType = targetResult.func_216346_c();
        if (targetType == RayTraceResult.Type.MISS) {
            return Arrays.asList(SpellTarget.NONE);
        }
        Vector3d runePos = targetResult.func_216347_e();
        if (targetType == RayTraceResult.Type.BLOCK && (brtr = (BlockRayTraceResult)targetResult).func_216354_b() != Direction.UP) {
            runePos.func_72441_c((double)brtr.func_216354_b().func_82601_c(), (double)brtr.func_216354_b().func_96559_d(), (double)brtr.func_216354_b().func_82599_e());
        }
        if (!world.field_72995_K) {
            EntitySpellRune rune = new EntitySpellRune(source.getPlayer(), recipe);
            BlockPos pos = new BlockPos(runePos);
            if (world.func_217357_a(Entity.class, new AxisAlignedBB(pos)).size() != 0) {
                return Arrays.asList(SpellTarget.NONE);
            }
            rune.func_70107_b((float)pos.func_177958_n() + 0.5f, runePos.func_82617_b() + 0.01, (float)pos.func_177952_p() + 0.5f);
            world.func_217376_c((Entity)rune);
        }
        return Arrays.asList(new SpellTarget((Entity)source.getPlayer()));
    }

    @Override
    public boolean spawnsTargetEntity() {
        return true;
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 250;
    }
}

