/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.utility.StationaryBlockEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ComponentTransitoryTunnel
extends Component {
    public ComponentTransitoryTunnel(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.DURATION, 5.0f, 1.0f, 15.0f, 1.0f));
    }

    @Override
    public int requiredXPForRote() {
        return 2000;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target.isBlock()) {
            BlockState state;
            BlockPos pos = target.getBlock();
            if (!context.getWorld().func_175623_d(pos) && context.getWorld().func_180495_p(pos).func_204520_s().func_206888_e() && !(state = context.getWorld().func_180495_p(pos)).func_177230_c().hasTileEntity(state) && state.func_177230_c() != Blocks.field_150357_h) {
                StationaryBlockEntity fbe = new StationaryBlockEntity((World)context.getWorld(), (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, state);
                fbe.func_184530_a(pos);
                fbe.setMaxAge((int)(modificationData.getValue(Attribute.DURATION) * 20.0f));
                context.getWorld().func_217376_c((Entity)fbe);
                return ComponentApplicationResult.SUCCESS;
            }
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public boolean targetsEntities() {
        return false;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ENDER;
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

