/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.DamageTypes;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IDamageComponent;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.tools.BlockUtils;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ComponentFrostDamage
extends Component
implements IDamageComponent {
    public ComponentFrostDamage(ResourceLocation registryName, ResourceLocation icon) {
        super(registryName, icon, new AttributeValuePair(Attribute.DAMAGE, 5.0f, 1.0f, 20.0f, 0.5f, 3.0f), new AttributeValuePair(Attribute.DURATION, 3.0f, 0.0f, 10.0f, 1.0f, 2.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (target.isEntity()) {
            if (!(target.getEntity() instanceof ItemEntity) && !(target.getEntity() instanceof ExperienceOrbEntity)) {
                target.getEntity().func_70097_a(DamageTypes.causeSourcedFrostDamage(source.getCaster()), modificationData.getValue(Attribute.DAMAGE));
                if (target.isLivingEntity()) {
                    target.getLivingEntity().func_195064_c(new EffectInstance(Effects.field_76421_d, (int)modificationData.getValue(Attribute.DURATION) * 20));
                }
                return ComponentApplicationResult.SUCCESS;
            }
        } else if (target.isBlock()) {
            BlockState state = context.getWorld().func_180495_p(target.getBlock());
            if (state.func_177230_c() == Blocks.field_150355_j && state.func_235901_b_((Property)FlowingFluidBlock.field_176367_b)) {
                if ((Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0) {
                    BlockUtils.placeBlock(context.getWorld(), target.getBlock(), Direction.UP, modificationData.getValue(Attribute.DAMAGE) >= 10.0f ? Blocks.field_150432_aD.func_176223_P() : Blocks.field_185778_de.func_176223_P(), source.getPlayer());
                    return ComponentApplicationResult.SUCCESS;
                }
            } else {
                if (state.func_177230_c() == Blocks.field_150353_l && state.func_235901_b_((Property)FlowingFluidBlock.field_176367_b) && modificationData.getValue(Attribute.DAMAGE) >= 10.0f) {
                    if ((Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0) {
                        BlockUtils.placeBlock(context.getWorld(), target.getBlock(), Direction.UP, Blocks.field_150343_Z.func_176223_P(), source.getPlayer());
                    } else {
                        BlockUtils.placeBlock(context.getWorld(), target.getBlock(), Direction.UP, Blocks.field_150347_e.func_176223_P(), source.getPlayer());
                    }
                    return ComponentApplicationResult.SUCCESS;
                }
                if (state.func_177230_c() == Blocks.field_150480_ab && BlockUtils.destroyBlock(source.getCaster(), (World)context.getWorld(), target.getBlock(), false, 1, new ToolType[0])) {
                    BlockUtils.updateBlockState((World)context.getWorld(), target.getBlock());
                    return ComponentApplicationResult.SUCCESS;
                }
            }
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.ICE;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ICE;
    }

    @Override
    public void SpawnParticles(World world, Vector3d impact_position, int age, PlayerEntity caster, ISpellDefinition recipe) {
        Random rndm = new Random(1234L);
        if (age < 5) {
            for (int i = 0; i < 25; ++i) {
                world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), impact_position.field_72450_a + (double)rndm.nextFloat() - 0.5, impact_position.field_72448_b + (double)rndm.nextFloat() - 0.5, impact_position.field_72449_c + (double)rndm.nextFloat() - 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.HARMFUL;
    }
}

